/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.types.traits;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.exporters.script.Dependency;
import com.jpexs.decompiler.flash.exporters.script.DependencyParser;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.flash.search.MethodId;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.helpers.Helper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class TraitMethodGetterSetter
extends Trait {
    public int disp_id;
    public int method_info;

    @Override
    public void delete(ABC abc, boolean d) {
        abc.constants.getMultiname((int)this.name_index).deleted = d;
        abc.method_info.get(this.method_info).delete(abc, d);
    }

    @Override
    public String toString(ABC abc, List<DottedChain> fullyQualifiedNames) {
        return "0x" + Helper.formatAddress(this.fileOffset) + " " + Helper.byteArrToString(this.bytes) + " MethodGetterSetter " + abc.constants.getMultiname(this.name_index).toString(abc.constants, fullyQualifiedNames) + " disp_id=" + this.disp_id + " method_info=" + this.method_info + " metadata=" + Helper.intArrToString(this.metadata);
    }

    @Override
    public void convertHeader(Trait parent, ConvertData convertData, String path, ABC abc, boolean isStatic, ScriptExportMode exportMode, int scriptIndex, int classIndex, NulWriter writer, List<DottedChain> fullyQualifiedNames, boolean parallel) {
    }

    @Override
    public void getDependencies(int scriptIndex, int classIndex, boolean isStatic, String customNs, ABC abc, List<Dependency> dependencies, List<String> uses, DottedChain ignorePackage, List<DottedChain> fullyQualifiedNames) throws InterruptedException {
        if (ignorePackage == null) {
            ignorePackage = this.getPackage(abc);
        }
        super.getDependencies(scriptIndex, classIndex, isStatic, customNs, abc, dependencies, uses, ignorePackage, fullyQualifiedNames);
        if (customNs == null) {
            Namespace n = this.getName(abc).getNamespace(abc.constants);
            if (n.kind == 8) {
                customNs = n.getName(abc.constants).toRawString();
            }
        }
        DependencyParser.parseDependenciesFromMethodInfo(this, scriptIndex, classIndex, isStatic, customNs, abc, this.method_info, dependencies, uses, ignorePackage, fullyQualifiedNames, new ArrayList<Integer>());
    }

    @Override
    public GraphTextWriter toStringHeader(Trait parent, ConvertData convertData, String path, ABC abc, boolean isStatic, ScriptExportMode exportMode, int scriptIndex, int classIndex, GraphTextWriter writer, List<DottedChain> fullyQualifiedNames, boolean parallel) {
        String addKind = "";
        if (this.kindType == 2) {
            addKind = "get ";
        }
        if (this.kindType == 3) {
            addKind = "set ";
        }
        MethodBody body = abc.findBody(this.method_info);
        if (!(classIndex != -1 && abc.instance_info.get(classIndex).isInterface() || body != null)) {
            writer.appendNoHilight("native ");
        }
        this.getModifiers(abc, isStatic, writer);
        writer.hilightSpecial("function " + addKind, HighlightSpecialType.TRAIT_TYPE);
        writer.hilightSpecial(this.getName(abc).getName(abc.constants, fullyQualifiedNames, false, true), HighlightSpecialType.TRAIT_NAME);
        writer.appendNoHilight("(");
        abc.method_info.get(this.method_info).getParamStr(writer, abc.constants, body, abc, fullyQualifiedNames);
        writer.appendNoHilight(") : ");
        abc.method_info.get(this.method_info).getReturnTypeStr(writer, abc.constants, fullyQualifiedNames);
        return writer;
    }

    @Override
    public void convert(Trait parent, ConvertData convertData, String path, ABC abc, boolean isStatic, ScriptExportMode exportMode, int scriptIndex, int classIndex, NulWriter writer, List<DottedChain> fullyQualifiedNames, boolean parallel) throws InterruptedException {
        if (classIndex < 0) {
            this.writeImportsUsages(scriptIndex, classIndex, isStatic, abc, writer, this.getPackage(abc), fullyQualifiedNames);
        }
        writer.startMethod(this.method_info);
        path = path + "." + this.getName(abc).getName(abc.constants, fullyQualifiedNames, false, true);
        this.convertHeader(parent, convertData, path, abc, isStatic, exportMode, scriptIndex, classIndex, writer, fullyQualifiedNames, parallel);
        int bodyIndex = abc.findBodyIndex(this.method_info);
        if (!(exportMode == ScriptExportMode.AS_METHOD_STUBS || classIndex != -1 && abc.instance_info.get(classIndex).isInterface() || bodyIndex == -1 || bodyIndex == -1)) {
            abc.bodies.get(bodyIndex).convert(convertData, path, exportMode, isStatic, this.method_info, scriptIndex, classIndex, abc, this, new ScopeStack(), 0, writer, fullyQualifiedNames, null, true, new HashSet<Integer>());
        }
        writer.endMethod();
    }

    @Override
    public GraphTextWriter toString(Trait parent, ConvertData convertData, String path, ABC abc, boolean isStatic, ScriptExportMode exportMode, int scriptIndex, int classIndex, GraphTextWriter writer, List<DottedChain> fullyQualifiedNames, boolean parallel) throws InterruptedException {
        if (classIndex < 0) {
            this.writeImportsUsages(scriptIndex, classIndex, isStatic, abc, writer, this.getPackage(abc), fullyQualifiedNames);
        }
        this.getMetaData(parent, convertData, abc, writer);
        writer.startMethod(this.method_info);
        path = path + "." + this.getName(abc).getName(abc.constants, fullyQualifiedNames, false, true);
        this.toStringHeader(parent, convertData, path, abc, isStatic, exportMode, scriptIndex, classIndex, writer, fullyQualifiedNames, parallel);
        int bodyIndex = abc.findBodyIndex(this.method_info);
        if (classIndex != -1 && abc.instance_info.get(classIndex).isInterface() || bodyIndex == -1) {
            writer.appendNoHilight(";");
        } else {
            writer.startBlock();
            if (exportMode != ScriptExportMode.AS_METHOD_STUBS) {
                if (exportMode != ScriptExportMode.AS) {
                    this.convertTraitHeader(abc, writer);
                }
                if (bodyIndex != -1) {
                    abc.bodies.get(bodyIndex).toString(path, exportMode, abc, this, writer, fullyQualifiedNames, new HashSet<Integer>());
                }
            } else {
                String retTypeRaw;
                switch (retTypeRaw = abc.method_info.get(this.method_info).getReturnTypeRaw(abc.constants, fullyQualifiedNames)) {
                    case "void": {
                        break;
                    }
                    case "int": 
                    case "uint": {
                        writer.append("return 0; //autogenerated").newLine();
                        break;
                    }
                    case "double": 
                    case "float": {
                        writer.append("return 0.0; //autogenerated").newLine();
                        break;
                    }
                    case "String": {
                        writer.append("return \"\"; //autogenerated").newLine();
                        break;
                    }
                    default: {
                        writer.append("return null; //autogenerated").newLine();
                    }
                }
            }
            writer.endBlock();
        }
        writer.newLine();
        writer.endMethod();
        return writer;
    }

    @Override
    public int removeTraps(int scriptIndex, int classIndex, boolean isStatic, ABC abc, String path) throws InterruptedException {
        int bodyIndex = abc.findBodyIndex(this.method_info);
        if (bodyIndex != -1) {
            return abc.bodies.get(bodyIndex).removeTraps(abc, this, scriptIndex, classIndex, isStatic, path);
        }
        return 0;
    }

    @Override
    public TraitMethodGetterSetter clone() {
        TraitMethodGetterSetter ret = (TraitMethodGetterSetter)super.clone();
        return ret;
    }

    @Override
    public boolean isVisible(boolean isStatic, ABC abc) {
        if (Configuration.handleSkinPartsAutomatically.get().booleanValue() && "skinParts".equals(this.getName(abc).getName(abc.constants, new ArrayList<DottedChain>(), true, true)) && this.kindType == 2) {
            MethodInfo mi = abc.method_info.get(this.method_info);
            if (mi.param_types.length == 0 && "Object".equals(abc.constants.getMultiname(mi.ret_type).getNameWithNamespace(abc.constants, true).toRawString()) && abc.constants.getNamespace((int)abc.constants.getMultiname((int)this.name_index).namespace_index).kind == 24) {
                return false;
            }
        }
        return true;
    }

    @Override
    public GraphTextWriter convertTraitHeader(ABC abc, GraphTextWriter writer) {
        switch (this.kindType) {
            case 1: {
                this.convertCommonHeaderFlags("method", abc, writer);
                break;
            }
            case 2: {
                this.convertCommonHeaderFlags("getter", abc, writer);
                break;
            }
            case 3: {
                this.convertCommonHeaderFlags("setter", abc, writer);
            }
        }
        writer.newLine();
        writer.appendNoHilight("dispid ");
        writer.hilightSpecial("" + this.disp_id, HighlightSpecialType.DISP_ID);
        writer.newLine();
        return writer;
    }

    @Override
    public void getMethodInfos(ABC abc, int traitId, int classIndex, List<MethodId> methodInfos) {
        methodInfos.add(new MethodId(traitId, classIndex, this.method_info));
    }
}

