/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.instructions.other;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2InstructionFlag;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.instructions.SetTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.model.DecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetSlotAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IncrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.LocalRegAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewActivationAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.PostDecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.PostIncrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetSlotAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.PreDecrementAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.operations.PreIncrementAVM2Item;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.CompoundableBinaryOp;
import com.jpexs.helpers.Reference;
import java.util.List;
import java.util.Objects;

public class SetSlotIns
extends InstructionDefinition
implements SetTypeIns {
    public SetSlotIns() {
        super(109, "setslot", new int[]{265}, true, new AVM2InstructionFlag[0]);
    }

    @Override
    public void translate(AVM2LocalData localData, TranslateStack stack, AVM2Instruction ins, List<GraphTargetItem> output, String path) {
        int slotIndex = ins.operands[0];
        GraphTargetItem value = stack.pop();
        GraphTargetItem obj = stack.pop();
        if (obj.getThroughRegister() instanceof NewActivationAVM2Item) {
            ((NewActivationAVM2Item)obj.getThroughRegister()).slots.put(slotIndex, value);
        }
        SetSlotIns.handleSetSlot(localData, stack, ins, output, slotIndex, obj, value);
    }

    public static void handleSetSlot(AVM2LocalData localData, TranslateStack stack, AVM2Instruction ins, List<GraphTargetItem> output, int slotIndex, GraphTargetItem obj, GraphTargetItem value) {
        CompoundableBinaryOp binaryOp;
        GetSlotAVM2Item slotItem;
        GraphTargetItem inside;
        GraphTargetItem objnoreg = obj;
        obj = obj.getThroughRegister();
        Reference<Object> realObjRef = new Reference<Object>(null);
        Multiname slotname = InstructionDefinition.searchSlotName(slotIndex, localData, obj, realObjRef);
        GraphTargetItem realObj = realObjRef.getVal();
        if (realObj != null) {
            obj = realObj;
        }
        if (slotname != null && value instanceof LocalRegAVM2Item) {
            LocalRegAVM2Item lr = (LocalRegAVM2Item)value;
            String slotNameStr = slotname.getName(localData.getConstants(), localData.fullyQualifiedNames, true, true);
            if (localData.localRegNames.containsKey(lr.regIndex) && localData.localRegNames.get(lr.regIndex).equals(slotNameStr)) {
                return;
            }
        }
        if (value.getNotCoerced().getThroughDuplicate() instanceof IncrementAVM2Item && (inside = ((IncrementAVM2Item)value.getNotCoerced()).value.getThroughRegister().getNotCoerced().getThroughDuplicate()) instanceof GetSlotAVM2Item) {
            slotItem = (GetSlotAVM2Item)inside;
            if (slotItem.scope.getThroughRegister() == obj.getThroughRegister() && slotItem.slotName == slotname) {
                if (stack.size() > 0) {
                    GraphTargetItem top = stack.peek().getNotCoerced().getThroughDuplicate();
                    if (top == inside) {
                        stack.pop();
                        stack.push(new PostIncrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside));
                    } else if (top instanceof IncrementAVM2Item && ((IncrementAVM2Item)top).value == inside) {
                        stack.pop();
                        stack.push(new PreIncrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside));
                    } else {
                        output.add(new PostIncrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside));
                    }
                } else {
                    output.add(new PostIncrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside));
                }
                return;
            }
        }
        if (value.getNotCoerced().getThroughDuplicate() instanceof DecrementAVM2Item && (inside = ((DecrementAVM2Item)value.getNotCoerced()).value.getThroughRegister().getNotCoerced().getThroughDuplicate()) instanceof GetSlotAVM2Item) {
            slotItem = (GetSlotAVM2Item)inside;
            if (slotItem.scope.getThroughRegister() == obj.getThroughRegister() && slotItem.slotName == slotname) {
                if (stack.size() > 0) {
                    GraphTargetItem top = stack.peek().getNotCoerced().getThroughDuplicate();
                    if (top == inside) {
                        stack.pop();
                        stack.push(new PostDecrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside));
                    } else if (top instanceof DecrementAVM2Item && ((DecrementAVM2Item)top).value == inside) {
                        stack.pop();
                        stack.push(new PreDecrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside));
                    } else {
                        output.add(new PostDecrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside));
                    }
                } else {
                    output.add(new PostDecrementAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, inside));
                }
                return;
            }
        }
        SetSlotAVM2Item result = new SetSlotAVM2Item(ins, localData.lineStartInstruction, obj, objnoreg, slotIndex, slotname, value);
        if (value.getNotCoerced() instanceof CompoundableBinaryOp && !obj.hasSideEffect() && (binaryOp = (CompoundableBinaryOp)((Object)value.getNotCoerced())).getLeftSide() instanceof GetSlotAVM2Item) {
            GetSlotAVM2Item getSlot = (GetSlotAVM2Item)binaryOp.getLeftSide();
            if (Objects.equals(obj, getSlot.scope.getThroughDuplicate()) && slotIndex == getSlot.slotIndex) {
                result.compoundValue = binaryOp.getRightSide();
                result.compoundOperator = binaryOp.getOperator();
            }
        }
        SetTypeIns.handleResult(value, stack, output, localData, result, -1);
    }

    @Override
    public int getStackPopCount(AVM2Instruction ins, ABC abc) {
        return 2;
    }
}

