/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.deobfuscation;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.FixItemCounterTranslateStack;
import com.jpexs.decompiler.flash.abc.avm2.deobfuscation.AVM2DeobfuscatorZeroJumpsNullPushes;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.DeobfuscatePopIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.IfTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.AddIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.AddIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.DecrementIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.DecrementIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.DivideIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.IncrementIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.IncrementIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.ModuloIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.MultiplyIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.MultiplyIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.NegateIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.NegateIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.NotIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.SubtractIIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.arithmetic.SubtractIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.bitwise.BitAndIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.bitwise.BitNotIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.bitwise.BitOrIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.bitwise.BitXorIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.bitwise.LShiftIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.bitwise.RShiftIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.bitwise.URShiftIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.comparison.EqualsIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.comparison.GreaterEqualsIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.comparison.GreaterThanIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.comparison.LessEqualsIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.comparison.LessThanIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.comparison.StrictEqualsIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.ConstructIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.NewArrayIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.NewFunctionIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.NewObjectIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.debug.DebugFileIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.debug.DebugIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.debug.DebugLineIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.executing.CallIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.jumps.JumpIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.GetLocalTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.localregs.SetLocalTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.GetPropertyIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.NopIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.DupIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PopIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushByteIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushDoubleIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushFalseIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushIntIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushNullIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushShortIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushStringIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushTrueIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushUndefinedIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.SwapIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.CoerceOrConvertTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.TypeOfIns;
import com.jpexs.decompiler.flash.abc.avm2.model.FloatValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.IntegerValueAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewArrayAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewFunctionAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NullAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.StringAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.UndefinedAVM2Item;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.ecma.Null;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.NotCompileTimeItem;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.decompiler.graph.TranslateException;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.FalseItem;
import com.jpexs.decompiler.graph.model.TrueItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AVM2DeobfuscatorSimpleOld
extends AVM2DeobfuscatorZeroJumpsNullPushes {
    private static final UndefinedAVM2Item UNDEFINED_ITEM = new UndefinedAVM2Item(null, null);
    private static final NotCompileTimeItem NOT_COMPILE_TIME_UNDEFINED_ITEM = new NotCompileTimeItem(null, null, UNDEFINED_ITEM);
    private final int executionLimit = 30000;

    protected AVM2Instruction makePush(AVM2ConstantPool cpool, GraphTargetItem graphTargetItem) {
        if (graphTargetItem instanceof IntegerValueAVM2Item) {
            IntegerValueAVM2Item iv = (IntegerValueAVM2Item)graphTargetItem;
            return cpool.makePush(iv.value);
        }
        if (graphTargetItem instanceof FloatValueAVM2Item) {
            FloatValueAVM2Item fv = (FloatValueAVM2Item)graphTargetItem;
            return cpool.makePush(fv.value);
        }
        if (graphTargetItem instanceof StringAVM2Item) {
            StringAVM2Item fv = (StringAVM2Item)graphTargetItem;
            return cpool.makePush(fv.getValue());
        }
        if (graphTargetItem instanceof TrueItem) {
            return cpool.makePush(Boolean.TRUE);
        }
        if (graphTargetItem instanceof FalseItem) {
            return cpool.makePush(Boolean.FALSE);
        }
        if (graphTargetItem instanceof NullAVM2Item) {
            return cpool.makePush(Null.INSTANCE);
        }
        if (graphTargetItem instanceof UndefinedAVM2Item) {
            return cpool.makePush(Undefined.INSTANCE);
        }
        return null;
    }

    protected boolean removeObfuscationIfs(int classIndex, boolean isStatic, int scriptIndex, ABC abc, MethodBody body, List<AVM2Instruction> inlineIns) throws InterruptedException {
        AVM2Code code = body.getCode();
        if (code.code.isEmpty()) {
            return false;
        }
        HashMap<Integer, GraphTargetItem> staticRegs = new HashMap<Integer, GraphTargetItem>();
        for (AVM2Instruction ins : inlineIns) {
            if (!(ins.definition instanceof GetLocalTypeIns)) continue;
            staticRegs.put(((GetLocalTypeIns)ins.definition).getRegisterId(ins), new UndefinedAVM2Item(ins, null));
        }
        if (code.code.isEmpty()) {
            return false;
        }
        ArrayList<Integer> jumpTargets = new ArrayList<Integer>();
        for (int i = 0; i < code.code.size(); ++i) {
            AVM2Instruction ins = code.code.get(i);
            if (!(ins.definition instanceof JumpIns)) continue;
            long address = ins.getTargetAddress();
            jumpTargets.add(code.adr2pos(address));
        }
        AVM2LocalData localData = this.newLocalData(scriptIndex, abc, abc.constants, body, isStatic, classIndex);
        int localReservedCount = body.getLocalReservedCount();
        Set<Long> importantOffsets = code.getImportantOffsets(body, isStatic);
        for (int i = 0; i < code.code.size(); ++i) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            localData.scopeStack.clear();
            localData.localRegs.clear();
            localData.localRegAssignmentIps.clear();
            localData.localRegs.clear();
            this.initLocalRegs(localData, localReservedCount, body.max_regs);
            if (!this.executeInstructions(importantOffsets, staticRegs, body, abc, code, localData, i, code.code.size() - 1, null, inlineIns, jumpTargets)) continue;
            i = -1;
        }
        return false;
    }

    protected AVM2LocalData newLocalData(int scriptIndex, ABC abc, AVM2ConstantPool cpool, MethodBody body, boolean isStatic, int classIndex) {
        AVM2LocalData localData = new AVM2LocalData();
        localData.isStatic = isStatic;
        localData.classIndex = classIndex;
        localData.localRegs = new HashMap(body.max_regs);
        localData.localRegAssignmentIps = new HashMap();
        localData.scopeStack = new ScopeStack(true);
        localData.methodBody = body;
        localData.abc = abc;
        localData.localRegNames = new HashMap();
        localData.scriptIndex = scriptIndex;
        localData.ip = 0;
        localData.code = body.getCode();
        return localData;
    }

    protected void initLocalRegs(AVM2LocalData localData, int localReservedCount, int maxRegs) {
        int i;
        for (i = 0; i < localReservedCount; ++i) {
            localData.localRegs.put(i, NOT_COMPILE_TIME_UNDEFINED_ITEM);
        }
        for (i = localReservedCount; i < maxRegs; ++i) {
            localData.localRegs.put(i, UNDEFINED_ITEM);
        }
    }

    private boolean executeInstructions(Set<Long> importantOffsets, Map<Integer, GraphTargetItem> staticRegs, MethodBody body, ABC abc, AVM2Code code, AVM2LocalData localData, int idx, int endIdx, ExecutionResult result, List<AVM2Instruction> inlineIns, List<Integer> jumpTargets) throws InterruptedException {
        ArrayList<GraphTargetItem> output = new ArrayList<GraphTargetItem>();
        FixItemCounterTranslateStack stack = new FixItemCounterTranslateStack("");
        int instructionsProcessed = 0;
        endIdx = code.code.size() - 1;
        while (idx <= endIdx && instructionsProcessed <= 30000) {
            int regId;
            InstructionDefinition prevDef;
            AVM2Instruction ins = code.code.get(idx);
            InstructionDefinition def = ins.definition;
            int requiredStackSize = ins.getStackPopCount(localData);
            if (stack.size() < requiredStackSize) {
                return false;
            }
            if (def instanceof DupIns) {
                stack.simplify();
            }
            if (def instanceof PopIns && !stack.isEmpty() && stack.peek() instanceof NewFunctionAVM2Item) {
                AVM2Instruction nins;
                AVM2Instruction fins = (AVM2Instruction)stack.peek().getSrc();
                AVM2Instruction aVM2Instruction = nins = idx + 1 < code.code.size() ? code.code.get(idx + 1) : null;
                if (fins.definition instanceof NewFunctionIns) {
                    int fidx = code.code.indexOf(fins);
                    code.removeInstruction(fidx, body);
                }
                int nidx = code.code.indexOf(ins);
                code.removeInstruction(nidx, body);
                idx = nins == null ? code.code.size() : code.code.indexOf(nins);
                importantOffsets.clear();
                importantOffsets.addAll(code.getImportantOffsets(body, false));
                continue;
            }
            ins.translate(localData, stack, output, 0, "");
            if (inlineIns.contains(ins) && def instanceof SetLocalTypeIns && ((prevDef = code.code.get((int)(idx - 1)).definition) instanceof DupIns && !jumpTargets.contains(idx - 2) || !jumpTargets.contains(idx - 1))) {
                int regId2 = ((SetLocalTypeIns)def).getRegisterId(ins);
                staticRegs.put(regId2, localData.localRegs.get(regId2).getNotCoerced());
                code.replaceInstruction(idx, new AVM2Instruction(0L, DeobfuscatePopIns.getInstance(), null), body);
                importantOffsets.clear();
                importantOffsets.addAll(code.getImportantOffsets(body, false));
            }
            if (def instanceof GetLocalTypeIns && staticRegs.containsKey(regId = ((GetLocalTypeIns)def).getRegisterId(ins))) {
                if (stack.isEmpty()) {
                    return false;
                }
                stack.pop();
                AVM2Instruction pushins = this.makePush(abc.constants, staticRegs.get(regId));
                if (pushins == null) {
                    return false;
                }
                code.replaceInstruction(idx, pushins, body);
                stack.push(staticRegs.get(regId));
                ins = pushins;
                def = ins.definition;
                importantOffsets.clear();
                importantOffsets.addAll(code.getImportantOffsets(body, false));
            }
            boolean ok = false;
            if (def instanceof PushByteIns || def instanceof PushShortIns || def instanceof PushIntIns || def instanceof PushDoubleIns || def instanceof PushStringIns || def instanceof PushNullIns || def instanceof PushUndefinedIns || def instanceof PushFalseIns || def instanceof PushTrueIns || def instanceof DupIns || def instanceof SwapIns || def instanceof AddIns || def instanceof AddIIns || def instanceof SubtractIns || def instanceof SubtractIIns || def instanceof ModuloIns || def instanceof MultiplyIns || def instanceof MultiplyIIns || def instanceof DivideIns || def instanceof BitAndIns || def instanceof BitXorIns || def instanceof BitOrIns || def instanceof LShiftIns || def instanceof RShiftIns || def instanceof URShiftIns || def instanceof EqualsIns || def instanceof NotIns || def instanceof NegateIns || def instanceof NegateIIns || def instanceof IncrementIns || def instanceof IncrementIIns || def instanceof DecrementIns || def instanceof DecrementIIns || def instanceof IfTypeIns || def instanceof JumpIns || def instanceof EqualsIns || def instanceof LessEqualsIns || def instanceof GreaterEqualsIns || def instanceof GreaterThanIns || def instanceof LessThanIns || def instanceof BitNotIns || def instanceof StrictEqualsIns || def instanceof PopIns || def instanceof GetLocalTypeIns || def instanceof NewFunctionIns || def instanceof NewArrayIns || def instanceof NewObjectIns || def instanceof GetPropertyIns || def instanceof CoerceOrConvertTypeIns || def instanceof ConstructIns || def instanceof CallIns || def instanceof TypeOfIns || def instanceof DebugLineIns || def instanceof DebugFileIns || def instanceof DebugIns || def instanceof NopIns) {
                ok = true;
            }
            if (def instanceof GetPropertyIns) {
                GetPropertyAVM2Item avi = (GetPropertyAVM2Item)stack.peek();
                ok = false;
                if (avi.object instanceof NewArrayAVM2Item && ((NewArrayAVM2Item)avi.object).values.isEmpty()) {
                    stack.pop();
                    stack.push(new UndefinedAVM2Item(null, null));
                    ok = true;
                }
            }
            if (!ok) break;
            if (def instanceof GetLocalTypeIns) {
                int regId3 = ((GetLocalTypeIns)def).getRegisterId(ins);
                if (staticRegs.containsKey(regId3)) {
                    if (stack.isEmpty()) {
                        return false;
                    }
                    stack.pop();
                    stack.push(staticRegs.get(regId3));
                } else if (regId3 > 0) break;
            }
            boolean ifed = false;
            if (def instanceof PopIns) {
                code.replaceInstruction(idx, new AVM2Instruction(ins.getAddress(), DeobfuscatePopIns.getInstance(), null), body);
                ++idx;
            } else if (def instanceof JumpIns) {
                long address = ins.getTargetAddress();
                idx = code.adr2pos(address);
                if (idx == -1) {
                    throw new TranslateException("Jump target not found: " + address);
                }
            } else {
                if (def instanceof IfTypeIns) {
                    long ifAddress = code.pos2adr(idx);
                    if (importantOffsets.contains(ifAddress)) {
                        return false;
                    }
                    if (stack.isEmpty()) {
                        return false;
                    }
                    GraphTargetItem top = stack.pop();
                    Boolean res = top.getResultAsBoolean();
                    long address = ins.getTargetAddress();
                    int nidx = code.adr2pos(address);
                    AVM2Instruction tarIns = code.code.get(nidx);
                    int stackCount = -def.getStackDelta(ins, abc);
                    if (res.booleanValue()) {
                        AVM2Instruction jumpIns = new AVM2Instruction(0L, 16, new int[]{0});
                        code.replaceInstruction(idx, jumpIns, body);
                        jumpIns.operands[0] = (int)(tarIns.getAddress() - jumpIns.getAddress() - (long)jumpIns.getBytesLength());
                        for (int s = 0; s < stackCount; ++s) {
                            code.insertInstruction(idx, new AVM2Instruction(ins.getAddress(), DeobfuscatePopIns.getInstance(), null), true, body);
                        }
                        idx = code.adr2pos(jumpIns.getTargetAddress());
                    } else {
                        code.replaceInstruction(idx, new AVM2Instruction(ins.getAddress(), DeobfuscatePopIns.getInstance(), null), body);
                        for (int s = 1; s < stackCount; ++s) {
                            code.insertInstruction(idx, new AVM2Instruction(ins.getAddress(), DeobfuscatePopIns.getInstance(), null), true, body);
                        }
                        ++idx;
                    }
                    code.removeDeadCode(body);
                    this.removeZeroJumps(code, body);
                    importantOffsets.clear();
                    importantOffsets.addAll(code.getImportantOffsets(body, false));
                    return true;
                }
                ++idx;
            }
            ++instructionsProcessed;
            if (result != null && stack.allItemsFixed()) {
                result.idx = idx == code.code.size() ? idx - 1 : idx;
                result.instructionsProcessed = instructionsProcessed;
                result.stack.clear();
                result.stack.addAll(stack);
            }
            if (!ifed) continue;
        }
        return false;
    }

    @Override
    public void avm2CodeRemoveTraps(String path, int classIndex, boolean isStatic, int scriptIndex, ABC abc, Trait trait, int methodInfo, MethodBody body) throws InterruptedException {
        AVM2Code code = body.getCode();
        code.removeDeadCode(body);
        this.removeObfuscationIfs(classIndex, isStatic, scriptIndex, abc, body, new ArrayList<AVM2Instruction>());
        this.removeZeroJumps(code, body);
        this.removeNullPushes(code, body);
    }

    class ExecutionResult {
        public int idx = -1;
        public int instructionsProcessed = -1;
        public TranslateStack stack = new TranslateStack("?");

        ExecutionResult() {
        }
    }
}

