/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.proxy;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.RunnableIOEx;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppFrame;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.GuiAbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainFrame;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.helpers.SWFDecompilerPlugin;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.utf8.Utf8InputStreamReader;
import com.jpexs.helpers.utf8.Utf8OutputStreamWriter;
import com.jpexs.proxy.CatchedListener;
import com.jpexs.proxy.ReplacedListener;
import com.jpexs.proxy.Replacement;
import com.jpexs.proxy.Server;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;

public class ProxyFrame
extends AppFrame
implements CatchedListener,
MouseListener,
ReplacedListener {
    private static final String REPLACEMENTS_NAME = "replacements.cfg";
    private JTable replacementsTable;
    private JButton switchButton = new JButton(this.translate("proxy.start"));
    private boolean started = false;
    private JTextField portField = new JTextField("55555");
    private JCheckBox sniffSWFCheckBox = new JCheckBox("SWF", false);
    private JCheckBox sniffOSCheckBox = new JCheckBox("OctetStream", false);
    private JCheckBox sniffJSCheckBox = new JCheckBox("JS", false);
    private JCheckBox sniffXMLCheckBox = new JCheckBox("XML", false);
    DefaultTableModel tableModel;
    private SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
    private static List<Replacement> replacements = new ArrayList<Replacement>();

    public boolean isRunning() {
        return this.started;
    }

    public void setPort(int port) {
        this.portField.setText(Integer.toString(port));
    }

    private static void saveReplacements() {
        String replacementsFile = ProxyFrame.getReplacementsFile();
        if (replacements.isEmpty()) {
            File rf = new File(replacementsFile);
            if (rf.exists() && !rf.delete()) {
                Logger.getLogger(ProxyFrame.class.getName()).log(Level.SEVERE, "Cannot delete replacements file");
            }
        } else {
            try (PrintWriter pw = new PrintWriter((Writer)new Utf8OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(replacementsFile))));){
                for (Replacement r : replacements) {
                    pw.println(r.urlPattern);
                    pw.println(r.targetFile);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ProxyFrame.class.getName()).log(Level.SEVERE, "Exception during saving replacements", ex);
            }
        }
    }

    private static void loadReplacements() {
        String replacementsFile = ProxyFrame.getReplacementsFile();
        if (!new File(replacementsFile).exists()) {
            return;
        }
        replacements = new ArrayList<Replacement>();
        try (BufferedReader br = new BufferedReader((Reader)new Utf8InputStreamReader((InputStream)new FileInputStream(replacementsFile)));){
            String s;
            while ((s = br.readLine()) != null) {
                Replacement r = new Replacement(s, br.readLine());
                replacements.add(r);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getReplacementsFile() {
        return Configuration.getFFDecHome() + REPLACEMENTS_NAME;
    }

    public ProxyFrame(final MainFrame mainFrame) {
        Object[] columnNames = new String[]{this.translate("column.accessed"), this.translate("column.size"), this.translate("column.url")};
        ProxyFrame.loadReplacements();
        Object[][] data = new Object[replacements.size()][3];
        for (int i = 0; i < replacements.size(); ++i) {
            Replacement r = replacements.get(i);
            data[i][0] = r.lastAccess == null ? "" : this.format.format(r.lastAccess.getTime());
            data[i][1] = new SizeItem(r.targetFile);
            data[i][2] = r.urlPattern;
        }
        this.tableModel = new DefaultTableModel(data, columnNames){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Class[] classes = new Class[]{String.class, SizeItem.class, String.class};
                return classes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.replacementsTable = new JTable(this.tableModel);
        DefaultTableCellRenderer tcr = new DefaultTableCellRenderer();
        tcr.setHorizontalAlignment(4);
        this.replacementsTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer());
        this.replacementsTable.setDefaultRenderer(SizeItem.class, tcr);
        this.replacementsTable.setAutoResizeMode(3);
        this.replacementsTable.setRowSelectionAllowed(true);
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)this.replacementsTable.getColumnModel();
        colModel.getColumn(0).setMaxWidth(100);
        colModel.getColumn(1).setMaxWidth(200);
        this.replacementsTable.setAutoCreateRowSorter(true);
        this.replacementsTable.setAutoCreateRowSorter(false);
        this.replacementsTable.addMouseListener(this);
        this.replacementsTable.setFont(new Font("Monospaced", 0, 12));
        this.switchButton.addActionListener(this::switchStateButtonActionPerformed);
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        cnt.add((Component)new FasterScrollPane(this.replacementsTable), "Center");
        this.portField.setPreferredSize(new Dimension(80, this.portField.getPreferredSize().height));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout());
        buttonsPanel.add(new JLabel(this.translate("port")));
        buttonsPanel.add(this.portField);
        buttonsPanel.add(this.switchButton);
        cnt.add((Component)buttonsPanel, "North");
        JPanel buttonsPanel23 = new JPanel();
        buttonsPanel23.setLayout(new BoxLayout(buttonsPanel23, 1));
        JPanel buttonsPanel21 = new JPanel(new FlowLayout());
        JButton openButton = new JButton(this.translate("open"));
        openButton.addActionListener(this::openButtonActionPerformed);
        buttonsPanel21.add(openButton);
        JButton clearButton = new JButton(this.translate("clear"));
        clearButton.addActionListener(this::clearButtonActionPerformed);
        buttonsPanel21.add(clearButton);
        JButton renameButton = new JButton(this.translate("rename"));
        renameButton.addActionListener(this::renameButtonActionPerformed);
        buttonsPanel21.add(renameButton);
        JButton removeButton = new JButton(this.translate("remove"));
        removeButton.addActionListener(this::removeButtonActionPerformed);
        buttonsPanel21.add(removeButton);
        JButton copyUrlButton = new JButton(this.translate("copy.url"));
        copyUrlButton.addActionListener(this::copyUrlButtonActionPerformed);
        buttonsPanel21.add(copyUrlButton);
        JButton saveAsButton = new JButton(this.translate("save.as"));
        saveAsButton.addActionListener(this::saveAsButtonActionPerformed);
        buttonsPanel21.add(saveAsButton);
        JButton replaceButton = new JButton(this.translate("replace"));
        replaceButton.addActionListener(this::replaceButtonActionPerformed);
        buttonsPanel21.add(replaceButton);
        JPanel buttonsPanel3 = new JPanel();
        buttonsPanel3.setLayout(new FlowLayout());
        buttonsPanel3.add(new JLabel(this.translate("sniff")));
        buttonsPanel3.add(this.sniffSWFCheckBox);
        buttonsPanel3.add(this.sniffOSCheckBox);
        buttonsPanel23.add(buttonsPanel21);
        buttonsPanel23.add(buttonsPanel3);
        cnt.add((Component)buttonsPanel23, "South");
        this.setSize(800, 500);
        View.centerScreen(this);
        View.setWindowIcon(this);
        this.setTitle(this.translate("dialog.title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProxyFrame.this.setVisible(false);
                Main.removeTrayIcon();
                if (mainFrame != null && mainFrame.isVisible()) {
                    return;
                }
                Main.showModeFrame();
            }

            @Override
            public void windowIconified(WindowEvent e) {
                ProxyFrame.this.setVisible(false);
            }
        });
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        images.add(View.loadImage("proxy16"));
        images.add(View.loadImage("proxy32"));
        this.setIconImages(images);
    }

    private void open() {
        View.checkAccess();
        if (this.replacementsTable.getSelectedRow() > -1) {
            Replacement r = replacements.get(this.replacementsTable.getRowSorter().convertRowIndexToModel(this.replacementsTable.getSelectedRow()));
            Main.openFile(r.targetFile, r.urlPattern);
        }
    }

    private String selectExportDir() {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File((String)Configuration.lastExportDir.get()));
        chooser.setDialogTitle(this.translate("export.select.directory"));
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            String selFile = Helper.fixDialogFile((File)chooser.getSelectedFile()).getAbsolutePath();
            Configuration.lastExportDir.set((Object)Helper.fixDialogFile((File)chooser.getSelectedFile()).getAbsolutePath());
            return selFile;
        }
        return null;
    }

    private int[] getSelectedRows() {
        int[] sel = this.replacementsTable.getSelectedRows();
        for (int i = 0; i < sel.length; ++i) {
            sel[i] = this.replacementsTable.getRowSorter().convertRowIndexToModel(sel[i]);
        }
        return sel;
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        this.open();
    }

    private void saveAsButtonActionPerformed(ActionEvent evt) {
        block12: {
            int[] sel;
            block11: {
                String ext;
                sel = this.getSelectedRows();
                if (sel.length != 1) break block11;
                Replacement r = replacements.get(sel[0]);
                JFileChooser fc = new JFileChooser();
                fc.setCurrentDirectory(new File((String)Configuration.lastSaveDir.get()));
                String n = r.urlPattern;
                if (n.contains("?")) {
                    n = n.substring(0, n.indexOf(63));
                }
                if (n.contains("/")) {
                    n = n.substring(n.lastIndexOf(47));
                }
                n = Helper.makeFileName((String)n);
                fc.setSelectedFile(new File((String)Configuration.lastSaveDir.get(), n));
                final String extension = ext = ".swf";
                FileFilter swfFilter = new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.getName().toLowerCase(Locale.ENGLISH).endsWith(extension) || f.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return AppStrings.translate("filter" + extension);
                    }
                };
                fc.setFileFilter(swfFilter);
                fc.setAcceptAllFileFilterUsed(true);
                if (fc.showSaveDialog(this) != 0) break block12;
                File file = Helper.fixDialogFile((File)fc.getSelectedFile());
                try {
                    Files.copy(new File(r.targetFile).toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException ex) {
                    ViewMessages.showMessageDialog(this, this.translate("error.save.as") + "\r\n" + ex.getLocalizedMessage(), AppStrings.translate("error"), 0);
                }
                break block12;
            }
            GuiAbortRetryIgnoreHandler handler = new GuiAbortRetryIgnoreHandler();
            File exportDir = new File(this.selectExportDir());
            for (int s : sel) {
                final Replacement r = replacements.get(s);
                String n = r.urlPattern;
                if (n.contains("?")) {
                    n = n.substring(0, n.indexOf(63));
                }
                if (n.contains("/")) {
                    n = n.substring(n.lastIndexOf(47));
                }
                n = Helper.makeFileName((String)n);
                int c = 2;
                String n2 = n;
                while (new File(exportDir, n2).exists()) {
                    if (n.contains(".")) {
                        n2 = n.substring(0, n.lastIndexOf(46)) + c + n.substring(n.lastIndexOf(46));
                        ++c;
                        continue;
                    }
                    n2 = n + c + ".swf";
                    ++c;
                }
                final File outfile = new File(exportDir, n2);
                try {
                    new RetryTask(new RunnableIOEx(){

                        public void run() throws IOException {
                            Files.copy(new File(r.targetFile).toPath(), outfile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                    }, (AbortRetryIgnoreHandler)handler).run();
                }
                catch (IOException | InterruptedException ex) {
                    break;
                }
            }
        }
    }

    private void replaceButtonActionPerformed(ActionEvent evt) {
        int[] sel = this.getSelectedRows();
        if (sel.length > 0) {
            String ext;
            Replacement r = replacements.get(sel[0]);
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File((String)Configuration.lastOpenDir.get()));
            final String extension = ext = ".swf";
            FileFilter swfFilter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().toLowerCase(Locale.ENGLISH).endsWith(extension) || f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return AppStrings.translate("filter" + extension);
                }
            };
            fc.setFileFilter(swfFilter);
            fc.setAcceptAllFileFilterUsed(true);
            if (fc.showOpenDialog(this) == 0) {
                File file = Helper.fixDialogFile((File)fc.getSelectedFile());
                try {
                    Files.copy(file.toPath(), new File(r.targetFile).toPath(), StandardCopyOption.REPLACE_EXISTING);
                    this.tableModel.fireTableCellUpdated(sel[0], 1);
                }
                catch (IOException ex) {
                    ViewMessages.showMessageDialog(this, this.translate("error.replace") + "\r\n" + ex.getLocalizedMessage(), AppStrings.translate("error"), 0);
                }
            }
        }
    }

    private void copyUrlButtonActionPerformed(ActionEvent evt) {
        int[] sel = this.getSelectedRows();
        StringBuilder copyText = new StringBuilder();
        for (int sc : sel) {
            Replacement r = replacements.get(sc);
            if (copyText.length() > 0) {
                copyText.append(System.lineSeparator());
            }
            copyText.append(r.urlPattern);
        }
        if (copyText.length() > 0) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(copyText.toString());
            clipboard.setContents(stringSelection, null);
        }
    }

    private void renameButtonActionPerformed(ActionEvent evt) {
        int[] sel = this.getSelectedRows();
        if (sel.length > 0) {
            Replacement r = replacements.get(sel[0]);
            String s = ViewMessages.showInputDialog(this, "URL", r.urlPattern);
            if (s != null) {
                r.urlPattern = s;
                this.tableModel.setValueAt(s, sel[0], 2);
            }
        }
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        for (Replacement r : replacements) {
            try {
                File f = new File(Main.tempFile(r.targetFile));
                if (!f.exists()) continue;
                f.delete();
            }
            catch (IOException ex) {
                Logger.getLogger(ProxyFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tableModel.setRowCount(0);
        replacements.clear();
        ProxyFrame.saveReplacements();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int[] sel = this.getSelectedRows();
        Arrays.sort(sel);
        for (int i = sel.length - 1; i >= 0; --i) {
            this.tableModel.removeRow(sel[i]);
            Replacement r = replacements.remove(sel[i]);
            ProxyFrame.saveReplacements();
            File f = new File(r.targetFile);
            if (!f.exists()) continue;
            f.delete();
        }
    }

    private void switchStateButtonActionPerformed(ActionEvent evt) {
        Main.switchProxy();
    }

    public void switchState() {
        boolean bl = this.started = !this.started;
        if (this.started) {
            int port = 0;
            try {
                port = Integer.parseInt(this.portField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (port <= 0 || port > 65535) {
                ViewMessages.showMessageDialog(this, this.translate("error.port"), this.translate("error"), 0);
                this.started = false;
                return;
            }
            ArrayList<String> catchedContentTypes = new ArrayList<String>();
            catchedContentTypes.add("application/x-shockwave-flash");
            catchedContentTypes.add("application/x-javascript");
            catchedContentTypes.add("application/javascript");
            catchedContentTypes.add("text/javascript");
            catchedContentTypes.add("application/json");
            catchedContentTypes.add("text/xml");
            catchedContentTypes.add("application/xml");
            catchedContentTypes.add("application/octet-stream");
            if (!Server.startServer((int)port, replacements, catchedContentTypes, (CatchedListener)this, (ReplacedListener)this)) {
                JOptionPane.showMessageDialog(this, this.translate("error.start.server").replace("%port%", "" + port), AppStrings.translate("error"), 0);
                this.started = false;
                return;
            }
            this.switchButton.setText(this.translate("proxy.stop"));
            this.portField.setEditable(false);
        } else {
            Server.stopServer();
            this.switchButton.setText(this.translate("proxy.start"));
            this.portField.setEditable(true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.replacementsTable && e.getClickCount() == 2) {
            this.open();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public byte[] catched(String contentType, String url, InputStream data) {
        boolean swfOnly = false;
        if (contentType.contains(";")) {
            contentType = contentType.substring(0, contentType.indexOf(59));
        }
        if (!this.sniffSWFCheckBox.isSelected() && contentType.equals("application/x-shockwave-flash")) {
            return null;
        }
        if (!this.sniffJSCheckBox.isSelected() && (contentType.equals("application/javascript") || contentType.equals("application/x-javascript") || contentType.equals("text/javascript") || contentType.equals("application/json"))) {
            return null;
        }
        if (!this.sniffXMLCheckBox.isSelected() && (contentType.equals("application/xml") || contentType.equals("text/xml"))) {
            return null;
        }
        if (!this.sniffOSCheckBox.isSelected() && contentType.equals("application/octet-stream")) {
            return null;
        }
        byte[] result = null;
        boolean cont = false;
        for (Replacement r : replacements) {
            if (!r.matches(url)) continue;
            cont = true;
            break;
        }
        if (!cont) {
            try {
                byte[] hdr = new byte[3];
                if (data.read(hdr) != 3) {
                    throw new IOException();
                }
                String shdr = new String(hdr);
                if (swfOnly && !shdr.equals("FWS") && !shdr.equals("CWS") && !shdr.equals("ZWS")) {
                    return null;
                }
                String tempFilePath = Main.tempFile(url);
                data.reset();
                byte[] dataArray = Helper.readStream((InputStream)data);
                try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(new File(tempFilePath)));){
                    ((OutputStream)fos).write(dataArray);
                }
                result = SWFDecompilerPlugin.fireProxyFileCatched((byte[])dataArray);
                Replacement r = new Replacement(url, tempFilePath);
                r.lastAccess = Calendar.getInstance();
                replacements.add(r);
                ProxyFrame.saveReplacements();
                this.tableModel.addRow(new Object[]{r.lastAccess == null ? "" : this.format.format(r.lastAccess.getTime()), new SizeItem(r.targetFile), r.urlPattern});
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Main.addTrayIcon();
        }
        super.setVisible(b);
    }

    public void replaced(Replacement replacement, String url, String contentType) {
        int index = replacements.indexOf(replacement);
        this.tableModel.setValueAt(replacement.lastAccess == null ? "" : this.format.format(replacement.lastAccess.getTime()), index, 0);
        this.tableModel.setValueAt(new SizeItem(replacement.targetFile), index, 1);
        this.tableModel.setValueAt(replacement.urlPattern, index, 2);
    }

    private static class SizeItem
    implements Comparable<SizeItem> {
        String file;

        public SizeItem(String file) {
            this.file = file;
        }

        public String toString() {
            return Helper.byteCountStr((long)new File(this.file).length(), (boolean)false);
        }

        @Override
        public int compareTo(SizeItem o) {
            return (int)(new File(this.file).length() - new File(o.file).length());
        }
    }
}

