/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.generictageditors;

import com.jpexs.decompiler.flash.gui.generictageditors.ChangeListener;
import com.jpexs.decompiler.flash.gui.generictageditors.GenericTagEditor;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.ReflectionTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.reflect.Field;
import javax.swing.JTextArea;

public class StringEditor
extends JTextArea
implements GenericTagEditor {
    private final Object obj;
    private final Field field;
    private final int index;
    private final Class<?> type;
    private String fieldName;
    private boolean multiline;

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ret = super.getPreferredSize();
        ret.width = 300;
        return ret;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    @Override
    public int getBaseline(int width, int height) {
        return 0;
    }

    public StringEditor(String fieldName, Object obj, Field field, int index, Class<?> type, boolean multiline) {
        this.setLineWrap(true);
        this.obj = obj;
        this.field = field;
        this.index = index;
        this.type = type;
        this.fieldName = fieldName;
        this.multiline = multiline;
        if (multiline) {
            Dimension d = new Dimension(500, 200);
            this.setPreferredSize(d);
            this.setSize(d);
        }
        this.reset();
    }

    @Override
    public void reset() {
        try {
            this.setText((String)ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index));
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    @Override
    public void save() {
        try {
            ReflectionTools.setValue((Object)this.obj, (Field)this.field, (int)this.index, (Object)this.getText());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public void addChangeListener(final ChangeListener l) {
        final StringEditor t = this;
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                l.change(t);
            }
        });
    }

    @Override
    public Object getChangedValue() {
        return this.getText();
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getReadOnlyValue() {
        return Helper.escapeHTML((String)this.getChangedValue().toString());
    }

    @Override
    public void added() {
    }

    @Override
    public void validateValue() {
    }
}

