/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.generictageditors;

import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.generictageditors.ChangeListener;
import com.jpexs.decompiler.flash.gui.generictageditors.GenericTagEditor;
import com.jpexs.decompiler.flash.types.ARGB;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.helpers.ReflectionTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class ColorEditor
extends JPanel
implements GenericTagEditor,
ActionListener {
    private final Object obj;
    private final Field field;
    private final int index;
    private final Class<?> type;
    private final String fieldName;
    private Color color;
    public static final int COLOR_TYPE_RGB = 0;
    public static final int COLOR_TYPE_RGBA = 1;
    public static final int COLOR_TYPE_ARGB = 2;
    private int colorType;
    private final JButton buttonChange;

    public int getColorType() {
        return this.colorType;
    }

    @Override
    public void added() {
    }

    public ColorEditor(String fieldName, Object obj, Field field, int index, Class<?> type) {
        this.obj = obj;
        this.field = field;
        this.index = index;
        this.type = type;
        this.fieldName = fieldName;
        this.setLayout(new FlowLayout());
        this.buttonChange = new JButton(""){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintBorder(g);
            }
        };
        this.buttonChange.setToolTipText(AppStrings.translate("button.selectcolor.hint"));
        this.buttonChange.setCursor(new Cursor(12));
        this.buttonChange.addActionListener(this);
        this.buttonChange.setBorderPainted(true);
        this.buttonChange.setBorder(BorderFactory.createBevelBorder(0));
        Dimension colorDim = new Dimension(16, 16);
        this.buttonChange.setSize(colorDim);
        this.buttonChange.setPreferredSize(colorDim);
        this.add(this.buttonChange);
        this.reset();
    }

    @Override
    public void validateValue() {
    }

    @Override
    public void reset() {
        try {
            Object val = ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index);
            if (val instanceof RGBA) {
                this.colorType = 1;
            } else if (val instanceof RGB) {
                this.colorType = 0;
            } else if (val instanceof ARGB) {
                this.colorType = 2;
            } else {
                throw new IllegalArgumentException("Invalid value type");
            }
            if (val instanceof RGB) {
                this.color = ((RGB)val).toColor();
            }
            if (val instanceof ARGB) {
                this.color = ((ARGB)val).toColor();
            }
            this.buttonChange.setBackground(this.color);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    @Override
    public void save() {
        Object val = this.getChangedValue();
        try {
            ReflectionTools.setValue((Object)this.obj, (Field)this.field, (int)this.index, (Object)val);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public void addChangeListener(final ChangeListener l) {
        final ColorEditor t = this;
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                l.change(t);
            }
        });
    }

    @Override
    public Object getChangedValue() {
        ARGB val = null;
        switch (this.colorType) {
            case 0: {
                val = new RGB(this.color);
                break;
            }
            case 1: {
                val = new RGBA(this.color);
                break;
            }
            case 2: {
                val = new ARGB();
            }
        }
        return val;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    private static Color noTransparencyColorChooser(Component component, String title, Color initialColor) throws Exception {
        final JColorChooser pane = new JColorChooser(initialColor != null ? initialColor : Color.white);
        AbstractColorChooserPanel[] colorPanels = pane.getChooserPanels();
        for (int i = 1; i < colorPanels.length; ++i) {
            AbstractColorChooserPanel cp = colorPanels[i];
            Field f = cp.getClass().getDeclaredField("panel");
            f.setAccessible(true);
            Object colorPanel = f.get(cp);
            Field f2 = colorPanel.getClass().getDeclaredField("spinners");
            f2.setAccessible(true);
            Object spinners = f2.get(colorPanel);
            Object transpSlispinner = Array.get(spinners, 3);
            if (i == colorPanels.length - 1) {
                transpSlispinner = Array.get(spinners, 4);
            }
            Field f3 = transpSlispinner.getClass().getDeclaredField("slider");
            f3.setAccessible(true);
            JSlider slider = (JSlider)f3.get(transpSlispinner);
            slider.setEnabled(false);
            Field f4 = transpSlispinner.getClass().getDeclaredField("spinner");
            f4.setAccessible(true);
            JSpinner spinner = (JSpinner)f4.get(transpSlispinner);
            spinner.setEnabled(false);
        }
        final Color[] col = new Color[]{initialColor};
        JDialog dialog = JColorChooser.createDialog(component, title, true, pane, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                col[0] = pane.getColor();
            }
        }, null);
        dialog.setVisible(true);
        return col[0];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color newColor;
        if (this.colorType == 0) {
            try {
                newColor = ColorEditor.noTransparencyColorChooser(null, AppStrings.translate("dialog.selectcolor.title"), this.color);
            }
            catch (Exception ex) {
                newColor = JColorChooser.showDialog(null, AppStrings.translate("dialog.selectcolor.title"), this.color);
            }
        } else {
            newColor = JColorChooser.showDialog(null, AppStrings.translate("dialog.selectcolor.title"), this.color);
        }
        if (newColor != null) {
            this.color = newColor;
            this.buttonChange.setBackground(this.color);
            this.repaint();
        }
    }

    @Override
    public String getReadOnlyValue() {
        int h = System.identityHashCode(this);
        return "<cite style=\"background-color:rgb(" + this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue() + ");\">&nbsp;&nbsp;&nbsp;&nbsp;</cite> " + this.getChangedValue().toString();
    }
}

