/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.generictageditors;

import com.jpexs.decompiler.flash.amf.amf3.Amf3Value;
import com.jpexs.decompiler.flash.exporters.amf.amf3.Amf3Exporter;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.editor.LineMarkedEditorPane;
import com.jpexs.decompiler.flash.gui.generictageditors.ChangeListener;
import com.jpexs.decompiler.flash.gui.generictageditors.FullSized;
import com.jpexs.decompiler.flash.gui.generictageditors.GenericTagEditor;
import com.jpexs.decompiler.flash.importers.amf.amf3.Amf3Importer;
import com.jpexs.decompiler.flash.importers.amf.amf3.Amf3ParseException;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.ReflectionTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Timer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class Amf3ValueEditor
extends JPanel
implements GenericTagEditor,
FullSized {
    private LineMarkedEditorPane editor = new LineMarkedEditorPane();
    private final Object obj;
    private final Field field;
    private final int index;
    private final Class<?> type;
    private String fieldName;
    private Amf3Value value;
    private final JLabel errorLabel = new JLabel();
    private Timer hideErrorTimer;
    private final int TIMEOUT = 5000;

    @Override
    public void added() {
        String s = this.editor.getText();
        this.editor.setContentType("text/javascript");
        this.editor.setText(s);
        this.editor.setCaretPosition(0);
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    @Override
    public int getBaseline(int width, int height) {
        return 0;
    }

    public Amf3ValueEditor(String fieldName, Object obj, Field field, int index, Class<?> type) {
        this.obj = obj;
        this.field = field;
        this.index = index;
        this.type = type;
        this.fieldName = fieldName;
        this.setPreferredSize(new Dimension(800, 200));
        this.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel(new BorderLayout()){

            @Override
            public Insets getInsets() {
                Insets is = super.getInsets();
                is.left = 5;
                return is;
            }
        };
        JLabel titleLabel = new JLabel(AppStrings.translate("generic.editor.amf3.title"));
        titleLabel.setFont(titleLabel.getFont().deriveFont(1));
        titlePanel.add((Component)titleLabel, "Center");
        JButton helpButton = new JButton(View.getIcon("about16"));
        helpButton.setFocusable(false);
        JTextArea txthelp = new JTextArea();
        txthelp.setFont(new Font("monospaced", 0, 12));
        String SCALAR_SAMPLES = " * undefined, null, false, true\n * integer : -5, 5, 29\n * double: 5.5, 1.27, -187.568\n * String: \"hello\", \"escape new\\nline\"\n";
        String NONSCALAR_SAMPLES = " * XMLDocument: {\"type\":\"XMLDocument\", value: \"<foo></foo>\"}\n * Date: {\"type\":\"Date\", \"value\": \"2016-07-17 14:51:42.584\"}\n * Array: {\"type\":\"Array\", \"denseValues\": [27,58,99], \"associativeValues\": {\"key1\":5, \"key2\": -4.6 }}\n * Object: {\"type\":\"Object\",\"className\":\"\",\"dynamic\":true,\n            \"sealedMembers\": {\"smemberA\": \"abc\", \"smemberB\":987.5},\n            \"dynamicMembers\": {\"member1\": 5, \"member2\": \"aaa\"}\n            }\n * XML: {\"type\":\"XML\", value: \"<foo></foo>\"}\n * ByteArray: {\"type\":\"ByteArray\", \"value\":\"B0312F\"}\n * Vector: {\"type\": \"Vector\", \"fixed\":false, \"subtype\":\"int\", \"values\": [8, 4, 6]}\n * Dictionary: {\"type\": \"Dictionary\", \"weakKeys\":false, \"entries\": { \"dkey1\" : \"val1\", \"dkey2\": 56 }}\n";
        String REFERENCE_SAMPLE = "  {\"type\": \"Vector\", \"fixed\":false, \"subtype\":\"\",\n   \"values\": [\n       {\"type\":\"Date\", id=\"mydate\",\"value\": \"2016-07-17 14:51:42.584\"}\n       #mydate,\n       #mydate,\n       {\"type\":\"Date\", \"value\": \"2016-07-26 18:12:22.188\"}\n    ]}";
        txthelp.setText(AppStrings.translate("generic.editor.amf3.help").replace("%scalar_samples%", " * undefined, null, false, true\n * integer : -5, 5, 29\n * double: 5.5, 1.27, -187.568\n * String: \"hello\", \"escape new\\nline\"\n").replace("%nonscalar_samples%", " * XMLDocument: {\"type\":\"XMLDocument\", value: \"<foo></foo>\"}\n * Date: {\"type\":\"Date\", \"value\": \"2016-07-17 14:51:42.584\"}\n * Array: {\"type\":\"Array\", \"denseValues\": [27,58,99], \"associativeValues\": {\"key1\":5, \"key2\": -4.6 }}\n * Object: {\"type\":\"Object\",\"className\":\"\",\"dynamic\":true,\n            \"sealedMembers\": {\"smemberA\": \"abc\", \"smemberB\":987.5},\n            \"dynamicMembers\": {\"member1\": 5, \"member2\": \"aaa\"}\n            }\n * XML: {\"type\":\"XML\", value: \"<foo></foo>\"}\n * ByteArray: {\"type\":\"ByteArray\", \"value\":\"B0312F\"}\n * Vector: {\"type\": \"Vector\", \"fixed\":false, \"subtype\":\"int\", \"values\": [8, 4, 6]}\n * Dictionary: {\"type\": \"Dictionary\", \"weakKeys\":false, \"entries\": { \"dkey1\" : \"val1\", \"dkey2\": 56 }}\n").replace("%reference_sample%", "  {\"type\": \"Vector\", \"fixed\":false, \"subtype\":\"\",\n   \"values\": [\n       {\"type\":\"Date\", id=\"mydate\",\"value\": \"2016-07-17 14:51:42.584\"}\n       #mydate,\n       #mydate,\n       {\"type\":\"Date\", \"value\": \"2016-07-26 18:12:22.188\"}\n    ]}"));
        txthelp.setEditable(false);
        helpButton.addActionListener(e -> ViewMessages.showMessageDialog(this, txthelp));
        titlePanel.add((Component)helpButton, "East");
        this.add((Component)titlePanel, "North");
        this.add((Component)new FasterScrollPane(this.editor), "Center");
        this.add((Component)this.errorLabel, "South");
        this.errorLabel.setBackground(Color.red);
        this.errorLabel.setForeground(Color.white);
        this.errorLabel.setOpaque(true);
        this.reset();
    }

    @Override
    public void reset() {
        try {
            this.value = (Amf3Value)ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index);
            if (this.value == null || this.value.getValue() == null) {
                this.editor.setText("");
            } else {
                String stringVal = Amf3Exporter.amfToString((Object)this.value.getValue());
                this.editor.setText(stringVal);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    @Override
    public void save() {
        try {
            Object val = this.getChangedValue();
            ReflectionTools.setValue((Object)this.obj, (Field)this.field, (int)this.index, (Object)val);
            this.value = (Amf3Value)val;
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public void addChangeListener(final ChangeListener l) {
        final Amf3ValueEditor t = this;
        this.editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                l.change(t);
            }
        });
    }

    @Override
    public void validateValue() {
        Amf3Importer importer = new Amf3Importer();
        String textVal = this.editor.getText();
        try {
            if (!textVal.trim().isEmpty()) {
                importer.stringToAmf(textVal);
            }
        }
        catch (Amf3ParseException | IOException ex) {
            if (ex instanceof Amf3ParseException) {
                Amf3ParseException ape = (Amf3ParseException)ex;
                if (ape.line > 0L) {
                    this.editor.gotoLine((int)ape.line);
                }
            }
            CaretListener cl = new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    Amf3ValueEditor.this.errorLabel.setVisible(false);
                    Amf3ValueEditor.this.editor.removeCaretListener(this);
                }
            };
            this.editor.addCaretListener(cl);
            this.errorLabel.setText("<html>" + AppStrings.translate("error") + ":" + ex.getMessage() + "</html>");
            this.errorLabel.setVisible(true);
            throw new IllegalArgumentException("Invalid AMF value", ex);
        }
    }

    @Override
    public Object getChangedValue() {
        Amf3Importer importer = new Amf3Importer();
        String textVal = this.editor.getText();
        try {
            return textVal.trim().isEmpty() ? null : new Amf3Value(importer.stringToAmf(textVal));
        }
        catch (Amf3ParseException | IOException ex) {
            return this.value;
        }
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getReadOnlyValue() {
        return Helper.escapeHTML((String)this.getChangedValue().toString());
    }
}

