/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.debugger;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.DebugLogDialog;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.debugger.Debugger;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.FileAttributesTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.helpers.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DebuggerTools {
    private static final Logger logger = Logger.getLogger(DebuggerTools.class.getName());
    public static final String DEBUGGER_PACKAGE = "com.jpexs.decompiler.flash.debugger";
    private static volatile Debugger debugger;

    private static ScriptPack getDebuggerScriptPack(SWF swf) {
        ArrayList<ABC> allAbcList = new ArrayList<ABC>();
        for (ABCContainerTag ac : swf.getAbcList()) {
            allAbcList.add(ac.getABC());
        }
        for (ABCContainerTag ac : swf.getAbcList()) {
            ABC a = ac.getABC();
            for (ScriptPack m : a.getScriptPacks(DEBUGGER_PACKAGE, allAbcList)) {
                if (!DebuggerTools.isDebuggerClass(m.getClassPath().packageStr.toRawString(), null)) continue;
                return m;
            }
        }
        return null;
    }

    public static boolean hasDebugger(SWF swf) {
        return DebuggerTools.getDebuggerScriptPack(swf) != null;
    }

    private static boolean isDebuggerClass(String tested, String cls) {
        if (tested == null) {
            return false;
        }
        if (!tested.startsWith(DEBUGGER_PACKAGE)) {
            return false;
        }
        cls = cls == null ? "" : "\\." + Pattern.quote(cls);
        return tested.matches(Pattern.quote(DEBUGGER_PACKAGE) + "(\\.pkg[a-f0-9]+)?" + cls);
    }

    public static void injectDebugLoader(SWF swf) {
        if (DebuggerTools.hasDebugger(swf)) {
            ScriptPack dsp = DebuggerTools.getDebuggerScriptPack(swf);
            String debuggerPkg = dsp.getClassPath().packageStr.toRawString();
            for (ABCContainerTag ct : swf.getAbcList()) {
                ABC a = ct.getABC();
                if (dsp.abc == a) continue;
                for (int i = 1; i < a.constants.getMultinameCount(); ++i) {
                    Multiname m = a.constants.getMultiname(i);
                    if ("flash.display.Loader".equals(m.getNameWithNamespace(a.constants, true).toRawString())) {
                        m.namespace_index = a.constants.getNamespaceId(22, debuggerPkg, 0, true);
                        m.name_index = a.constants.getStringId("DebugLoader", true);
                        ((Tag)ct).setModified(true);
                        continue;
                    }
                    if ("flash.utils.getDefinitionByName".equals(m.getNameWithNamespace(a.constants, true).toRawString())) {
                        m.namespace_index = a.constants.getNamespaceId(22, debuggerPkg, 0, true);
                        m.name_index = a.constants.getStringId("debugGetDefinitionByName", true);
                        ((Tag)ct).setModified(true);
                        continue;
                    }
                    if ("flash.utils.getQualifiedClassName".equals(m.getNameWithNamespace(a.constants, true).toRawString())) {
                        m.namespace_index = a.constants.getNamespaceId(22, debuggerPkg, 0, true);
                        m.name_index = a.constants.getStringId("debugGetQualifiedClassName", true);
                        ((Tag)ct).setModified(true);
                        continue;
                    }
                    if ("flash.utils.getQualifiedSuperclassName".equals(m.getNameWithNamespace(a.constants, true).toRawString())) {
                        m.namespace_index = a.constants.getNamespaceId(22, debuggerPkg, 0, true);
                        m.name_index = a.constants.getStringId("debugGetQualifiedSuperclassName", true);
                        ((Tag)ct).setModified(true);
                        continue;
                    }
                    if (!"flash.utils.describeType".equals(m.getNameWithNamespace(a.constants, true).toRawString())) continue;
                    m.namespace_index = a.constants.getNamespaceId(22, debuggerPkg, 0, true);
                    m.name_index = a.constants.getStringId("debugDescribeType", true);
                    ((Tag)ct).setModified(true);
                }
            }
        }
    }

    public static void replaceTraceCalls(SWF swf, String fname) {
        if (DebuggerTools.hasDebugger(swf)) {
            String debuggerPkg = DebuggerTools.getDebuggerScriptPack((SWF)swf).getClassPath().packageStr.toRawString();
            for (ABCContainerTag ct : swf.getAbcList()) {
                ABC a = ct.getABC();
                for (int i = 1; i < a.constants.getMultinameCount(); ++i) {
                    Multiname m = a.constants.getMultiname(i);
                    if (!"trace".equals(m.getNameWithNamespace(a.constants, true).toRawString())) continue;
                    m.namespace_index = a.constants.getNamespaceId(22, debuggerPkg, 0, true);
                    m.name_index = a.constants.getStringId(fname, true);
                    ((Tag)ct).setModified(true);
                }
            }
        }
    }

    public static void switchDebugger(SWF swf) {
        int port = (Integer)Configuration.debuggerPort.get();
        ScriptPack found = DebuggerTools.getDebuggerScriptPack(swf);
        if (found != null) {
            ABCContainerTag tag = found.abc.parentTag;
            swf.removeTag((Tag)tag);
            swf.getAbcList().remove(tag);
            for (ABCContainerTag ct : swf.getAbcList()) {
                ABC a = ct.getABC();
                for (int i = 1; i < a.constants.getMultinameCount(); ++i) {
                    Multiname m = a.constants.getMultiname(i);
                    String packageStr = m.getNameWithNamespace(a.constants, true).toString();
                    if (DebuggerTools.isDebuggerClass(packageStr, "debugTrace") || DebuggerTools.isDebuggerClass(packageStr, "debugAlert") || DebuggerTools.isDebuggerClass(packageStr, "debugSocket") || DebuggerTools.isDebuggerClass(packageStr, "debugConsole")) {
                        m.name_index = a.constants.getStringId("trace", true);
                        m.namespace_index = a.constants.getNamespaceId(22, "", 0, true);
                        ((Tag)ct).setModified(true);
                        continue;
                    }
                    if (!DebuggerTools.isDebuggerClass(packageStr, "DebugLoader")) continue;
                    m.name_index = a.constants.getStringId("Loader", true);
                    m.namespace_index = a.constants.getNamespaceId(22, "flash.display", 0, true);
                }
            }
        } else {
            Random rnd = new Random();
            byte[] rb = new byte[16];
            rnd.nextBytes(rb);
            String rhex = Helper.byteArrayToHex((byte[])rb);
            try {
                ABCContainerTag firstAbc;
                SWF debugSWF = new SWF(Main.class.getClassLoader().getResourceAsStream("com/jpexs/decompiler/flash/gui/debugger/debug.swf"), false);
                List al = swf.getAbcList();
                ABCContainerTag aBCContainerTag = firstAbc = al.isEmpty() ? null : (ABCContainerTag)al.get(0);
                if (firstAbc == null) {
                    return;
                }
                String newdebuggerpkg = DEBUGGER_PACKAGE;
                if (((Boolean)Configuration.randomDebuggerPackage.get()).booleanValue()) {
                    newdebuggerpkg = newdebuggerpkg + ".pkg" + rhex;
                }
                for (ABCContainerTag ds : debugSWF.getAbcList()) {
                    int i;
                    ABC a = ds.getABC();
                    for (i = 1; i < a.constants.getNamespaceCount(); ++i) {
                        if (!a.constants.getNamespace(i).hasName(DEBUGGER_PACKAGE, a.constants)) continue;
                        a.constants.getNamespace((int)i).name_index = a.constants.getStringId(newdebuggerpkg, true);
                    }
                    for (i = 0; i < a.constants.getIntCount(); ++i) {
                        if (a.constants.getInt(i) != 123456L) continue;
                        a.constants.setInt(i, (long)port);
                    }
                    ((Tag)ds).setSwf(swf);
                    swf.addTag((Tag)ds, (TreeItem)((Tag)firstAbc));
                    swf.getAbcList().add(swf.getAbcList().indexOf(firstAbc), ds);
                    ((Tag)ds).setModified(true);
                    FileAttributesTag ft = swf.getFileAttributes();
                    ft.useNetwork = true;
                    ft.setModified(true);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Error while attaching debugger", ex);
            }
        }
        DebuggerTools.initDebugger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Debugger initDebugger() {
        if (debugger != null) return debugger;
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            if (debugger != null) return debugger;
            Debugger dbg = new Debugger((Integer)Configuration.debuggerPort.get());
            dbg.start();
            debugger = dbg;
            // ** MonitorExit[var0] (shouldn't be in output)
            return debugger;
        }
    }

    public static void debuggerShowLog() {
        DebuggerTools.initDebugger();
        if (Main.debugDialog == null) {
            Main.debugDialog = new DebugLogDialog(Main.getDefaultDialogsOwner(), debugger);
        }
        Main.debugDialog.setVisible(true);
    }
}

