/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.abc.ABCPanel;
import com.jpexs.decompiler.flash.gui.abc.IconListRenderer;
import com.jpexs.decompiler.flash.gui.abc.TraitsListItem;
import com.jpexs.decompiler.flash.gui.abc.TraitsListModel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TraitsList
extends JList<Object>
implements ListSelectionListener {
    private ABC abc;
    private int classIndex = -1;
    private final ABCPanel abcPanel;
    private boolean sorted = false;
    private int lastSelected = -1;

    public void setSorted(boolean sorted) {
        if (this.getModel() instanceof TraitsListModel) {
            ((TraitsListModel)this.getModel()).setSorted(sorted);
        }
        this.sorted = sorted;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public TraitsList(ABCPanel abcPanel) {
        this.addListSelectionListener(this);
        this.abcPanel = abcPanel;
        this.setCellRenderer(new IconListRenderer());
        if (View.isOceanic()) {
            this.setBackground(Color.white);
        }
    }

    public void clearAbc() {
        this.abc = null;
        this.setModel(new DefaultListModel());
    }

    public void setAbc(ABC abc) {
        this.abc = abc;
        this.setModel(new DefaultListModel());
        this.setClassIndex(-1, -1);
    }

    public void setClassIndex(int classIndex, int scriptIndex) {
        if (classIndex >= this.abc.instance_info.size()) {
            return;
        }
        this.classIndex = classIndex;
        this.setModel(new TraitsListModel(this.abc, classIndex, scriptIndex, this.sorted));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.getSelectedIndex() == this.lastSelected) {
            return;
        }
        this.lastSelected = this.getSelectedIndex();
        TraitsListItem sel = (TraitsListItem)this.getSelectedValue();
        this.abcPanel.decompiledTextArea.gotoTrait(sel == null ? -4 : sel.getGlobalTraitId());
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setComposite(AlphaComposite.SrcOver);
        super.paint(g);
    }
}

