/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.tags.TagInfo;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class TagInfoPanel
extends JPanel {
    private final MainPanel mainPanel;
    private final JEditorPane editorPane = new JEditorPane();
    private TagInfo tagInfo = new TagInfo();

    public TagInfoPanel(final MainPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.setLayout(new BorderLayout());
        JLabel topLabel = new JLabel(AppStrings.translate("taginfo.header"), 0);
        this.add((Component)topLabel, "North");
        this.add((Component)new FasterScrollPane(this.editorPane), "Center");
        this.editorPane.setContentType("text/html");
        this.editorPane.setEditable(false);
        HyperlinkListener listener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperLink) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperLink.getEventType())) {
                    URI url;
                    try {
                        url = new URI(hyperLink.getDescription());
                    }
                    catch (Exception ex) {
                        return;
                    }
                    String scheme = url.getScheme();
                    String strId = url.getHost();
                    Integer id = Integer.parseInt(strId);
                    SWF swf = mainPanel.getCurrentSwf();
                    CharacterTag item = null;
                    if ("char".equals(scheme)) {
                        item = swf.getCharacter(id.intValue());
                    } else if ("frame".equals(scheme)) {
                        item = swf.getTimeline().getFrame(id.intValue());
                    }
                    mainPanel.setTagTreeSelectedNode((TreeItem)item);
                }
            }
        };
        this.editorPane.addHyperlinkListener(listener);
    }

    public void setTagInfos(TagInfo tagInfo) {
        this.tagInfo = tagInfo;
        this.buildHtmlContent();
    }

    private void buildHtmlContent() {
        String categoryName = "general";
        String result = "<html><body><table cellspacing='0' cellpadding='0'>";
        Boolean flipFlop = false;
        List items = (List)this.tagInfo.getInfos().get(categoryName);
        result = View.isOceanic() ? result + "<tr bgcolor='#FDFDFD'>" : result + "</tr>";
        result = result + String.format("<td width='50%%' style='text-align:center;'>%s</td>", this.mainPanel.translate("tagInfo.header.name"));
        result = result + String.format("<td width='50%%' style='text-align:center;'>%s</td>", this.mainPanel.translate("tagInfo.header.value"));
        result = result + "</tr>";
        for (TagInfo.TagInfoItem item : items) {
            boolean convertToLinkList;
            boolean frameList;
            String name;
            block8: {
                flipFlop = flipFlop == false;
                result = View.isOceanic() ? result + "<tr bgcolor='" + (flipFlop != false ? "#FDFDFD" : "#F4F4F4") + "'>" : result + "<tr>";
                name = item.getName();
                String key = "tagInfo." + name;
                frameList = name.equals("dependentFrames");
                convertToLinkList = name.equals("dependentCharacters") || name.equals("neededCharacters") || frameList;
                try {
                    name = this.mainPanel.translate(key);
                }
                catch (MissingResourceException mes) {
                    if (!((Boolean)Configuration._debugMode.get()).booleanValue()) break block8;
                    Logger.getLogger(TagInfoPanel.class.getName()).log(Level.WARNING, "Resource not found: {0}", key);
                }
            }
            result = result + "<td>" + name + "</td>";
            Object value = item.getValue();
            if (value instanceof Boolean) {
                boolean boolValue = (Boolean)value;
                value = boolValue ? AppStrings.translate("yes") : AppStrings.translate("no");
            } else if (convertToLinkList) {
                String[] strIds = ((String)value).split(", ");
                ArrayList<Integer> sortedIds = new ArrayList<Integer>();
                String strValue = "";
                for (String strId : strIds) {
                    sortedIds.add(Integer.parseInt(strId));
                }
                Collections.sort(sortedIds);
                String scheme = frameList ? "frame" : "char";
                Iterator iterator = sortedIds.iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    int displayId = frameList ? id + 1 : id;
                    strValue = strValue + String.format("<a href='%s://%d'>%d</a>, ", scheme, id, displayId);
                }
                value = strValue.substring(0, strValue.length() - 2);
            }
            result = result + "<td>" + value + "</td>";
            result = result + "</tr>";
        }
        result = result + "</table></body></html>";
        this.editorPane.setText(result);
        Font font = UIManager.getFont("Table.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt;} table { width:100%;";
        bodyRule = View.isOceanic() ? bodyRule + "color:#053E6A;padding:1px;}td { border: 1px solid #e4e4e4; }html { border: 1px solid #789AC4; }" : bodyRule + "background-color: " + TagInfoPanel.getUIColorToHex("Table.background") + ";color:" + TagInfoPanel.getUIColorToHex("Table.foreground") + ";padding:1px;}td { border: 1px solid " + TagInfoPanel.getUIColorToHex("Table.gridColor") + "; }html { border: 1px solid " + TagInfoPanel.getUIColorToHex("Table.gridColor") + "; }a {color: " + TagInfoPanel.getUIColorToHex("List.selectionBackground") + "}";
        ((HTMLDocument)this.editorPane.getDocument()).getStyleSheet().addRule(bodyRule);
        this.editorPane.setOpaque(false);
        this.editorPane.setBorder(null);
        this.editorPane.setEditable(false);
    }

    private static String getUIColorToHex(String name) {
        Color c = UIManager.getColor(name);
        return String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }
}

