/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFHeader;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.exporters.PreviewExporter;
import com.jpexs.decompiler.flash.gui.BinaryPanel;
import com.jpexs.decompiler.flash.gui.ButtonsPanel;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.FontPanel;
import com.jpexs.decompiler.flash.gui.GenericTagPanel;
import com.jpexs.decompiler.flash.gui.GenericTagTreePanel;
import com.jpexs.decompiler.flash.gui.HeaderLabel;
import com.jpexs.decompiler.flash.gui.ImagePanel;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.TagEditorPanel;
import com.jpexs.decompiler.flash.gui.TextPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.controls.JPersistentSplitPane;
import com.jpexs.decompiler.flash.gui.debugger.DebuggerTools;
import com.jpexs.decompiler.flash.gui.editor.LineMarkedEditorPane;
import com.jpexs.decompiler.flash.gui.hexview.HexView;
import com.jpexs.decompiler.flash.gui.player.FlashPlayerPanel;
import com.jpexs.decompiler.flash.gui.player.MediaDisplay;
import com.jpexs.decompiler.flash.gui.player.PlayerControls;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.MetadataTag;
import com.jpexs.decompiler.flash.tags.SetBackgroundColorTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.UnknownTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.TagScript;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.helpers.SerializableImage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class PreviewPanel
extends JPersistentSplitPane
implements TagEditorPanel {
    private static final String FLASH_VIEWER_CARD = "FLASHVIEWER";
    private static final String DRAW_PREVIEW_CARD = "DRAWPREVIEW";
    private static final String GENERIC_TAG_CARD = "GENERICTAG";
    private static final String BINARY_TAG_CARD = "BINARYTAG";
    private static final String UNKNOWN_TAG_CARD = "UNKNOWNTAG";
    private static final String METADATA_TAG_CARD = "METADATATAG";
    private static final String EMPTY_CARD = "EMPTY";
    private static final String CARDTEXTPANEL = "Text card";
    private static final String CARDFONTPANEL = "Font card";
    private static final String PLACE_TAG_CARD = "PLACETAG";
    private final MainPanel mainPanel;
    private final JPanel viewerCards;
    private final FlashPlayerPanel flashPanel;
    private File tempFile;
    private ImagePanel imagePanel;
    private PlayerControls imagePlayControls;
    private MediaDisplay media;
    private BinaryPanel binaryPanel;
    private LineMarkedEditorPane metadataEditor;
    private GenericTagPanel genericTagPanel;
    private GenericTagPanel placeGenericPanel;
    private JSplitPane placeSplitPane;
    private JPanel displayWithPreview;
    private JButton replaceImageButton;
    private JButton replaceImageAlphaButton;
    private JButton prevFontsButton;
    private JButton nextFontsButton;
    private JButton replaceBinaryButton;
    private JButton replaceUnknownButton;
    private JButton metadataEditButton;
    private JButton metadataSaveButton;
    private JButton metadataCancelButton;
    private JButton genericEditButton;
    private JButton genericSaveButton;
    private JButton genericCancelButton;
    private JButton placeFreeTransformButton;
    private JButton placeEditButton;
    private JButton placeSaveButton;
    private JButton placeCancelButton;
    private JPanel parametersPanel;
    private FontPanel fontPanel;
    private int fontPageNum;
    private TextPanel textPanel;
    private MetadataTag metadataTag;
    private boolean readOnly = false;
    private ImagePanel placeImagePanel;
    private final int dividerSize;
    private PlaceObjectTypeTag placeTag;
    private MATRIX oldMatrix;
    private HexView unknownHexView;
    private final int PLACE_EDIT_FREETRANSFORM = 1;
    private final int PLACE_EDIT_RAW = 2;
    private int placeEditMode = 0;
    private TreeItem currentItem;

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.setDividerSize(this.readOnly ? 0 : this.dividerSize);
        if (readOnly) {
            this.parametersPanel.setVisible(false);
        }
    }

    public PreviewPanel(MainPanel mainPanel, FlashPlayerPanel flashPanel) {
        super(1, (ConfigurationItem<Double>)Configuration.guiPreviewSplitPaneDividerLocationPercent);
        this.mainPanel = mainPanel;
        this.flashPanel = flashPanel;
        this.viewerCards = new JPanel();
        this.viewerCards.setLayout(new CardLayout());
        this.viewerCards.add((Component)this.createFlashPlayerPanel(flashPanel), FLASH_VIEWER_CARD);
        this.viewerCards.add((Component)this.createImagesCard(), DRAW_PREVIEW_CARD);
        this.viewerCards.add((Component)this.createBinaryCard(), BINARY_TAG_CARD);
        this.viewerCards.add((Component)this.createUnknownCard(), UNKNOWN_TAG_CARD);
        this.viewerCards.add((Component)this.createMetadataCard(), METADATA_TAG_CARD);
        this.viewerCards.add((Component)this.createGenericTagCard(), GENERIC_TAG_CARD);
        this.viewerCards.add((Component)this.createPlaceTagCard(), PLACE_TAG_CARD);
        this.viewerCards.add((Component)this.createEmptyCard(), EMPTY_CARD);
        this.setLeftComponent(this.viewerCards);
        this.createParametersPanel();
        this.showCardLeft(FLASH_VIEWER_CARD);
        this.dividerSize = this.getDividerSize();
    }

    private JPanel createEmptyCard() {
        JPanel ret = new JPanel();
        ret.add(new JLabel("-"));
        return ret;
    }

    private void createParametersPanel() {
        this.displayWithPreview = new JPanel(new CardLayout());
        this.textPanel = new TextPanel(this.mainPanel);
        this.displayWithPreview.add((Component)this.textPanel, CARDTEXTPANEL);
        this.fontPanel = new FontPanel(this.mainPanel);
        this.displayWithPreview.add((Component)this.fontPanel, CARDFONTPANEL);
        HeaderLabel paramsLabel = new HeaderLabel(this.mainPanel.translate("parameters"));
        paramsLabel.setHorizontalAlignment(0);
        this.parametersPanel = new JPanel(new BorderLayout());
        this.parametersPanel.add((Component)paramsLabel, "North");
        this.parametersPanel.add((Component)this.displayWithPreview, "Center");
        this.setRightComponent(this.parametersPanel);
    }

    private JPanel createImageButtonsPanel() {
        this.replaceImageButton = new JButton(this.mainPanel.translate("button.replace"), View.getIcon("replaceimage16"));
        this.replaceImageButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceImageButton.addActionListener(this.mainPanel::replaceButtonActionPerformed);
        this.replaceImageButton.setVisible(false);
        this.replaceImageAlphaButton = new JButton(this.mainPanel.translate("button.replaceAlphaChannel"), View.getIcon("replacealpha16"));
        this.replaceImageAlphaButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceImageAlphaButton.addActionListener(this.mainPanel::replaceAlphaButtonActionPerformed);
        this.replaceImageAlphaButton.setVisible(false);
        this.prevFontsButton = new JButton(this.mainPanel.translate("button.prev"), View.getIcon("prev16"));
        this.prevFontsButton.setMargin(new Insets(3, 3, 3, 10));
        this.prevFontsButton.addActionListener(this::prevFontsButtonActionPerformed);
        this.prevFontsButton.setVisible(false);
        this.nextFontsButton = new JButton(this.mainPanel.translate("button.next"), View.getIcon("next16"));
        this.nextFontsButton.setMargin(new Insets(3, 3, 3, 10));
        this.nextFontsButton.addActionListener(this::nextFontsButtonActionPerformed);
        this.nextFontsButton.setVisible(false);
        ButtonsPanel imageButtonsPanel = new ButtonsPanel();
        imageButtonsPanel.add(this.replaceImageButton);
        imageButtonsPanel.add(this.replaceImageAlphaButton);
        imageButtonsPanel.add(this.prevFontsButton);
        imageButtonsPanel.add(this.nextFontsButton);
        return imageButtonsPanel;
    }

    private JPanel createBinaryButtonsPanel() {
        this.replaceBinaryButton = new JButton(this.mainPanel.translate("button.replace"), View.getIcon("edit16"));
        this.replaceBinaryButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceBinaryButton.addActionListener(this.mainPanel::replaceButtonActionPerformed);
        ButtonsPanel binaryButtonsPanel = new ButtonsPanel();
        binaryButtonsPanel.add(this.replaceBinaryButton);
        return binaryButtonsPanel;
    }

    private JPanel createUnknownButtonsPanel() {
        this.replaceUnknownButton = new JButton(this.mainPanel.translate("button.replace"), View.getIcon("edit16"));
        this.replaceUnknownButton.setMargin(new Insets(3, 3, 3, 10));
        this.replaceUnknownButton.addActionListener(this.mainPanel::replaceButtonActionPerformed);
        ButtonsPanel unknownButtonsPanel = new ButtonsPanel();
        unknownButtonsPanel.add(this.replaceBinaryButton);
        return unknownButtonsPanel;
    }

    private JPanel createGenericTagButtonsPanel() {
        this.genericEditButton = new JButton(this.mainPanel.translate("button.edit"), View.getIcon("edit16"));
        this.genericEditButton.setMargin(new Insets(3, 3, 3, 10));
        this.genericEditButton.addActionListener(this::editGenericTagButtonActionPerformed);
        this.genericSaveButton = new JButton(this.mainPanel.translate("button.save"), View.getIcon("save16"));
        this.genericSaveButton.setMargin(new Insets(3, 3, 3, 10));
        this.genericSaveButton.addActionListener(this::saveGenericTagButtonActionPerformed);
        this.genericSaveButton.setVisible(false);
        this.genericCancelButton = new JButton(this.mainPanel.translate("button.cancel"), View.getIcon("cancel16"));
        this.genericCancelButton.setMargin(new Insets(3, 3, 3, 10));
        this.genericCancelButton.addActionListener(this::cancelGenericTagButtonActionPerformed);
        this.genericCancelButton.setVisible(false);
        ButtonsPanel genericTagButtonsPanel = new ButtonsPanel();
        genericTagButtonsPanel.add(this.genericEditButton);
        genericTagButtonsPanel.add(this.genericSaveButton);
        genericTagButtonsPanel.add(this.genericCancelButton);
        return genericTagButtonsPanel;
    }

    private JPanel createMetadataButtonsPanel() {
        this.metadataEditButton = new JButton(this.mainPanel.translate("button.edit"), View.getIcon("edit16"));
        this.metadataEditButton.setMargin(new Insets(3, 3, 3, 10));
        this.metadataEditButton.addActionListener(this::editMetadataButtonActionPerformed);
        this.metadataSaveButton = new JButton(this.mainPanel.translate("button.save"), View.getIcon("save16"));
        this.metadataSaveButton.setMargin(new Insets(3, 3, 3, 10));
        this.metadataSaveButton.addActionListener(this::saveMetadataButtonActionPerformed);
        this.metadataSaveButton.setVisible(false);
        this.metadataCancelButton = new JButton(this.mainPanel.translate("button.cancel"), View.getIcon("cancel16"));
        this.metadataCancelButton.setMargin(new Insets(3, 3, 3, 10));
        this.metadataCancelButton.addActionListener(this::cancelMetadataButtonActionPerformed);
        this.metadataCancelButton.setVisible(false);
        ButtonsPanel metadataTagButtonsPanel = new ButtonsPanel();
        metadataTagButtonsPanel.add(this.metadataEditButton);
        metadataTagButtonsPanel.add(this.metadataSaveButton);
        metadataTagButtonsPanel.add(this.metadataCancelButton);
        return metadataTagButtonsPanel;
    }

    private JPanel createFlashPlayerPanel(FlashPlayerPanel flashPanel) {
        JPanel leftComponent;
        JPanel pan = new JPanel(new BorderLayout());
        HeaderLabel prevLabel = new HeaderLabel(this.mainPanel.translate("swfpreview"));
        prevLabel.setHorizontalAlignment(0);
        pan.add((Component)prevLabel, "North");
        if (flashPanel != null) {
            JPanel flashPlayPanel = new JPanel(new BorderLayout());
            flashPlayPanel.add((Component)flashPanel, "Center");
            JPanel flashPlayPanel2 = new JPanel(new BorderLayout());
            flashPlayPanel2.add((Component)flashPlayPanel, "Center");
            flashPlayPanel2.add((Component)new PlayerControls(this.mainPanel, flashPanel), "South");
            leftComponent = flashPlayPanel2;
        } else {
            JPanel swtPanel = new JPanel(new GridBagLayout());
            JPanel buttonsPanel = new JPanel(new FlowLayout());
            JButton flashProjectorButton = new JButton(this.mainPanel.translate("button.showin.flashprojector"));
            flashProjectorButton.addActionListener(this::flashProjectorActionPerformed);
            buttonsPanel.add(flashProjectorButton);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 10;
            gbc.fill = 2;
            swtPanel.add((Component)buttonsPanel, gbc);
            leftComponent = swtPanel;
        }
        pan.add((Component)leftComponent, "Center");
        return pan;
    }

    private void flashProjectorActionPerformed(ActionEvent e) {
        this.createAndRunTempSwf(this.currentItem);
    }

    private JPanel createImagesCard() {
        JPanel shapesCard = new JPanel(new BorderLayout());
        JPanel previewPanel = new JPanel(new BorderLayout());
        JPanel previewCnt = new JPanel(new BorderLayout());
        this.imagePanel = new ImagePanel();
        this.imagePanel.setLoop((Boolean)Configuration.loopMedia.get());
        previewCnt.add((Component)this.imagePanel, "Center");
        this.imagePlayControls = new PlayerControls(this.mainPanel, this.imagePanel);
        previewCnt.add((Component)this.imagePlayControls, "South");
        this.imagePlayControls.setMedia(this.imagePanel);
        previewPanel.add((Component)previewCnt, "Center");
        HeaderLabel prevIntLabel = new HeaderLabel(this.mainPanel.translate("swfpreview.internal"));
        prevIntLabel.setHorizontalAlignment(0);
        previewPanel.add((Component)prevIntLabel, "North");
        shapesCard.add((Component)previewPanel, "Center");
        shapesCard.add((Component)this.createImageButtonsPanel(), "South");
        return shapesCard;
    }

    private JPanel createMetadataCard() {
        JPanel metadataCard = new JPanel(new BorderLayout());
        this.metadataEditor = new LineMarkedEditorPane();
        metadataCard.add((Component)new FasterScrollPane(this.metadataEditor), "Center");
        this.metadataEditor.setEditable(false);
        this.metadataEditor.setFont(Configuration.getSourceFont());
        this.metadataEditor.changeContentType("text/xml");
        this.metadataEditor.addTextChangedListener(this::metadataTextChanged);
        metadataCard.add((Component)this.createMetadataButtonsPanel(), "South");
        return metadataCard;
    }

    private boolean isMetadataModified() {
        return this.metadataSaveButton.isVisible() && this.metadataSaveButton.isEnabled();
    }

    private void setMetadataModified(boolean value) {
        this.metadataSaveButton.setEnabled(value);
        this.metadataCancelButton.setEnabled(value);
    }

    private void metadataTextChanged() {
        this.setMetadataModified(true);
    }

    private void updateMetadataButtonsVisibility() {
        boolean edit = this.metadataEditor.isEditable();
        boolean editorMode = (Boolean)Configuration.editorMode.get();
        this.metadataEditButton.setVisible(!this.readOnly && !edit);
        this.metadataSaveButton.setVisible(!this.readOnly && edit);
        boolean metadataModified = this.isMetadataModified();
        this.metadataCancelButton.setVisible(!this.readOnly && edit);
        this.metadataCancelButton.setEnabled(metadataModified || !editorMode);
    }

    private JPanel createBinaryCard() {
        JPanel binaryCard = new JPanel(new BorderLayout());
        this.binaryPanel = new BinaryPanel(this.mainPanel);
        binaryCard.add((Component)this.binaryPanel, "Center");
        binaryCard.add((Component)this.createBinaryButtonsPanel(), "South");
        return binaryCard;
    }

    private JPanel createUnknownCard() {
        JPanel unknownCard = new JPanel(new BorderLayout());
        this.unknownHexView = new HexView();
        unknownCard.add((Component)this.unknownHexView, "Center");
        unknownCard.add((Component)this.createUnknownButtonsPanel(), "South");
        return unknownCard;
    }

    private JPanel createGenericTagCard() {
        JPanel genericTagCard = new JPanel(new BorderLayout());
        this.genericTagPanel = new GenericTagTreePanel(this.mainPanel);
        genericTagCard.add((Component)this.genericTagPanel, "Center");
        genericTagCard.add((Component)this.createGenericTagButtonsPanel(), "South");
        return genericTagCard;
    }

    private JPanel createPlaceTagCard() {
        JPanel placeTagCard = new JPanel(new BorderLayout());
        JPanel previewPanel = new JPanel(new BorderLayout());
        JPanel previewCnt = new JPanel(new BorderLayout());
        this.placeImagePanel = new ImagePanel();
        previewCnt.add((Component)this.placeImagePanel, "Center");
        PlayerControls placeImagePlayControls = new PlayerControls(this.mainPanel, this.placeImagePanel);
        previewCnt.add((Component)placeImagePlayControls, "South");
        placeImagePlayControls.setMedia(this.placeImagePanel);
        previewPanel.add((Component)previewCnt, "Center");
        HeaderLabel prevIntLabel = new HeaderLabel(this.mainPanel.translate("swfpreview.internal"));
        prevIntLabel.setHorizontalAlignment(0);
        previewPanel.add((Component)prevIntLabel, "North");
        this.placeGenericPanel = new GenericTagTreePanel(this.mainPanel);
        this.placeSplitPane = new JSplitPane(1, previewPanel, this.placeGenericPanel);
        placeTagCard.add((Component)this.placeSplitPane, "Center");
        placeTagCard.add((Component)this.createPlaceTagButtonsPanel(), "South");
        return placeTagCard;
    }

    private JPanel createPlaceTagButtonsPanel() {
        this.placeFreeTransformButton = new JButton(this.mainPanel.translate("button.freetransform"), View.getIcon("freetransform16"));
        this.placeFreeTransformButton.setMargin(new Insets(3, 3, 3, 10));
        this.placeFreeTransformButton.addActionListener(this::freeTransformPlaceTagButtonActionPerformed);
        this.placeEditButton = new JButton(this.mainPanel.translate("button.edit"), View.getIcon("edit16"));
        this.placeEditButton.setMargin(new Insets(3, 3, 3, 10));
        this.placeEditButton.addActionListener(this::editPlaceTagButtonActionPerformed);
        this.placeSaveButton = new JButton(this.mainPanel.translate("button.save"), View.getIcon("save16"));
        this.placeSaveButton.setMargin(new Insets(3, 3, 3, 10));
        this.placeSaveButton.addActionListener(this::savePlaceTagButtonActionPerformed);
        this.placeSaveButton.setVisible(false);
        this.placeCancelButton = new JButton(this.mainPanel.translate("button.cancel"), View.getIcon("cancel16"));
        this.placeCancelButton.setMargin(new Insets(3, 3, 3, 10));
        this.placeCancelButton.addActionListener(this::cancelPlaceTagButtonActionPerformed);
        this.placeCancelButton.setVisible(false);
        ButtonsPanel placeTagButtonsPanel = new ButtonsPanel();
        placeTagButtonsPanel.add(this.placeFreeTransformButton);
        placeTagButtonsPanel.add(this.placeEditButton);
        placeTagButtonsPanel.add(this.placeSaveButton);
        placeTagButtonsPanel.add(this.placeCancelButton);
        return placeTagButtonsPanel;
    }

    private void showCardLeft(String card) {
        CardLayout cl = (CardLayout)this.viewerCards.getLayout();
        cl.show(this.viewerCards, card);
        this.imagePanel.stop();
        this.placeImagePanel.stop();
    }

    private void showCardRight(String card) {
        CardLayout cl = (CardLayout)this.displayWithPreview.getLayout();
        cl.show(this.displayWithPreview, card);
    }

    public TextPanel getTextPanel() {
        return this.textPanel;
    }

    public void setParametersPanelVisible(boolean show) {
        this.parametersPanel.setVisible(show);
    }

    public void showFlashViewerPanel() {
        this.parametersPanel.setVisible(false);
        this.showCardLeft(FLASH_VIEWER_CARD);
    }

    public void showImagePanel(Timelined timelined, SWF swf, int frame) {
        this.showCardLeft(DRAW_PREVIEW_CARD);
        this.parametersPanel.setVisible(false);
        this.imagePlayControls.setMedia(this.imagePanel);
        this.imagePanel.setTimelined(timelined, swf, frame);
    }

    public void showImagePanel(SerializableImage image) {
        this.showCardLeft(DRAW_PREVIEW_CARD);
        this.parametersPanel.setVisible(false);
        this.imagePlayControls.setMedia(this.imagePanel);
        this.imagePanel.setImage(image);
    }

    public void showTextComparePanel(TextTag textTag, TextTag newTextTag) {
        this.imagePanel.setText(textTag, newTextTag);
    }

    public void setMedia(MediaDisplay media) {
        this.media = media;
        this.imagePlayControls.setMedia(media);
    }

    public void showFontPanel(FontTag fontTag) {
        this.fontPageNum = 0;
        this.showFontPage(fontTag);
        this.showCardRight(CARDFONTPANEL);
        if (!this.readOnly) {
            this.parametersPanel.setVisible(true);
        }
        this.fontPanel.showFontTag(fontTag);
        int pageCount = PreviewPanel.getFontPageCount(fontTag);
        if (pageCount > 1) {
            this.prevFontsButton.setVisible(true);
            this.nextFontsButton.setVisible(true);
        }
    }

    private void showFontPage(FontTag fontTag) {
        if (!this.mainPanel.isAdobeFlashPlayerEnabled()) {
            this.showImagePanel(MainPanel.makeTimelined((Tag)fontTag), fontTag.getSwf(), this.fontPageNum);
        }
    }

    public static int getFontPageCount(FontTag fontTag) {
        int pageCount = (fontTag.getGlyphShapeTable().size() - 1) / 400 + 1;
        if (pageCount < 1) {
            pageCount = 1;
        }
        return pageCount;
    }

    public void showEmpty() {
        this.showCardLeft(EMPTY_CARD);
    }

    public void showTextPanel(TextTag textTag) {
        if (!this.mainPanel.isAdobeFlashPlayerEnabled()) {
            this.showImagePanel(MainPanel.makeTimelined((Tag)textTag), textTag.getSwf(), 0);
        }
        this.showCardRight(CARDTEXTPANEL);
        if (!this.readOnly) {
            this.parametersPanel.setVisible(true);
        }
        this.textPanel.setText(textTag);
    }

    public void focusTextPanel() {
        this.textPanel.focusTextValue();
    }

    public void clear() {
        this.imagePanel.clearAll();
        if (this.media != null) {
            try {
                this.media.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.binaryPanel.setBinaryData(null);
        this.genericTagPanel.clear();
        this.fontPanel.clear();
    }

    public void closeTag() {
        this.textPanel.closeTag();
    }

    public static String formatMetadata(String input, int indent) {
        input = input.replace("> <", "><");
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            StringWriter sw = new StringWriter();
            xmlOutput.setWriter(sw);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "" + indent);
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (IllegalArgumentException | TransformerException e) {
            return input;
        }
    }

    public void showMetaDataPanel(MetadataTag metadataTag) {
        this.showCardLeft(METADATA_TAG_CARD);
        this.metadataTag = metadataTag;
        this.metadataEditor.setEditable(!this.readOnly && !metadataTag.isReadOnly() && (Boolean)Configuration.editorMode.get() != false);
        this.metadataEditor.setText(PreviewPanel.formatMetadata(metadataTag.xmlMetadata, 4));
        this.setMetadataModified(false);
        this.updateMetadataButtonsVisibility();
        this.parametersPanel.setVisible(false);
    }

    public void showBinaryPanel(DefineBinaryDataTag binaryDataTag) {
        this.showCardLeft(BINARY_TAG_CARD);
        this.binaryPanel.setBinaryData(binaryDataTag);
        this.parametersPanel.setVisible(false);
    }

    public void showUnknownPanel(UnknownTag unknownTag) {
        this.showCardLeft(UNKNOWN_TAG_CARD);
        if (unknownTag == null) {
            this.unknownHexView.setData(new byte[0], null, null);
        } else {
            this.unknownHexView.setData(unknownTag.unknownData.getRangeData(), null, null);
        }
        this.parametersPanel.setVisible(false);
    }

    public void showGenericTagPanel(Tag tag) {
        this.showCardLeft(GENERIC_TAG_CARD);
        this.genericEditButton.setVisible(!tag.isReadOnly());
        this.genericEditButton.setEnabled(true);
        this.genericSaveButton.setVisible(false);
        this.genericCancelButton.setVisible(false);
        this.genericTagPanel.setEditMode(false, tag);
        this.parametersPanel.setVisible(false);
    }

    public void showPlaceTagPanel(PlaceObjectTypeTag tag, int frame) {
        this.showCardLeft(PLACE_TAG_CARD);
        this.placeTag = tag;
        this.oldMatrix = tag.getMatrix();
        this.placeSplitPane.setDividerLocation((int)(0.6 * (double)this.getWidth()));
        this.placeGenericPanel.setEditMode(false, (Tag)tag);
        this.placeImagePanel.selectDepth(-1);
        this.placeImagePanel.setTimelined(tag.getTimelined(), tag.getSwf(), frame);
        this.placeImagePanel.selectDepth(tag.getDepth());
        this.parametersPanel.setVisible(false);
        this.placeEditButton.setVisible(!tag.isReadOnly());
        this.placeEditButton.setEnabled(true);
        this.placeSaveButton.setVisible(false);
        this.placeCancelButton.setVisible(false);
    }

    public void setImageReplaceButtonVisible(boolean show, boolean showAlpha) {
        if (this.readOnly) {
            show = false;
            showAlpha = false;
        }
        this.replaceImageButton.setVisible(show);
        this.replaceImageAlphaButton.setVisible(showAlpha);
        this.prevFontsButton.setVisible(false);
        this.nextFontsButton.setVisible(false);
    }

    private void createAndRunTempSwf(TreeItem treeItem) {
        try {
            SetBackgroundColorTag setBgColorTag;
            SWF sourceSwf;
            Frame fn;
            File extTempFile = File.createTempFile("ffdec_viewext_", ".swf");
            extTempFile.deleteOnExit();
            if (treeItem instanceof SWF) {
                SWF swf = (SWF)treeItem;
                try (FileOutputStream fos = new FileOutputStream(extTempFile);){
                    swf.saveTo((OutputStream)fos);
                }
            }
            Color backgroundColor = View.getSwfBackgroundColor();
            if (treeItem instanceof Tag) {
                Tag tag = (Tag)treeItem;
                if (tag instanceof FontTag) {
                    backgroundColor = View.getDefaultBackgroundColor();
                }
            } else if (treeItem instanceof Frame && fn.timeline.timelined == (sourceSwf = (fn = (Frame)treeItem).getSwf()) && (setBgColorTag = sourceSwf.getBackgroundColor()) != null) {
                backgroundColor = setBgColorTag.backgroundColor.toColor();
            }
            try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(extTempFile));){
                SWFHeader header = new PreviewExporter().exportSwf((OutputStream)fos, treeItem, backgroundColor, this.fontPageNum, true);
            }
            Main.runAsync(extTempFile);
        }
        catch (ActionParseException | IOException ex) {
            Logger.getLogger(PreviewPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void createAndShowTempSwf(TreeItem treeItem) {
        try {
            SWFHeader header;
            SetBackgroundColorTag setBgColorTag;
            SWF sourceSwf;
            Frame fn;
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
            this.tempFile = File.createTempFile("ffdec_view_", ".swf");
            this.tempFile.deleteOnExit();
            Color backgroundColor = View.getSwfBackgroundColor();
            if (treeItem instanceof Tag) {
                Tag tag = (Tag)treeItem;
                if (tag instanceof FontTag) {
                    backgroundColor = View.getDefaultBackgroundColor();
                }
            } else if (treeItem instanceof Frame && fn.timeline.timelined == (sourceSwf = (fn = (Frame)treeItem).getSwf()) && (setBgColorTag = sourceSwf.getBackgroundColor()) != null) {
                backgroundColor = setBgColorTag.backgroundColor.toColor();
            }
            try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.tempFile));){
                header = new PreviewExporter().exportSwf((OutputStream)fos, treeItem, backgroundColor, this.fontPageNum, false);
            }
            if (this.flashPanel != null) {
                this.flashPanel.displaySWF(this.tempFile.getAbsolutePath(), backgroundColor, header.frameRate);
            }
            this.currentItem = treeItem;
            this.showFlashViewerPanel();
        }
        catch (ActionParseException | IOException ex) {
            Logger.getLogger(PreviewPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void showSwf(SWF swf) {
        this.currentItem = swf;
        if (this.flashPanel == null) {
            return;
        }
        Color backgroundColor = View.getDefaultBackgroundColor();
        SetBackgroundColorTag setBgColorTag = swf.getBackgroundColor();
        if (setBgColorTag != null) {
            backgroundColor = setBgColorTag.backgroundColor.toColor();
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        try {
            this.tempFile = File.createTempFile("ffdec_view_", ".swf");
            try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.tempFile));){
                swf.saveTo((OutputStream)fos, false);
            }
            if (swf.isAS3() && ((Boolean)Configuration.autoOpenLoadedSWFs.get()).booleanValue() && ((Boolean)Configuration.useAdobeFlashPlayerForPreviews.get()).booleanValue() && !DebuggerTools.hasDebugger(swf)) {
                SWF instrSWF;
                try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(this.tempFile));){
                    instrSWF = new SWF((InputStream)fis, false, false);
                }
                DebuggerTools.switchDebugger(instrSWF);
                DebuggerTools.injectDebugLoader(instrSWF);
                var6_10 = null;
                try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.tempFile));){
                    instrSWF.saveTo((OutputStream)fos);
                }
                catch (Throwable throwable) {
                    var6_10 = throwable;
                    throw throwable;
                }
            }
            this.flashPanel.displaySWF(this.tempFile.getAbsolutePath(), backgroundColor, swf.frameRate);
        }
        catch (IOException iex) {
            Logger.getLogger(PreviewPanel.class.getName()).log(Level.SEVERE, "Cannot create tempfile", iex);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void editMetadataButtonActionPerformed(ActionEvent evt) {
        TreeItem item = this.mainPanel.tagTree.getCurrentTreeItem();
        if (item == null) {
            return;
        }
        if (item instanceof MetadataTag) {
            this.metadataEditor.setEditable(true);
            this.updateMetadataButtonsVisibility();
        }
    }

    private void saveMetadataButtonActionPerformed(ActionEvent evt) {
        this.metadataTag.xmlMetadata = this.metadataEditor.getText().replaceAll(">\r?\n<", "> <");
        this.metadataTag.setModified(true);
        this.metadataEditor.setEditable((Boolean)Configuration.editorMode.get());
        this.setMetadataModified(false);
        this.updateMetadataButtonsVisibility();
        this.mainPanel.repaintTree();
    }

    private void cancelMetadataButtonActionPerformed(ActionEvent evt) {
        this.metadataEditor.setEditable(false);
        this.metadataEditor.setText(PreviewPanel.formatMetadata(this.metadataTag.xmlMetadata, 4));
        this.metadataEditor.setEditable((Boolean)Configuration.editorMode.get());
        this.setMetadataModified(false);
        this.updateMetadataButtonsVisibility();
    }

    private void editGenericTagButtonActionPerformed(ActionEvent evt) {
        TreeItem item = this.mainPanel.tagTree.getCurrentTreeItem();
        if (item == null) {
            return;
        }
        if (item instanceof TagScript) {
            item = ((TagScript)item).getTag();
        }
        if (item instanceof Tag) {
            this.genericEditButton.setVisible(false);
            this.genericSaveButton.setVisible(true);
            this.genericCancelButton.setVisible(true);
            this.genericTagPanel.setEditMode(true, (Tag)item);
        }
    }

    private void saveGenericTagButtonActionPerformed(ActionEvent evt) {
        if (this.genericTagPanel.save()) {
            Tag tag = this.genericTagPanel.getTag();
            SWF swf = tag.getSwf();
            swf.clearImageCache();
            swf.updateCharacters();
            tag.getTimelined().resetTimeline();
            swf.assignClassesToSymbols();
            swf.assignExportNamesToSymbols();
            this.mainPanel.refreshTree(swf);
            this.mainPanel.setTagTreeSelectedNode((TreeItem)tag);
            this.genericEditButton.setVisible(true);
            this.genericSaveButton.setVisible(false);
            this.genericCancelButton.setVisible(false);
            this.genericTagPanel.setEditMode(false, null);
        }
    }

    private void cancelGenericTagButtonActionPerformed(ActionEvent evt) {
        this.genericEditButton.setVisible(true);
        this.genericSaveButton.setVisible(false);
        this.genericCancelButton.setVisible(false);
        this.genericTagPanel.setEditMode(false, null);
    }

    private void savePlaceTagButtonActionPerformed(ActionEvent evt) {
        if (this.placeEditMode == 1) {
            MATRIX matrix = this.placeImagePanel.getNewMatrix();
            this.placeTag.setPlaceFlagHasMatrix(true);
            this.placeTag.setMatrix(matrix);
            this.placeTag.setModified(true);
            this.placeImagePanel.selectDepth(this.placeTag.getDepth());
            this.placeImagePanel.freeTransformDepth(-1);
            this.placeTag.getTimelined().resetTimeline();
        }
        if (this.placeEditMode == 2) {
            if (this.placeGenericPanel.save()) {
                Tag tag = this.placeGenericPanel.getTag();
                SWF swf = tag.getSwf();
                tag.getTimelined().resetTimeline();
                this.mainPanel.refreshTree(swf);
                this.mainPanel.setTagTreeSelectedNode((TreeItem)tag);
            }
            this.placeGenericPanel.setEditMode(false, null);
        }
        this.placeFreeTransformButton.setVisible(true);
        this.placeEditButton.setVisible(true);
        this.placeSaveButton.setVisible(false);
        this.placeCancelButton.setVisible(false);
        this.mainPanel.repaintTree();
    }

    private void editPlaceTagButtonActionPerformed(ActionEvent evt) {
        this.placeEditMode = 2;
        this.placeGenericPanel.setEditMode(true, (Tag)this.placeTag);
        this.placeEditButton.setVisible(false);
        this.placeFreeTransformButton.setVisible(false);
        this.placeSaveButton.setVisible(true);
        this.placeCancelButton.setVisible(true);
    }

    private void freeTransformPlaceTagButtonActionPerformed(ActionEvent evt) {
        TreeItem item = this.mainPanel.tagTree.getCurrentTreeItem();
        if (item == null) {
            return;
        }
        this.placeEditMode = 1;
        this.placeImagePanel.selectDepth(-1);
        this.placeImagePanel.freeTransformDepth(this.placeTag.getDepth());
        this.placeEditButton.setVisible(false);
        this.placeFreeTransformButton.setVisible(false);
        this.placeSaveButton.setVisible(true);
        this.placeCancelButton.setVisible(true);
    }

    private void cancelPlaceTagButtonActionPerformed(ActionEvent evt) {
        if (this.placeEditMode == 1) {
            this.placeImagePanel.selectDepth(this.placeTag.getDepth());
            this.placeImagePanel.freeTransformDepth(-1);
            this.placeTag.setMatrix(this.oldMatrix);
            this.placeTag.getTimelined().resetTimeline();
        }
        if (this.placeEditMode == 2) {
            this.placeGenericPanel.setEditMode(false, null);
        }
        this.placeEditButton.setVisible(true);
        this.placeFreeTransformButton.setVisible(true);
        this.placeSaveButton.setVisible(false);
        this.placeCancelButton.setVisible(false);
    }

    private void prevFontsButtonActionPerformed(ActionEvent evt) {
        FontTag fontTag = this.fontPanel.getFontTag();
        int pageCount = PreviewPanel.getFontPageCount(fontTag);
        this.fontPageNum = (this.fontPageNum + pageCount - 1) % pageCount;
        if (!this.mainPanel.isAdobeFlashPlayerEnabled()) {
            this.imagePanel.setTimelined(MainPanel.makeTimelined((Tag)fontTag, this.fontPageNum), fontTag.getSwf(), 0);
        }
    }

    private void nextFontsButtonActionPerformed(ActionEvent evt) {
        FontTag fontTag = this.fontPanel.getFontTag();
        int pageCount = PreviewPanel.getFontPageCount(fontTag);
        this.fontPageNum = (this.fontPageNum + 1) % pageCount;
        if (!this.mainPanel.isAdobeFlashPlayerEnabled()) {
            this.imagePanel.setTimelined(MainPanel.makeTimelined((Tag)fontTag, this.fontPageNum), fontTag.getSwf(), 0);
        }
    }

    @Override
    public boolean tryAutoSave() {
        if (this.textPanel.tryAutoSave()) {
            // empty if block
        }
        return false;
    }

    @Override
    public boolean isEditing() {
        return this.textPanel.isEditing() || this.genericSaveButton.isVisible() && this.genericSaveButton.isEnabled() || this.metadataSaveButton.isVisible() && this.metadataSaveButton.isEnabled();
    }

    public void selectImageDepth(int depth) {
        this.imagePanel.selectDepth(depth);
    }
}

