/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainFrameMenu;
import com.jpexs.decompiler.flash.gui.MainFrameRibbon;
import com.jpexs.decompiler.flash.gui.MenuBuilder;
import com.jpexs.decompiler.flash.gui.OpenFileResult;
import com.jpexs.decompiler.flash.gui.RecentFilesButton;
import com.jpexs.decompiler.flash.gui.RecentSearchesButton;
import com.jpexs.decompiler.flash.gui.SearchListener;
import com.jpexs.decompiler.flash.gui.SearchResultsDialog;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.search.ScriptSearchResult;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandToggleButtonGroup;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryFooter;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryPrimary;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.api.ribbon.resize.BaseRibbonBandResizePolicy;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.IconRibbonBandResizePolicy;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;

public class MainFrameRibbonMenu
extends MainFrameMenu {
    private final JRibbon ribbon;
    private final Map<String, Object> menuItems = new HashMap<String, Object>();
    private final Map<String, String> menuTitles = new HashMap<String, String>();
    private final Map<String, Boolean> menuOptional = new HashMap<String, Boolean>();
    private final Map<String, String> menuIcons = new HashMap<String, String>();
    private final Map<String, ActionListener> menuLoaders = new HashMap<String, ActionListener>();
    private final Map<String, Integer> menuPriorities = new HashMap<String, Integer>();
    private final Map<String, List<String>> menuSubs = new HashMap<String, List<String>>();
    private final Map<String, Integer> menuType = new HashMap<String, Integer>();
    private final Map<String, String> menuGroup = new HashMap<String, String>();
    private final Map<String, CommandToggleButtonGroup> menuToggleGroups = new HashMap<String, CommandToggleButtonGroup>();
    private final Map<String, CommandToggleButtonGroup> menuToToggleGroup = new HashMap<String, CommandToggleButtonGroup>();
    private static final int TYPE_MENU = 1;
    private static final int TYPE_MENUITEM = 2;
    private static final int TYPE_TOGGLEMENUITEM = 3;
    private final Map<String, RibbonContextualTaskGroup> optionalGroups = new HashMap<String, RibbonContextualTaskGroup>();

    public MainFrameRibbonMenu(MainFrameRibbon mainFrame, JRibbon ribbon, boolean externalFlashPlayerUnavailable) {
        super(mainFrame, externalFlashPlayerUnavailable);
        this.ribbon = ribbon;
    }

    private String fixCommandTitle(String title) {
        if (title.length() > 2 && title.charAt(1) == ' ') {
            title = title.charAt(0) + "\u00a0" + title.substring(2);
        }
        return title;
    }

    private RibbonBandResizePolicy titleResizePolicies(final JRibbonBand ribbonBand) {
        return new BaseRibbonBandResizePolicy<AbstractBandControlPanel>(ribbonBand.getControlPanel()){

            public int getPreferredWidth(int i, int i1) {
                return ribbonBand.getGraphics().getFontMetrics(ribbonBand.getFont()).stringWidth(ribbonBand.getTitle()) + 20;
            }

            public void install(int i, int i1) {
            }
        };
    }

    private List<RibbonBandResizePolicy> getResizePolicies(JRibbonBand ribbonBand) {
        final ArrayList<Object> myResizePolicies = new ArrayList<Object>();
        myResizePolicies.add(new CoreRibbonResizePolicies.Mirror((JBandControlPanel)ribbonBand.getControlPanel()));
        myResizePolicies.add(this.titleResizePolicies(ribbonBand));
        myResizePolicies.add(new IconRibbonBandResizePolicy(ribbonBand.getControlPanel()));
        ArrayList<RibbonBandResizePolicy> resizePolicies = new ArrayList<RibbonBandResizePolicy>();
        resizePolicies.add(new RibbonBandResizePolicy(){

            public int getPreferredWidth(int i, int i1) {
                int pw = 0;
                for (RibbonBandResizePolicy p : myResizePolicies) {
                    int npw = p.getPreferredWidth(i, i1);
                    if (npw <= pw) continue;
                    pw = npw;
                }
                return pw;
            }

            public void install(int i, int i1) {
                for (RibbonBandResizePolicy p : myResizePolicies) {
                    p.install(i, i1);
                }
            }
        });
        return resizePolicies;
    }

    @Override
    protected void loadRecentSearches(ActionEvent evt) {
        if (evt.getSource() instanceof JPanel) {
            JPanel targetPanel = (JPanel)evt.getSource();
            targetPanel.removeAll();
            JCommandButtonPanel searchHistoryPanel = new JCommandButtonPanel(CommandButtonDisplayState.MEDIUM);
            String groupName = this.translate("menu.recentSearches");
            searchHistoryPanel.addButtonGroup(groupName);
            SWF swf = Main.getMainFrame().getPanel().getCurrentSwf();
            List<Integer> indices = Main.searchResultsStorage.getIndicesForSwf(swf);
            int height = 0;
            height = searchHistoryPanel.getInsets().top + searchHistoryPanel.getInsets().bottom + 6 + new JLabel((String)groupName).getPreferredSize().height + 4;
            height += 6;
            int j = 0;
            for (int i = indices.size() - 1; i >= 0; --i) {
                int fi = indices.get(i);
                String searched = Main.searchResultsStorage.getSearchedValueAt(fi);
                RecentSearchesButton historyButton = new RecentSearchesButton(j + "    " + searched, null);
                historyButton.search = searched;
                historyButton.addActionListener(ae -> {
                    ArrayList<SearchListener<JPanel>> listeners = new ArrayList<SearchListener<JPanel>>();
                    listeners.add(Main.getMainFrame().getPanel().getABCPanel());
                    listeners.add(Main.getMainFrame().getPanel().getActionPanel());
                    SearchResultsDialog<Object> sr = swf.isAS3() ? new SearchResultsDialog<ScriptSearchResult>(Main.getDefaultDialogsOwner(), searched, Main.searchResultsStorage.isIgnoreCaseAt(fi), Main.searchResultsStorage.isRegExpAt(fi), listeners) : new SearchResultsDialog(Main.getDefaultDialogsOwner(), searched, Main.searchResultsStorage.isIgnoreCaseAt(fi), Main.searchResultsStorage.isRegExpAt(fi), listeners);
                    sr.setResults(Main.searchResultsStorage.getSearchResultsAt(Main.getMainFrame().getPanel().getAllSwfs(), fi));
                    sr.setVisible(true);
                    Main.getMainFrame().getPanel().searchResultsDialogs.add(sr);
                });
                ++j;
                historyButton.setHorizontalAlignment(2);
                searchHistoryPanel.addButtonToLastGroup((AbstractCommandButton)historyButton);
                height += historyButton.getHeight() + 4;
            }
            if (indices.isEmpty()) {
                JCommandButton emptyLabel = new JCommandButton(this.translate("menu.recentSearches.empty"));
                emptyLabel.setHorizontalAlignment(2);
                emptyLabel.setEnabled(false);
                searchHistoryPanel.addButtonToLastGroup((AbstractCommandButton)emptyLabel);
                height += emptyLabel.getHeight() + 4;
            } else {
                JCommandButton clearButton = new JCommandButton(this.translate("menu.recentSearches.clear"));
                clearButton.setHorizontalAlignment(2);
                clearButton.addActionListener(this::clearRecentSearchesForCurrentSwfActionPerformed);
                searchHistoryPanel.addButtonToLastGroup((AbstractCommandButton)clearButton);
                height += clearButton.getHeight() + 4;
            }
            searchHistoryPanel.setMaxButtonColumns(1);
            targetPanel.setLayout(new BorderLayout());
            FasterScrollPane scrollPane = new FasterScrollPane((Component)searchHistoryPanel);
            int maxHeight = Main.getMainFrame().getPanel().getHeight();
            boolean needsScrollBar = false;
            if ((height += scrollPane.getInsets().top + scrollPane.getInsets().bottom) > maxHeight) {
                height = maxHeight;
                needsScrollBar = true;
            }
            int scrollBarSize = (Integer)UIManager.get("ScrollBar.width");
            scrollPane.setPreferredSize(new Dimension(Math.max(new JLabel((String)groupName).getPreferredSize().width + 12 + scrollPane.getInsets().left + scrollPane.getInsets().right + (needsScrollBar ? scrollBarSize : 0), scrollPane.getPreferredSize().width), height));
            targetPanel.add((Component)scrollPane, "Center");
        }
    }

    @Override
    protected void loadRecent(ActionEvent evt) {
        if (evt.getSource() instanceof JPanel) {
            JPanel targetPanel = (JPanel)evt.getSource();
            targetPanel.removeAll();
            JCommandButtonPanel openHistoryPanel = new JCommandButtonPanel(CommandButtonDisplayState.MEDIUM);
            String groupName = this.translate("menu.recentFiles");
            openHistoryPanel.addButtonGroup(groupName);
            List recentFiles = Configuration.getRecentFiles();
            int j = 0;
            for (int i = recentFiles.size() - 1; i >= 0; --i) {
                String path = (String)recentFiles.get(i);
                RecentFilesButton historyButton = new RecentFilesButton(j + "    " + path, null);
                historyButton.fileName = path;
                historyButton.addActionListener(ae -> {
                    RecentFilesButton source = (RecentFilesButton)((Object)((Object)ae.getSource()));
                    if (Main.openFile(source.fileName, null) == OpenFileResult.NOT_FOUND && ViewMessages.showConfirmDialog(Main.getDefaultMessagesComponent(), this.translate("message.confirm.recentFileNotFound"), this.translate("message.confirm"), 0) == 0) {
                        Configuration.removeRecentFile((String)source.fileName);
                    }
                });
                ++j;
                historyButton.setHorizontalAlignment(2);
                openHistoryPanel.addButtonToLastGroup((AbstractCommandButton)historyButton);
            }
            if (recentFiles.isEmpty()) {
                JCommandButton emptyLabel = new JCommandButton(this.translate("menu.recentFiles.empty"));
                emptyLabel.setHorizontalAlignment(2);
                emptyLabel.setEnabled(false);
                openHistoryPanel.addButtonToLastGroup((AbstractCommandButton)emptyLabel);
            }
            openHistoryPanel.setMaxButtonColumns(1);
            targetPanel.setLayout(new BorderLayout());
            targetPanel.add((Component)openHistoryPanel, "Center");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void finishMenu(String path) {
        void var12_18;
        int subType;
        String[] stringArray;
        if (!this.menuTitles.containsKey(path)) {
            throw new IllegalArgumentException("Menu not started: " + path);
        }
        boolean isAppMenu = path.equals("_");
        String title = this.menuTitles.get(path);
        String icon = this.menuIcons.get(path);
        ActionListener action = (ActionListener)this.menuActions.get(path);
        int priority = this.menuPriorities.get(path);
        int type = this.menuType.get(path);
        if (type != 1) {
            throw new IllegalArgumentException("Not a menu: " + path);
        }
        if (path.contains("/")) {
            stringArray = path.split("\\/");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        String[] parts = stringArray;
        List<String> subs = this.menuSubs.get(path);
        boolean onlyCheckboxes = true;
        for (String string : subs) {
            if (string.equals("-")) continue;
            subType = this.menuType.get(string);
            if (subType == 2) {
                onlyCheckboxes = false;
                break;
            }
            String subIcon = this.menuIcons.get(string);
            if (subIcon == null) continue;
            onlyCheckboxes = false;
            break;
        }
        if (subs.isEmpty()) {
            onlyCheckboxes = false;
        }
        if (isAppMenu) {
            RibbonApplicationMenu mainMenu = new RibbonApplicationMenu();
            for (final String sub : subs) {
                if (sub.equals("-")) {
                    mainMenu.addMenuSeparator();
                    continue;
                }
                String subTitle = this.menuTitles.get(sub);
                String subIcon = this.menuIcons.get(sub);
                int subType2 = this.menuType.get(sub);
                ActionListener subAction = (ActionListener)this.menuActions.get(sub);
                final ActionListener subLoader = this.menuLoaders.get(sub);
                if (sub.startsWith("_/$")) {
                    RibbonApplicationMenuEntryFooter footerMenu = new RibbonApplicationMenuEntryFooter((ResizableIcon)View.getResizableIcon(subIcon, 16), subTitle, subAction);
                    this.menuItems.put(sub, footerMenu);
                    mainMenu.addFooterEntry(footerMenu);
                    continue;
                }
                RibbonApplicationMenuEntryPrimary menu = new RibbonApplicationMenuEntryPrimary((ResizableIcon)View.getResizableIcon(subIcon, 32), subTitle, subAction, subType2 == 1 ? JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION : JCommandButton.CommandButtonKind.ACTION_ONLY);
                if (subLoader != null) {
                    menu.setRolloverCallback(new RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback(){

                        public void menuEntryActivated(JPanel targetPanel) {
                            subLoader.actionPerformed(new ActionEvent(targetPanel, 0, "load:" + sub));
                        }
                    });
                }
                this.menuItems.put(sub, menu);
                mainMenu.addMenuEntry(menu);
            }
            this.ribbon.setApplicationMenu(mainMenu);
            return;
        }
        for (final String string : subs) {
            String keyStr;
            if (string.equals("-")) continue;
            subType = this.menuType.get(string);
            ActionListener subAction = (ActionListener)this.menuActions.get(string);
            String subTitle = this.menuTitles.get(string);
            String subIcon = this.menuIcons.get(string);
            String subGroup = this.menuGroup.get(string);
            MenuBuilder.HotKey subKey = (MenuBuilder.HotKey)this.menuHotkeys.get(string);
            if (subKey != null && (keyStr = subKey.toString()).length() < 8) {
                subTitle = subTitle + " (" + keyStr + ")";
            }
            int subPriority = this.menuPriorities.get(string);
            final ActionListener subLoader = this.menuLoaders.get(string);
            JCommandButton but = null;
            if (subType == 2 || subType == 1 && subAction != null) {
                JCommandButton cbut = subIcon != null ? new JCommandButton(this.fixCommandTitle(subTitle), (ResizableIcon)View.getResizableIcon(subIcon, subPriority == 3 ? 32 : 16)) : new JCommandButton(this.fixCommandTitle(subTitle));
                if (subKey != null) {
                    // empty if block
                }
                if (subLoader != null) {
                    cbut.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                    cbut.setPopupCallback(new PopupPanelCallback(){

                        public JPopupPanel getPopupPanel(JCommandButton jcb) {
                            JPopupPanel jp = new JPopupPanel(){};
                            subLoader.actionPerformed(new ActionEvent(jp, 0, "load:" + string));
                            return jp;
                        }
                    });
                }
                but = cbut;
            } else if (subType == 3) {
                if (onlyCheckboxes) {
                    JCheckBox cb = new JCheckBox(subTitle);
                    if (subAction != null) {
                        cb.addActionListener(subAction);
                    }
                    this.menuItems.put(string, cb);
                } else {
                    but = subIcon != null ? new JCommandToggleButton(this.fixCommandTitle(subTitle), (ResizableIcon)View.getResizableIcon(subIcon, subPriority == 3 ? 32 : 16)) : new JCommandToggleButton(this.fixCommandTitle(subTitle));
                    this.menuToToggleGroup.get(string).add((JCommandToggleButton)but);
                }
            }
            if (but == null) continue;
            if (subAction != null) {
                but.addActionListener(subAction);
            }
            this.menuItems.put(string, but);
        }
        JRibbonBand band = new JRibbonBand(title, (ResizableIcon)(icon != null ? View.getResizableIcon(icon, 16) : null), null);
        band.setResizePolicies(this.getResizePolicies(band));
        boolean bl = false;
        for (String sub : subs) {
            if (sub.equals("-")) continue;
            Object o = this.menuItems.get(sub);
            int subPriority = this.menuPriorities.get(sub);
            int subType3 = this.menuType.get(sub);
            ActionListener subAction = (ActionListener)this.menuActions.get(sub);
            if (subType3 == 1 && subAction == null) continue;
            if (o instanceof AbstractCommandButton) {
                RibbonElementPriority ribbonPriority = RibbonElementPriority.MEDIUM;
                switch (subPriority) {
                    case 1: {
                        ribbonPriority = RibbonElementPriority.LOW;
                        break;
                    }
                    case 2: {
                        ribbonPriority = RibbonElementPriority.MEDIUM;
                        break;
                    }
                    case 3: {
                        ribbonPriority = RibbonElementPriority.TOP;
                    }
                }
                band.addCommandButton((AbstractCommandButton)o, ribbonPriority);
                ++var12_18;
                continue;
            }
            if (!(o instanceof JComponent)) continue;
            band.addRibbonComponent(new JRibbonComponent((JComponent)o));
            ++var12_18;
        }
        if (var12_18 > 0) {
            if (parts.length != 3) {
                if (!this.menuSubs.containsKey(path)) {
                    this.menuSubs.put(path, new ArrayList());
                }
                if (!this.menuSubs.get(path).contains(path + "/_")) {
                    this.menuSubs.get(path).add(0, path + "/_");
                }
                this.menuItems.put(path + "/_", band);
            } else {
                this.menuItems.put(path, band);
            }
        }
        if (parts.length == 1) {
            for (String string : subs) {
                if (string.equals("-") || !(this.menuItems.get(string) instanceof RibbonTask)) continue;
                RibbonTask rt = (RibbonTask)this.menuItems.get(string);
                if (this.menuOptional.get(string).booleanValue()) {
                    RibbonContextualTaskGroup rct = new RibbonContextualTaskGroup("", new Color(128, 0, 0), new RibbonTask[]{rt});
                    this.ribbon.addContextualTaskGroup(rct);
                    this.optionalGroups.put(string, rct);
                    continue;
                }
                this.ribbon.addTask(rt);
            }
        } else if (parts.length == 2) {
            int bandCount = 0;
            for (String sub : subs) {
                if (sub.equals("-") || !(this.menuItems.get(sub) instanceof AbstractRibbonBand)) continue;
                ++bandCount;
            }
            AbstractRibbonBand[] abstractRibbonBandArray = new AbstractRibbonBand[bandCount];
            int b = 0;
            for (String sub : subs) {
                if (sub.equals("-") || !(this.menuItems.get(sub) instanceof AbstractRibbonBand)) continue;
                abstractRibbonBandArray[b++] = (AbstractRibbonBand)this.menuItems.get(sub);
            }
            if (abstractRibbonBandArray.length > 0) {
                RibbonTask task = new RibbonTask(title, abstractRibbonBandArray);
                this.menuItems.put(path, task);
            }
        }
    }

    @Override
    public void addMenuItem(String path, String title, String icon, ActionListener action, int priority, ActionListener subLoader, boolean isLeaf, MenuBuilder.HotKey key, boolean isOptional) {
        String parentPath;
        String string = parentPath = path.contains("/") ? path.substring(0, path.lastIndexOf(47)) : "";
        if (!this.menuSubs.containsKey(parentPath)) {
            throw new IllegalArgumentException("No parent menu exists: " + parentPath);
        }
        this.menuOptional.put(path, isOptional);
        this.menuHotkeys.put(path, key);
        this.menuSubs.get(parentPath).add(path);
        if (!isLeaf) {
            this.menuSubs.put(path, new ArrayList());
        }
        this.menuLoaders.put(path, subLoader);
        this.menuTitles.put(path, title);
        this.menuIcons.put(path, icon);
        this.menuActions.put(path, action);
        this.menuPriorities.put(path, priority);
        this.menuType.put(path, isLeaf ? 2 : 1);
    }

    @Override
    public void addToggleMenuItem(String path, String title, String group, String icon, ActionListener action, int priority, MenuBuilder.HotKey key) {
        this.addMenuItem(path, title, icon, action, priority, action, true, key, false);
        this.menuType.put(path, 3);
        this.menuGroup.put(path, group);
        if (group == null) {
            group = path;
        }
        if (!this.menuToggleGroups.containsKey(group)) {
            this.menuToggleGroups.put(group, new CommandToggleButtonGroup());
        }
        this.menuToToggleGroup.put(path, this.menuToggleGroups.get(group));
    }

    @Override
    public boolean isMenuChecked(String path) {
        Object o = this.menuItems.get(path);
        if (o instanceof JCommandToggleButton) {
            JCommandToggleButton t = (JCommandToggleButton)o;
            if (!this.menuToToggleGroup.containsKey(path)) {
                throw new IllegalArgumentException("No toggle group for " + path);
            }
            return this.menuToToggleGroup.get(path).getSelected() == t;
        }
        if (o instanceof JCheckBox) {
            return ((JCheckBox)o).isSelected();
        }
        throw new IllegalArgumentException("Not a toggle menu");
    }

    @Override
    public void setMenuChecked(String path, boolean checked) {
        Object o = this.menuItems.get(path);
        if (o instanceof JCommandToggleButton) {
            JCommandToggleButton t = (JCommandToggleButton)o;
            if (!this.menuToToggleGroup.containsKey(path)) {
                throw new IllegalArgumentException("No toggle group for " + path);
            }
            this.menuToToggleGroup.get(path).setSelected(t, checked);
        } else if (o instanceof JToggleButton) {
            ((JToggleButton)o).setSelected(checked);
        } else {
            throw new IllegalArgumentException("Not a toggle menu");
        }
    }

    @Override
    public void setGroupSelection(String group, String selected) {
        if (!this.menuToggleGroups.containsKey(group)) {
            throw new IllegalArgumentException("Group " + group + " does not exist");
        }
        this.menuToggleGroups.get(group).clearSelection();
        if (selected == null) {
            return;
        }
        if (!this.menuItems.containsKey(selected)) {
            throw new IllegalArgumentException("Selection " + selected + " not found");
        }
        JCommandToggleButton c = (JCommandToggleButton)this.menuItems.get(selected);
        this.menuToggleGroups.get(group).setSelected(c, true);
    }

    @Override
    public String getGroupSelection(String group) {
        if (!this.menuToggleGroups.containsKey(group)) {
            throw new IllegalArgumentException("Group " + group + " does not exist");
        }
        JCommandToggleButton c = this.menuToggleGroups.get(group).getSelected();
        for (String path : this.menuItems.keySet()) {
            if (this.menuItems.get(path) != c) continue;
            return path;
        }
        return null;
    }

    @Override
    public void clearMenu(String path) {
    }

    @Override
    public void setMenuEnabled(String path, boolean enabled) {
        block8: {
            if (!this.menuItems.containsKey(path)) {
                throw new IllegalArgumentException("Menu not found: " + path);
            }
            Object o = this.menuItems.get(path);
            try {
                if (o instanceof JRibbonBand) {
                    ((JRibbonBand)o).setEnabled(enabled);
                    break block8;
                }
                if (o instanceof AbstractCommandButton) {
                    ((AbstractCommandButton)o).setEnabled(enabled);
                    break block8;
                }
                if (o instanceof RibbonApplicationMenuEntryPrimary) {
                    ((RibbonApplicationMenuEntryPrimary)o).setEnabled(enabled);
                    break block8;
                }
                if (o instanceof RibbonApplicationMenuEntryFooter) {
                    ((RibbonApplicationMenuEntryFooter)o).setEnabled(enabled);
                    break block8;
                }
                if (o instanceof JComponent) {
                    ((JComponent)o).setEnabled(enabled);
                    break block8;
                }
                throw new IllegalArgumentException("Cannot set enabled to: " + path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void initMenu() {
        this.menuSubs.put("", new ArrayList());
        this.menuPriorities.put("", 0);
        this.menuActions.put("", null);
        this.menuTitles.put("", null);
        this.menuIcons.put("", null);
        this.menuType.put("", 1);
    }

    @Override
    public void addSeparator(String parentPath) {
        if (!this.menuSubs.containsKey(parentPath)) {
            throw new IllegalArgumentException("Menu does not exist: " + parentPath);
        }
        this.menuSubs.get(parentPath).add("-");
    }

    @Override
    public boolean supportsMenuAction() {
        return true;
    }

    @Override
    public boolean supportsAppMenu() {
        return true;
    }

    @Override
    public void setPathVisible(String path, final boolean val) {
        RibbonContextualTaskGroup rg;
        Object o = this.menuItems.get(path);
        if (o instanceof RibbonTask && this.menuOptional.get(path).booleanValue() && this.ribbon.isVisible(rg = this.optionalGroups.get(path)) != val) {
            View.execInEventDispatch(new Runnable(){

                @Override
                public void run() {
                    try {
                        MainFrameRibbonMenu.this.ribbon.setVisible(rg, val);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    @Override
    public void hilightPath(final String path) {
        final Object o = this.menuItems.get(path);
        if (o instanceof RibbonTask) {
            if (this.menuOptional.get(path).booleanValue()) {
                View.execInEventDispatch(new Runnable(){

                    @Override
                    public void run() {
                        if (!MainFrameRibbonMenu.this.ribbon.isVisible((RibbonContextualTaskGroup)MainFrameRibbonMenu.this.optionalGroups.get(path))) {
                            MainFrameRibbonMenu.this.ribbon.setVisible((RibbonContextualTaskGroup)MainFrameRibbonMenu.this.optionalGroups.get(path), true);
                        }
                        MainFrameRibbonMenu.this.ribbon.setSelectedTask((RibbonTask)o);
                    }
                });
                return;
            }
            final RibbonTask rt = (RibbonTask)o;
            View.execInEventDispatch(new Runnable(){

                @Override
                public void run() {
                    MainFrameRibbonMenu.this.ribbon.setSelectedTask(rt);
                }
            });
        }
    }
}

