/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.ApplicationInfo;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.ListLayout;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class LoadingDialog
extends AppDialog {
    private final JLabel detailLabel;
    private CancellableWorker<?> worker;
    private final JProgressBar progressBar = new JProgressBar(0, 100);

    public void setWroker(CancellableWorker<?> worker) {
        this.worker = worker;
    }

    public void setDetail(String d) {
        this.detailLabel.setText(d);
        this.detailLabel.setHorizontalAlignment(0);
    }

    public void setPercent(int percent) {
        View.execInEventDispatch(() -> {
            if (percent == -1) {
                this.progressBar.setIndeterminate(true);
                this.progressBar.setStringPainted(false);
            } else {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setValue(percent);
                this.progressBar.setStringPainted(true);
            }
        });
    }

    public LoadingDialog(Window owner) {
        super(owner);
        this.setResizable(false);
        this.setTitle(ApplicationInfo.shortApplicationVerName);
        Container cntp = this.getContentPane();
        JPanel cnt = new JPanel();
        cntp.setLayout(new BorderLayout());
        cntp.add(cnt);
        cnt.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        cnt.setLayout(new BorderLayout());
        JPanel pan = new JPanel();
        pan.setLayout(new ListLayout(5));
        JLabel loadingLabel = new JLabel(this.translate("loadingpleasewait"));
        loadingLabel.setHorizontalAlignment(0);
        this.detailLabel = new JLabel("", 0);
        this.detailLabel.setPreferredSize(new Dimension(loadingLabel.getPreferredSize()));
        this.detailLabel.setHorizontalAlignment(0);
        pan.add(loadingLabel);
        pan.add(this.detailLabel);
        pan.add(this.progressBar);
        cnt.add((Component)pan, "Center");
        this.progressBar.setStringPainted(true);
        View.setWindowIcon(this);
        this.detailLabel.setHorizontalAlignment(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (Main.shouldCloseWhenClosingLoadingDialog) {
                    System.exit(0);
                } else if (LoadingDialog.this.worker != null) {
                    LoadingDialog.this.worker.cancel(true);
                }
            }
        });
        this.pack();
        Dimension siz = this.getSize();
        this.setSize(Math.max(300, 150 + this.getFontMetrics(new JLabel().getFont()).stringWidth(this.translate("loadingpleasewait"))), siz.height);
        View.centerScreen(this);
    }

    @Override
    public void dispose() {
        this.removeAll();
        for (WindowListener windowListener : this.getWindowListeners()) {
            this.removeWindowListener(windowListener);
        }
        Helper.emptyObject((Object)this);
        super.dispose();
    }
}

