/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFCompression;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.ComboBoxItem;
import com.jpexs.decompiler.flash.gui.TagEditorPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.helpers.TableLayoutHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import layout.TableLayout;

public class HeaderInfoPanel
extends JPanel
implements TagEditorPanel {
    private final JLabel signatureLabel = new JLabel();
    private final JLabel compressionLabel = new JLabel();
    private final JLabel gfxLabel = new JLabel();
    private final JLabel versionLabel = new JLabel();
    private final JLabel fileSizeLabel = new JLabel();
    private final JLabel frameRateLabel = new JLabel();
    private final JLabel frameCountLabel = new JLabel();
    private final JLabel displayRectTwipsLabel = new JLabel();
    private final JLabel displayRectPixelsLabel = new JLabel();
    private final JPanel compressionEditorPanel = new JPanel();
    private final JComboBox<ComboBoxItem<SWFCompression>> compressionComboBox = new JComboBox();
    private final JPanel versionEditorPanel = new JPanel();
    private final JSpinner versionEditor = new JSpinner();
    private final JCheckBox gfxCheckBox = new JCheckBox();
    private final JPanel frameRateEditorPanel = new JPanel();
    private final JSpinner frameRateEditor = new JSpinner();
    private final JPanel propertiesPanel = new JPanel();
    private final JPanel buttonsPanel = new JPanel();
    private final JButton editButton = new JButton(AppStrings.translate("button.edit"), View.getIcon("edit16"));
    private final JButton saveButton = new JButton(AppStrings.translate("button.save"), View.getIcon("save16"));
    private final JButton cancelButton = new JButton(AppStrings.translate("button.cancel"), View.getIcon("cancel16"));
    private final JPanel displayRectEditorPanel = new JPanel();
    private final JSpinner xMinEditor = new JSpinner();
    private final JSpinner xMaxEditor = new JSpinner();
    private final JSpinner yMinEditor = new JSpinner();
    private final JSpinner yMaxEditor = new JSpinner();
    private final JPanel warningPanel = new JPanel();
    private final JLabel warningLabel = new JLabel();
    private SWF swf;

    public HeaderInfoPanel() {
        this.setLayout(new BorderLayout());
        TableLayout tl = new TableLayout((double[][])new double[][]{{-2.0, -1.0}, {-2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0}});
        this.propertiesPanel.setLayout((LayoutManager)tl);
        FlowLayout layout = new FlowLayout(7);
        layout.setHgap(0);
        layout.setVgap(0);
        this.compressionEditorPanel.setLayout(layout);
        this.compressionComboBox.addItem(new ComboBoxItem<SWFCompression>(AppStrings.translate("header.uncompressed"), SWFCompression.NONE));
        this.compressionComboBox.addItem(new ComboBoxItem<SWFCompression>("Zlib", SWFCompression.ZLIB));
        this.compressionComboBox.addItem(new ComboBoxItem<SWFCompression>("LZMA", SWFCompression.LZMA));
        this.compressionComboBox.addActionListener(e -> this.validateHeader());
        this.compressionEditorPanel.add(this.compressionComboBox);
        this.versionEditorPanel.setLayout(layout);
        this.versionEditor.setPreferredSize(new Dimension(80, this.versionEditor.getPreferredSize().height));
        this.versionEditor.addChangeListener(e -> this.validateHeader());
        this.versionEditorPanel.add(this.versionEditor);
        this.gfxCheckBox.addActionListener(e -> this.validateHeader());
        this.frameRateEditorPanel.setLayout(layout);
        this.frameRateEditor.setPreferredSize(new Dimension(80, this.frameRateEditor.getPreferredSize().height));
        this.frameRateEditorPanel.add(this.frameRateEditor);
        this.displayRectEditorPanel.setLayout(layout);
        this.displayRectEditorPanel.setMinimumSize(new Dimension(10, this.displayRectEditorPanel.getMinimumSize().height));
        this.xMinEditor.setPreferredSize(new Dimension(80, this.xMinEditor.getPreferredSize().height));
        this.xMaxEditor.setPreferredSize(new Dimension(80, this.xMaxEditor.getPreferredSize().height));
        this.yMinEditor.setPreferredSize(new Dimension(80, this.yMinEditor.getPreferredSize().height));
        this.yMaxEditor.setPreferredSize(new Dimension(80, this.yMaxEditor.getPreferredSize().height));
        this.displayRectEditorPanel.add(this.xMinEditor);
        this.displayRectEditorPanel.add(new JLabel(","));
        this.displayRectEditorPanel.add(this.yMinEditor);
        this.displayRectEditorPanel.add(new JLabel(" => "));
        this.displayRectEditorPanel.add(this.xMaxEditor);
        this.displayRectEditorPanel.add(new JLabel(","));
        this.displayRectEditorPanel.add(this.yMaxEditor);
        this.displayRectEditorPanel.add(new JLabel(" twips"));
        this.warningLabel.setIcon(View.getIcon("warning16"));
        this.warningPanel.setLayout(layout);
        this.warningPanel.setBackground(new Color(255, 213, 29));
        this.warningPanel.add(this.warningLabel);
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.signature")), "0,0");
        this.propertiesPanel.add((Component)this.signatureLabel, "1,0");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.compression")), "0,1");
        this.propertiesPanel.add((Component)this.compressionLabel, "1,1");
        this.propertiesPanel.add((Component)this.compressionEditorPanel, "1,1");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.version")), "0,2");
        this.propertiesPanel.add((Component)this.versionLabel, "1,2");
        this.propertiesPanel.add((Component)this.versionEditorPanel, "1,2");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.gfx")), "0,3");
        this.propertiesPanel.add((Component)this.gfxLabel, "1,3");
        this.propertiesPanel.add((Component)this.gfxCheckBox, "1,3");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.filesize")), "0,4");
        this.propertiesPanel.add((Component)this.fileSizeLabel, "1,4");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.framerate")), "0,5");
        this.propertiesPanel.add((Component)this.frameRateLabel, "1,5");
        this.propertiesPanel.add((Component)this.frameRateEditorPanel, "1,5");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.framecount")), "0,6");
        this.propertiesPanel.add((Component)this.frameCountLabel, "1,6");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.displayrect")), "0,7");
        this.propertiesPanel.add((Component)this.displayRectTwipsLabel, "1,7");
        this.propertiesPanel.add((Component)this.displayRectEditorPanel, "1,7");
        this.propertiesPanel.add((Component)new JLabel(""), "0,8");
        this.propertiesPanel.add((Component)this.displayRectPixelsLabel, "1,8");
        this.propertiesPanel.add((Component)this.warningPanel, "0,9,1,9");
        this.add((Component)this.propertiesPanel, "Center");
        this.editButton.setVisible(false);
        this.editButton.addActionListener(this::editButtonActionPerformed);
        this.saveButton.setVisible(false);
        this.saveButton.addActionListener(this::saveButtonActionPerformed);
        this.cancelButton.setVisible(false);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        this.buttonsPanel.setLayout(new FlowLayout());
        this.buttonsPanel.setBorder(new BevelBorder(0));
        this.buttonsPanel.add(this.editButton);
        this.buttonsPanel.add(this.saveButton);
        this.buttonsPanel.add(this.cancelButton);
        this.add((Component)this.buttonsPanel, "South");
        TableLayoutHelper.addTableSpaces(tl, 10.0);
        this.setEditMode(false);
    }

    private int getVersionNumber() {
        return (Integer)this.versionEditor.getModel().getValue();
    }

    private SWFCompression getCompression() {
        ComboBoxItem item = (ComboBoxItem)this.compressionComboBox.getSelectedItem();
        return (SWFCompression)item.getValue();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.setEditMode(true);
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.swf.compression = this.getCompression();
        this.swf.version = this.getVersionNumber();
        this.swf.gfx = this.gfxCheckBox.isSelected();
        this.swf.frameRate = ((Number)this.frameRateEditor.getModel().getValue()).floatValue();
        this.swf.displayRect.Xmin = (Integer)this.xMinEditor.getModel().getValue();
        this.swf.displayRect.Xmax = (Integer)this.xMaxEditor.getModel().getValue();
        this.swf.displayRect.Ymin = (Integer)this.yMinEditor.getModel().getValue();
        this.swf.displayRect.Ymax = (Integer)this.yMaxEditor.getModel().getValue();
        this.load(this.swf);
        this.setEditMode(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.load(this.swf);
        this.setEditMode(false);
    }

    public void load(SWF swf) {
        this.swf = swf;
        this.signatureLabel.setText(new String(swf.getHeaderBytes()));
        switch (swf.compression) {
            case LZMA: {
                this.compressionLabel.setText(AppStrings.translate("header.compression.lzma"));
                this.compressionComboBox.setSelectedIndex(2);
                break;
            }
            case ZLIB: {
                this.compressionLabel.setText(AppStrings.translate("header.compression.zlib"));
                this.compressionComboBox.setSelectedIndex(1);
                break;
            }
            case NONE: {
                this.compressionLabel.setText(AppStrings.translate("header.compression.none"));
                this.compressionComboBox.setSelectedIndex(0);
            }
        }
        this.versionLabel.setText(Integer.toString(swf.version));
        this.versionEditor.setModel(new SpinnerNumberModel(swf.version, 1, 64, 1));
        this.gfxLabel.setText(swf.gfx ? AppStrings.translate("yes") : AppStrings.translate("no"));
        this.gfxCheckBox.setSelected(swf.gfx);
        this.fileSizeLabel.setText(Long.toString(swf.fileSize));
        this.frameRateLabel.setText(Float.toString(swf.frameRate));
        this.frameRateEditor.setModel(new SpinnerNumberModel(swf.frameRate, -2.147483648E9, 2.147483647E9, 1.0));
        this.frameCountLabel.setText("" + swf.frameCount);
        this.displayRectTwipsLabel.setText(AppStrings.translate("header.displayrect.value.twips").replace("%xmin%", Integer.toString(swf.displayRect.Xmin)).replace("%ymin%", Integer.toString(swf.displayRect.Ymin)).replace("%xmax%", Integer.toString(swf.displayRect.Xmax)).replace("%ymax%", Integer.toString(swf.displayRect.Ymax)));
        this.displayRectPixelsLabel.setText(AppStrings.translate("header.displayrect.value.pixels").replace("%xmin%", this.fmtDouble((double)swf.displayRect.Xmin / 20.0)).replace("%ymin%", this.fmtDouble((double)swf.displayRect.Ymin / 20.0)).replace("%xmax%", this.fmtDouble((double)swf.displayRect.Xmax / 20.0)).replace("%ymax%", this.fmtDouble((double)swf.displayRect.Ymax / 20.0)));
        this.xMinEditor.setModel(new SpinnerNumberModel(swf.displayRect.Xmin, Integer.MIN_VALUE, Integer.MAX_VALUE, 1));
        this.xMaxEditor.setModel(new SpinnerNumberModel(swf.displayRect.Xmax, Integer.MIN_VALUE, Integer.MAX_VALUE, 1));
        this.yMinEditor.setModel(new SpinnerNumberModel(swf.displayRect.Ymin, Integer.MIN_VALUE, Integer.MAX_VALUE, 1));
        this.yMaxEditor.setModel(new SpinnerNumberModel(swf.displayRect.Ymax, Integer.MIN_VALUE, Integer.MAX_VALUE, 1));
        this.setEditMode(false);
    }

    public void clear() {
        this.swf = null;
    }

    private String fmtDouble(double d) {
        String r = Double.toString(d);
        if (r.endsWith(".0")) {
            r = r.substring(0, r.length() - 2);
        }
        return r;
    }

    private void setEditMode(boolean edit) {
        this.compressionLabel.setVisible(!edit);
        this.compressionEditorPanel.setVisible(edit);
        this.versionLabel.setVisible(!edit);
        this.versionEditorPanel.setVisible(edit);
        this.gfxLabel.setVisible(!edit);
        this.gfxCheckBox.setVisible(edit);
        this.frameRateLabel.setVisible(!edit);
        this.frameRateEditorPanel.setVisible(edit);
        this.displayRectTwipsLabel.setVisible(!edit);
        this.displayRectPixelsLabel.setVisible(!edit);
        this.displayRectEditorPanel.setVisible(edit);
        this.warningPanel.setVisible(false);
        this.editButton.setVisible(!edit);
        this.saveButton.setVisible(edit);
        this.cancelButton.setVisible(edit);
    }

    private boolean validateHeader() {
        int version = this.getVersionNumber();
        boolean gfx = this.gfxCheckBox.isSelected();
        SWFCompression compression = this.getCompression();
        String resultStr = "";
        boolean result = true;
        if (gfx && compression != SWFCompression.NONE && compression != SWFCompression.ZLIB) {
            resultStr = resultStr + AppStrings.translate("header.warning.unsupportedGfxCompression") + " ";
            result = false;
        }
        if (compression == SWFCompression.ZLIB && version < 6) {
            resultStr = resultStr + AppStrings.translate("header.warning.minimumZlibVersion") + " ";
            result = false;
        }
        if (compression == SWFCompression.LZMA && version < 13) {
            resultStr = resultStr + AppStrings.translate("header.warning.minimumLzmaVersion") + " ";
            result = false;
        }
        this.warningPanel.setVisible(!result);
        if (!result) {
            this.warningLabel.setText(resultStr);
        }
        return result;
    }

    @Override
    public boolean tryAutoSave() {
        return false;
    }

    @Override
    public boolean isEditing() {
        return this.saveButton.isVisible();
    }
}

