/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public class FontPreviewDialog
extends AppDialog {
    private JComboBox comboBoxSampleTexts;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JLabel labelFontName;
    private JLabel labelSample12;
    private JLabel labelSample18;
    private JLabel labelSample24;
    private JLabel labelSample36;
    private JLabel labelSample48;
    private JLabel labelSample60;
    private JLabel labelSample72;

    public FontPreviewDialog(Frame parent, boolean modal, Font font) {
        super((Window)parent);
        this.setModal(true);
        this.initComponents();
        View.setWindowIcon(this);
        this.labelSample12.setFont(font.deriveFont(12.0f));
        this.labelSample18.setFont(font.deriveFont(18.0f));
        this.labelSample24.setFont(font.deriveFont(24.0f));
        this.labelSample36.setFont(font.deriveFont(36.0f));
        this.labelSample48.setFont(font.deriveFont(48.0f));
        this.labelSample60.setFont(font.deriveFont(60.0f));
        this.labelSample72.setFont(font.deriveFont(72.0f));
        this.comboBoxSampleTexts.setSelectedIndex((Integer)Configuration.guiFontPreviewSampleText.get((Object)0));
        if (Configuration.guiFontPreviewWidth.hasValue()) {
            int width = (Integer)Configuration.guiFontPreviewWidth.get();
            int height = (Integer)Configuration.guiFontPreviewHeight.get();
            this.setSize(width, height);
        }
        if (Configuration.guiFontPreviewPosX.hasValue()) {
            int posX = (Integer)Configuration.guiFontPreviewPosX.get();
            int posY = (Integer)Configuration.guiFontPreviewPosY.get();
            this.setLocation(posX, posY);
        }
        this.setText((String)this.comboBoxSampleTexts.getSelectedItem());
        this.labelFontName.setText(font.getFontName());
    }

    private void setText(String text) {
        this.labelSample12.setText(text);
        this.labelSample18.setText(text);
        this.labelSample24.setText(text);
        this.labelSample36.setText(text);
        this.labelSample48.setText(text);
        this.labelSample60.setText(text);
        this.labelSample72.setText(text);
    }

    private ComboBoxModel<String> getModel() {
        ArrayList<String> sampleTexts = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(FontPreviewDialog.class.getResourceAsStream("/com/jpexs/decompiler/flash/tags/font/font_preview_samples.txt"), Utf8Helper.charset));
        try {
            String s;
            while ((s = br.readLine()) != null) {
                sampleTexts.add(s);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(FontPreviewDialog.class.getName()).log(Level.SEVERE, "Cannot read font preview dialog sample texts", ex);
        }
        return new DefaultComboBoxModel<String>(sampleTexts.toArray(new String[sampleTexts.size()]));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.labelSample72 = new JLabel();
        this.labelSample60 = new JLabel();
        this.labelSample12 = new JLabel();
        this.labelSample24 = new JLabel();
        this.labelSample48 = new JLabel();
        this.labelSample36 = new JLabel();
        this.labelSample18 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.comboBoxSampleTexts = new JComboBox();
        this.jLabel1 = new JLabel();
        this.labelFontName = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("com/jpexs/decompiler/flash/gui/locales/FontPreviewDialog");
        this.setTitle(bundle.getString("fontPreview.dialog.title"));
        this.setPreferredSize(new Dimension(1024, 512));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                FontPreviewDialog.this.formComponentMoved(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                FontPreviewDialog.this.formComponentResized(evt);
            }
        });
        this.labelSample72.setFont(new Font("Tahoma", 0, 72));
        this.labelSample72.setText("---");
        this.labelSample60.setFont(new Font("Tahoma", 0, 60));
        this.labelSample60.setText("---");
        this.labelSample12.setFont(new Font("Tahoma", 0, 12));
        this.labelSample12.setText("---");
        this.labelSample24.setFont(new Font("Tahoma", 0, 24));
        this.labelSample24.setText("---");
        this.labelSample48.setFont(new Font("Tahoma", 0, 48));
        this.labelSample48.setText("---");
        this.labelSample36.setFont(new Font("Tahoma", 0, 36));
        this.labelSample36.setText("---");
        this.labelSample18.setFont(new Font("Tahoma", 0, 18));
        this.labelSample18.setText("---");
        this.jLabel2.setText("12");
        this.jLabel3.setText("18");
        this.jLabel4.setText("24");
        this.jLabel5.setText("36");
        this.jLabel6.setText("48");
        this.jLabel7.setText("60");
        this.jLabel8.setText("72");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelSample72).addComponent(this.labelSample18).addComponent(this.labelSample12).addComponent(this.labelSample24).addComponent(this.labelSample36).addComponent(this.labelSample48).addComponent(this.labelSample60)).addContainerGap(692, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSample12).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSample18).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSample24).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSample36).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSample48).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSample60).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSample72).addComponent(this.jLabel8)).addContainerGap()));
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.comboBoxSampleTexts.setModel(this.getModel());
        this.comboBoxSampleTexts.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FontPreviewDialog.this.comboBoxSampleTextsItemStateChanged(evt);
            }
        });
        ResourceBundle bundle1 = ResourceBundle.getBundle("com/jpexs/decompiler/flash/gui/locales/MainFrame");
        this.jLabel1.setText(bundle1.getString("font.name"));
        this.labelFontName.setText("-");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboBoxSampleTexts, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelFontName).addGap(519, 519, 519))).addContainerGap()).addComponent(this.jScrollPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.comboBoxSampleTexts, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.labelFontName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 431, Short.MAX_VALUE)));
        this.pack();
    }

    private void comboBoxSampleTextsItemStateChanged(ItemEvent evt) {
        Configuration.guiFontPreviewSampleText.set((Object)this.comboBoxSampleTexts.getSelectedIndex());
        this.setText((String)this.comboBoxSampleTexts.getSelectedItem());
    }

    private void formComponentResized(ComponentEvent evt) {
        Configuration.guiFontPreviewWidth.set((Object)this.getWidth());
        Configuration.guiFontPreviewHeight.set((Object)this.getHeight());
    }

    private void formComponentMoved(ComponentEvent evt) {
        Configuration.guiFontPreviewPosX.set((Object)this.getX());
        Configuration.guiFontPreviewPosY.set((Object)this.getY());
    }
}

