/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.BinaryDataExportMode;
import com.jpexs.decompiler.flash.exporters.modes.ButtonExportMode;
import com.jpexs.decompiler.flash.exporters.modes.FontExportMode;
import com.jpexs.decompiler.flash.exporters.modes.FrameExportMode;
import com.jpexs.decompiler.flash.exporters.modes.ImageExportMode;
import com.jpexs.decompiler.flash.exporters.modes.MorphShapeExportMode;
import com.jpexs.decompiler.flash.exporters.modes.MovieExportMode;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.exporters.modes.ShapeExportMode;
import com.jpexs.decompiler.flash.exporters.modes.SoundExportMode;
import com.jpexs.decompiler.flash.exporters.modes.SpriteExportMode;
import com.jpexs.decompiler.flash.exporters.modes.SymbolClassExportMode;
import com.jpexs.decompiler.flash.exporters.modes.TextExportMode;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DefineVideoStreamTag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.tags.base.SymbolClassTypeTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.TagScript;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExportDialog
extends AppDialog {
    private int result = -1;
    String[] optionNames = new String[]{"shapes", "texts", "images", "movies", "sounds", "scripts", "binaryData", "frames", "sprites", "buttons", "fonts", "morphshapes", "symbolclass"};
    Class[][] objClasses = new Class[][]{{ShapeTag.class}, {TextTag.class}, {ImageTag.class}, {DefineVideoStreamTag.class}, {SoundTag.class}, {ASMSource.class, ScriptPack.class, TagScript.class}, {DefineBinaryDataTag.class}, {Frame.class}, {Frame.class}, {ButtonTag.class}, {FontTag.class}, {MorphShapeTag.class}, {SymbolClassTypeTag.class}};
    Class[] optionClasses = new Class[]{ShapeExportMode.class, TextExportMode.class, ImageExportMode.class, MovieExportMode.class, SoundExportMode.class, ScriptExportMode.class, BinaryDataExportMode.class, FrameExportMode.class, SpriteExportMode.class, ButtonExportMode.class, FontExportMode.class, MorphShapeExportMode.class, SymbolClassExportMode.class};
    Class[] zoomClasses = new Class[]{ShapeExportMode.class, MorphShapeExportMode.class, TextExportMode.class, FrameExportMode.class, SpriteExportMode.class, ButtonExportMode.class};
    private final JComboBox[] combos;
    private final JCheckBox[] checkBoxes;
    private final JCheckBox selectAllCheckBox;
    private JTextField zoomTextField = new JTextField();

    public <E> E getValue(Class<E> option) {
        for (int i = 0; i < this.optionClasses.length; ++i) {
            if (option != this.optionClasses[i]) continue;
            E[] values = option.getEnumConstants();
            return values[this.combos[i].getSelectedIndex()];
        }
        return null;
    }

    public boolean isOptionEnabled(Class<?> option) {
        for (int i = 0; i < this.optionClasses.length; ++i) {
            if (option != this.optionClasses[i]) continue;
            return this.checkBoxes[i].isSelected();
        }
        return false;
    }

    public double getZoom() {
        return Double.parseDouble(this.zoomTextField.getText()) / 100.0;
    }

    private void saveConfig() {
        StringBuilder cfg = new StringBuilder();
        for (int i = 0; i < this.optionNames.length; ++i) {
            int selIndex = this.combos[i].getSelectedIndex();
            Class c = this.optionClasses[i];
            T[] vals = c.getEnumConstants();
            String key = this.optionNames[i] + "." + vals[selIndex].toString().toLowerCase(Locale.ENGLISH);
            if (i > 0) {
                cfg.append(",");
            }
            cfg.append(key);
        }
        Configuration.lastSelectedExportZoom.set((Object)(Double.parseDouble(this.zoomTextField.getText()) / 100.0));
        Configuration.lastSelectedExportFormats.set((Object)cfg.toString());
    }

    private boolean optionCanHandle(int optionIndex, Object e) {
        for (int i = 0; i < this.objClasses[optionIndex].length; ++i) {
            Class c = this.objClasses[optionIndex][i];
            if (!c.isInstance(e)) continue;
            if (c == Frame.class) {
                boolean spritesWanted;
                Frame f = (Frame)e;
                boolean isSprite = f.timeline.timelined instanceof DefineSpriteTag;
                boolean bl = spritesWanted = this.optionClasses[optionIndex] == SpriteExportMode.class;
                if (spritesWanted != isSprite) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public ExportDialog(Window owner, List<TreeItem> exportables) {
        super(owner);
        this.setTitle(this.translate("dialog.title"));
        this.setResizable(false);
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        JPanel comboPanel = new JPanel(null);
        int labWidth = 0;
        boolean[] exportableExistsArray = new boolean[this.optionNames.length];
        for (int i = 0; i < this.optionNames.length; ++i) {
            boolean exportableExists = false;
            if (exportables == null) {
                exportableExists = true;
            } else {
                for (TreeItem e2 : exportables) {
                    if (!this.optionCanHandle(i, e2)) continue;
                    exportableExists = true;
                }
            }
            if (!exportableExists) continue;
            exportableExistsArray[i] = true;
            JLabel label = new JLabel(this.translate(this.optionNames[i]));
            if (label.getPreferredSize().width <= labWidth) continue;
            labWidth = label.getPreferredSize().width;
        }
        String exportFormatsStr = (String)Configuration.lastSelectedExportFormats.get();
        if ("".equals(exportFormatsStr)) {
            exportFormatsStr = null;
        }
        String[] exportFormatsArr = new String[]{};
        if (exportFormatsStr != null) {
            exportFormatsArr = exportFormatsStr.contains(",") ? exportFormatsStr.split(",") : new String[]{exportFormatsStr};
        }
        int comboWidth = 200;
        int top = 10;
        List<String> exportFormats = Arrays.asList(exportFormatsArr);
        this.combos = new JComboBox[this.optionNames.length];
        this.checkBoxes = new JCheckBox[this.optionNames.length];
        this.selectAllCheckBox = new JCheckBox();
        int checkBoxWidth = this.selectAllCheckBox.getPreferredSize().width;
        this.selectAllCheckBox.setBounds(10 + labWidth + 10 + comboWidth + 10, top, checkBoxWidth, this.selectAllCheckBox.getPreferredSize().height);
        this.selectAllCheckBox.setSelected(true);
        this.selectAllCheckBox.addActionListener(e -> {
            boolean selected = this.selectAllCheckBox.isSelected();
            for (JCheckBox checkBox : this.checkBoxes) {
                if (checkBox == null) continue;
                checkBox.setSelected(selected);
            }
        });
        comboPanel.add(this.selectAllCheckBox);
        top += this.selectAllCheckBox.getHeight();
        boolean zoomable = false;
        for (int i = 0; i < this.optionNames.length; ++i) {
            Class c = this.optionClasses[i];
            T[] vals = c.getEnumConstants();
            String[] names = new String[vals.length];
            int itemIndex = -1;
            for (int j = 0; j < vals.length; ++j) {
                String key = this.optionNames[i] + "." + vals[j].toString().toLowerCase(Locale.ENGLISH);
                if (exportFormats.contains(key)) {
                    itemIndex = j;
                }
                names[j] = this.translate(key);
            }
            this.combos[i] = new JComboBox<String>(names);
            if (itemIndex > -1) {
                this.combos[i].setSelectedIndex(itemIndex);
            }
            this.combos[i].setBounds(10 + labWidth + 10, top, comboWidth, this.combos[i].getPreferredSize().height);
            this.checkBoxes[i] = new JCheckBox();
            this.checkBoxes[i].setBounds(10 + labWidth + 10 + comboWidth + 10, top, checkBoxWidth, this.checkBoxes[i].getPreferredSize().height);
            this.checkBoxes[i].setSelected(true);
            if (!exportableExistsArray[i]) continue;
            if (Arrays.asList(this.zoomClasses).contains(c)) {
                zoomable = true;
            }
            JLabel lab = new JLabel(this.translate(this.optionNames[i]));
            lab.setBounds(10, top, lab.getPreferredSize().width, lab.getPreferredSize().height);
            comboPanel.add(lab);
            comboPanel.add(this.checkBoxes[i]);
            comboPanel.add(this.combos[i]);
            top += this.combos[i].getHeight();
        }
        int zoomWidth = 50;
        if (zoomable) {
            JLabel zlab = new JLabel(this.translate("zoom"));
            zlab.setBounds(10, (top += 2) + 4, zlab.getPreferredSize().width, zlab.getPreferredSize().height);
            this.zoomTextField.setBounds(10 + labWidth + 10, top, zoomWidth, this.zoomTextField.getPreferredSize().height);
            JLabel pctLabel = new JLabel(this.translate("zoom.percent"));
            pctLabel.setBounds(10 + labWidth + 10 + zoomWidth + 5, top + 4, 20, pctLabel.getPreferredSize().height);
            comboPanel.add(zlab);
            comboPanel.add(this.zoomTextField);
            comboPanel.add(pctLabel);
            top += this.zoomTextField.getHeight();
        }
        Dimension dim = new Dimension(10 + labWidth + 10 + checkBoxWidth + 10 + comboWidth + 10, top + 10);
        comboPanel.setMinimumSize(dim);
        comboPanel.setPreferredSize(dim);
        cnt.add((Component)comboPanel, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        JButton okButton = new JButton(this.translate("button.ok"));
        okButton.addActionListener(this::okButtonActionPerformed);
        JButton cancelButton = new JButton(this.translate("button.cancel"));
        cancelButton.addActionListener(this::cancelButtonActionPerformed);
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        cnt.add((Component)buttonsPanel, "South");
        this.pack();
        View.centerScreen(this);
        View.setWindowIcon(this);
        this.getRootPane().setDefaultButton(okButton);
        this.setModal(true);
        String pct = "" + (Double)Configuration.lastSelectedExportZoom.get() * 100.0;
        if (pct.endsWith(".0")) {
            pct = pct.substring(0, pct.length() - 2);
        }
        this.zoomTextField.setText(pct);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.result = -1;
        }
        super.setVisible(b);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.result = 0;
        try {
            this.saveConfig();
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, this.translate("zoom.invalid"), AppStrings.translate("error"), 0);
            this.zoomTextField.requestFocusInWindow();
            return;
        }
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = 1;
        this.setVisible(false);
    }

    public int showExportDialog() {
        this.setVisible(true);
        return this.result;
    }
}

