/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.debugger.DebugListener;
import com.jpexs.decompiler.flash.gui.debugger.Debugger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class DebugLogDialog
extends AppDialog {
    private final JTextArea logTextArea = new JTextArea();
    private final Debugger debug;

    public DebugLogDialog(Window owner, Debugger debug) {
        super(owner);
        this.setSize(800, 600);
        this.debug = debug;
        this.setTitle(this.translate("dialog.title"));
        if (View.isOceanic()) {
            this.logTextArea.setBackground(Color.white);
        }
        this.logTextArea.setEditable(false);
        FasterScrollPane spane = new FasterScrollPane(this.logTextArea);
        spane.setPreferredSize(new Dimension(800, 500));
        debug.addMessageListener(new DebugListener(){

            @Override
            public void onMessage(String clientId, String msg) {
                DebugLogDialog.this.log(DebugLogDialog.this.translate("msg.header").replace("%clientid%", clientId) + msg);
            }

            @Override
            public void onFinish(String clientId) {
            }

            @Override
            public void onLoaderURL(String clientId, String url) {
                DebugLogDialog.this.log(DebugLogDialog.this.translate("msg.header").replace("%clientid%", clientId) + " LOADURL:" + url);
            }

            @Override
            public void onLoaderBytes(String clientId, byte[] data) {
                DebugLogDialog.this.log(DebugLogDialog.this.translate("msg.header").replace("%clientid%", clientId) + " LOADBYTES: " + data.length + "B");
            }
        });
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        cnt.add((Component)spane, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        JButton clearButton = new JButton(this.translate("button.clear"));
        clearButton.addActionListener(this::clearButtonActionPerformed);
        JButton closeButton = new JButton(this.translate("button.close"));
        closeButton.addActionListener(this::closeButtonActionPerformed);
        buttonsPanel.add(clearButton);
        buttonsPanel.add(closeButton);
        cnt.add((Component)buttonsPanel, "South");
        View.setWindowIcon(this);
        View.centerScreen(this);
    }

    public void log(String msg) {
        Document d = this.logTextArea.getDocument();
        try {
            d.insertString(d.getLength(), msg + "\r\n", null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.logTextArea.setText("");
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

