/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.helpers.Helper;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChangelogUpdater {
    private static final String GITHUB_ADDRESS = "https://github.com/jindrapetrik/jpexs-decompiler/";
    private static final String ISSUE_TRACKER_ADDRESS = "https://www.free-decompiler.com/flash/issues/";

    public static void main(String[] args) throws UnsupportedEncodingException {
        String changeLog = Helper.readTextFile((String[])new String[]{"CHANGELOG.md"});
        changeLog = changeLog.replaceAll("\\[[^\\]]+\\]: [^\\r\\n]+\\r\\n", "");
        changeLog = changeLog.replaceAll("\\[#([0-9]+)\\]", "#$1");
        changeLog = changeLog.replaceAll("#([0-9]+)", "[#$1]");
        Pattern issuePattern = Pattern.compile("\\[#([0-9]+)\\]");
        Matcher issueMatcher = issuePattern.matcher(changeLog);
        LinkedHashSet<Integer> issues = new LinkedHashSet<Integer>();
        while (issueMatcher.find()) {
            issues.add(Integer.parseInt(issueMatcher.group(1)));
        }
        Pattern headerPattern = Pattern.compile("## \\[([^\\]]+)\\]");
        Matcher headerMatcher = headerPattern.matcher(changeLog);
        ArrayList<String> versionNames = new ArrayList<String>();
        ArrayList<String> tagNames = new ArrayList<String>();
        while (headerMatcher.find()) {
            String versionName = headerMatcher.group(1);
            Pattern updatePattern = Pattern.compile("([0-9]+\\.[0-9]+\\.[0-9]+) update ([0-9]+)");
            Matcher updateMatcher = updatePattern.matcher(versionName);
            String tagName = versionName.matches("[0-9]+\\.[0-9]+\\.[0-9]+") ? "version" + versionName : (updateMatcher.matches() ? "version" + updateMatcher.group(1) + "u" + updateMatcher.group(2) : (versionName.equals("Unreleased") ? "dev" : versionName.replace(" ", "")));
            versionNames.add(versionName);
            tagNames.add(tagName);
        }
        for (int i = 0; i < versionNames.size(); ++i) {
            String versionName = (String)versionNames.get(i);
            String tagName = (String)tagNames.get(i);
            String nextTagName = i == versionNames.size() - 1 ? null : (String)tagNames.get(i + 1);
            changeLog = nextTagName == null ? changeLog + "[" + versionName + "]: " + GITHUB_ADDRESS + "releases/tag/" + tagName + "\r\n" : changeLog + "[" + versionName + "]: " + GITHUB_ADDRESS + "compare/" + nextTagName + "..." + tagName + "\r\n";
        }
        Iterator iterator = issues.iterator();
        while (iterator.hasNext()) {
            int issue = (Integer)iterator.next();
            changeLog = changeLog + "[#" + issue + "]: " + ISSUE_TRACKER_ADDRESS + issue + "\r\n";
        }
        Helper.writeFile((String)"CHANGELOG.md", (byte[][])new byte[][]{changeLog.getBytes("UTF-8")});
    }
}

