/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.FilenameMangler;
import HTTPClient.HttpHeaderElement;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Util;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class Codecs {
    private static BitSet BoundChar;
    private static BitSet EBCDICUnsafeChar;
    private static byte[] Base64EncMap;
    private static byte[] Base64DecMap;
    private static char[] UUEncMap;
    private static byte[] UUDecMap;
    private static final String ContDisp = "\r\nContent-Disposition: form-data; name=\"";
    private static final String FileName = "\"; filename=\"";
    private static final String Boundary = "\r\n-----ieoau._._-2_8_GoodLuck8.3-dskdfJwSJKlrWLr0234324jfLdsjfdAuaoei-----";
    private static NVPair[] dummy;

    private Codecs() {
    }

    public static final String base64Encode(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes();
        return new String(Codecs.base64Encode(byArray));
    }

    public static final byte[] base64Encode(byte[] byArray) {
        int n;
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[(byArray.length + 2) / 3 * 4];
        int n2 = 0;
        for (n = 0; n < byArray.length - 2; n += 3) {
            byArray2[n2++] = Base64EncMap[byArray[n] >>> 2 & 0x3F];
            byArray2[n2++] = Base64EncMap[byArray[n + 1] >>> 4 & 0xF | byArray[n] << 4 & 0x3F];
            byArray2[n2++] = Base64EncMap[byArray[n + 2] >>> 6 & 3 | byArray[n + 1] << 2 & 0x3F];
            byArray2[n2++] = Base64EncMap[byArray[n + 2] & 0x3F];
        }
        if (n < byArray.length) {
            byArray2[n2++] = Base64EncMap[byArray[n] >>> 2 & 0x3F];
            if (n < byArray.length - 1) {
                byArray2[n2++] = Base64EncMap[byArray[n + 1] >>> 4 & 0xF | byArray[n] << 4 & 0x3F];
                byArray2[n2++] = Base64EncMap[byArray[n + 1] << 2 & 0x3F];
            } else {
                byArray2[n2++] = Base64EncMap[byArray[n] << 4 & 0x3F];
            }
        }
        while (n2 < byArray2.length) {
            byArray2[n2] = 61;
            ++n2;
        }
        return byArray2;
    }

    public static final String base64Decode(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes();
        return new String(Codecs.base64Decode(byArray));
    }

    public static final byte[] base64Decode(byte[] byArray) {
        int n;
        int n2;
        if (byArray == null) {
            return null;
        }
        int n3 = byArray.length;
        while (byArray[n3 - 1] == 61) {
            --n3;
        }
        byte[] byArray2 = new byte[n3 - byArray.length / 4];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            byArray[n2] = Base64DecMap[byArray[n2]];
        }
        n2 = 0;
        for (n = 0; n < byArray2.length - 2; n += 3) {
            byArray2[n] = (byte)(byArray[n2] << 2 & 0xFF | byArray[n2 + 1] >>> 4 & 3);
            byArray2[n + 1] = (byte)(byArray[n2 + 1] << 4 & 0xFF | byArray[n2 + 2] >>> 2 & 0xF);
            byArray2[n + 2] = (byte)(byArray[n2 + 2] << 6 & 0xFF | byArray[n2 + 3] & 0x3F);
            n2 += 4;
        }
        if (n < byArray2.length) {
            byArray2[n] = (byte)(byArray[n2] << 2 & 0xFF | byArray[n2 + 1] >>> 4 & 3);
        }
        if (++n < byArray2.length) {
            byArray2[n] = (byte)(byArray[n2 + 1] << 4 & 0xFF | byArray[n2 + 2] >>> 2 & 0xF);
        }
        return byArray2;
    }

    public static final char[] uuencode(byte[] byArray) {
        int n;
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return new char[0];
        }
        int n2 = 45;
        char[] cArray = System.getProperty("line.separator", "\n").toCharArray();
        char[] cArray2 = new char[(byArray.length + 2) / 3 * 4 + (byArray.length + n2 - 1) / n2 * (cArray.length + 1)];
        int n3 = 0;
        int n4 = 0;
        while (n3 + n2 < byArray.length) {
            cArray2[n4++] = UUEncMap[n2];
            n = n3 + n2;
            while (n3 < n) {
                cArray2[n4++] = UUEncMap[byArray[n3] >>> 2 & 0x3F];
                cArray2[n4++] = UUEncMap[byArray[n3 + 1] >>> 4 & 0xF | byArray[n3] << 4 & 0x3F];
                cArray2[n4++] = UUEncMap[byArray[n3 + 2] >>> 6 & 3 | byArray[n3 + 1] << 2 & 0x3F];
                cArray2[n4++] = UUEncMap[byArray[n3 + 2] & 0x3F];
                n3 += 3;
            }
            for (n = 0; n < cArray.length; ++n) {
                cArray2[n4++] = cArray[n];
            }
        }
        cArray2[n4++] = UUEncMap[byArray.length - n3];
        while (n3 + 2 < byArray.length) {
            cArray2[n4++] = UUEncMap[byArray[n3] >>> 2 & 0x3F];
            cArray2[n4++] = UUEncMap[byArray[n3 + 1] >>> 4 & 0xF | byArray[n3] << 4 & 0x3F];
            cArray2[n4++] = UUEncMap[byArray[n3 + 2] >>> 6 & 3 | byArray[n3 + 1] << 2 & 0x3F];
            cArray2[n4++] = UUEncMap[byArray[n3 + 2] & 0x3F];
            n3 += 3;
        }
        if (n3 < byArray.length - 1) {
            cArray2[n4++] = UUEncMap[byArray[n3] >>> 2 & 0x3F];
            cArray2[n4++] = UUEncMap[byArray[n3 + 1] >>> 4 & 0xF | byArray[n3] << 4 & 0x3F];
            cArray2[n4++] = UUEncMap[byArray[n3 + 1] << 2 & 0x3F];
            cArray2[n4++] = UUEncMap[0];
        } else if (n3 < byArray.length) {
            cArray2[n4++] = UUEncMap[byArray[n3] >>> 2 & 0x3F];
            cArray2[n4++] = UUEncMap[byArray[n3] << 4 & 0x3F];
            cArray2[n4++] = UUEncMap[0];
            cArray2[n4++] = UUEncMap[0];
        }
        for (n = 0; n < cArray.length; ++n) {
            cArray2[n4++] = cArray[n];
        }
        if (n4 != cArray2.length) {
            throw new Error("Calculated " + cArray2.length + " chars but wrote " + n4 + " chars!");
        }
        return cArray2;
    }

    private static final byte[] uudecode(BufferedReader bufferedReader) throws ParseException, IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null && !string.startsWith("begin ")) {
        }
        if (string == null) {
            throw new ParseException("'begin' line not found");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        try {
            int n = Integer.parseInt(stringTokenizer.nextToken(), 8);
        }
        catch (Exception exception) {
            throw new ParseException("Invalid mode on line: " + string);
        }
        try {
            String string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new ParseException("No file name found on line: " + string);
        }
        byte[] byArray = new byte[1000];
        int n = 0;
        while ((string = bufferedReader.readLine()) != null && !string.equals("end")) {
            byte[] byArray2 = Codecs.uudecode(string.toCharArray());
            if (n + byArray2.length > byArray.length) {
                byArray = Util.resizeArray(byArray, n + 1000);
            }
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            n += byArray2.length;
        }
        if (string == null) {
            throw new ParseException("'end' line not found");
        }
        return Util.resizeArray(byArray, n);
    }

    public static final byte[] uudecode(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        byte[] byArray = new byte[cArray.length / 4 * 3];
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            byte by;
            byte by2;
            byte by3 = UUDecMap[cArray[n++]];
            int n3 = n2 + by3;
            while (n2 < n3 - 2) {
                by2 = UUDecMap[cArray[n]];
                by = UUDecMap[cArray[n + 1]];
                byte by4 = UUDecMap[cArray[n + 2]];
                byte by5 = UUDecMap[cArray[n + 3]];
                byArray[n2++] = (byte)(by2 << 2 & 0xFF | by >>> 4 & 3);
                byArray[n2++] = (byte)(by << 4 & 0xFF | by4 >>> 2 & 0xF);
                byArray[n2++] = (byte)(by4 << 6 & 0xFF | by5 & 0x3F);
                n += 4;
            }
            if (n2 < n3) {
                by2 = UUDecMap[cArray[n]];
                by = UUDecMap[cArray[n + 1]];
                byArray[n2++] = (byte)(by2 << 2 & 0xFF | by >>> 4 & 3);
            }
            if (n2 < n3) {
                by2 = UUDecMap[cArray[n + 1]];
                by = UUDecMap[cArray[n + 2]];
                byArray[n2++] = (byte)(by2 << 4 & 0xFF | by >>> 2 & 0xF);
            }
            while (n < cArray.length && cArray[n] != '\n' && cArray[n] != '\r') {
                ++n;
            }
            while (n < cArray.length && (cArray[n] == '\n' || cArray[n] == '\r')) {
                ++n;
            }
        }
        return Util.resizeArray(byArray, n2);
    }

    public static final String quotedPrintableEncode(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] cArray2 = System.getProperty("line.separator", "\n").toCharArray();
        char[] cArray3 = new char[(int)((double)string.length() * 1.5)];
        char[] cArray4 = string.toCharArray();
        int n = 0;
        int n2 = 1;
        boolean bl = false;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            char c = cArray4[i];
            if (c == cArray2[0] && Codecs.match(cArray4, i, cArray2)) {
                if (cArray3[n2 - 1] == ' ') {
                    cArray3[n2 - 1] = 61;
                    cArray3[n2++] = 50;
                    cArray3[n2++] = 48;
                } else if (cArray3[n2 - 1] == '\t') {
                    cArray3[n2 - 1] = 61;
                    cArray3[n2++] = 48;
                    cArray3[n2++] = 57;
                }
                cArray3[n2++] = 13;
                cArray3[n2++] = 10;
                i += cArray2.length - 1;
                n = n2;
            } else if (c > '~' || c < ' ' && c != '\t' || c == '=' || EBCDICUnsafeChar.get(c)) {
                cArray3[n2++] = 61;
                cArray3[n2++] = cArray[(c & 0xF0) >>> 4];
                cArray3[n2++] = cArray[c & 0xF];
            } else {
                cArray3[n2++] = c;
            }
            if (n2 > n + 70) {
                cArray3[n2++] = 61;
                cArray3[n2++] = 13;
                cArray3[n2++] = 10;
                n = n2;
            }
            if (n2 <= cArray3.length - 5) continue;
            cArray3 = Util.resizeArray(cArray3, cArray3.length + 500);
        }
        return String.valueOf(cArray3, 1, n2 - 1);
    }

    private static final boolean match(char[] cArray, int n, char[] cArray2) {
        if (cArray.length < n + cArray2.length) {
            return false;
        }
        for (int i = 1; i < cArray2.length; ++i) {
            if (cArray[n + i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static final String quotedPrintableDecode(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        char[] cArray = new char[(int)((double)string.length() * 1.1)];
        char[] cArray2 = string.toCharArray();
        char[] cArray3 = System.getProperty("line.separator", "\n").toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            char c;
            if ((c = cArray2[n4++]) == '=') {
                if (n4 >= n3 - 1) {
                    throw new ParseException("Premature end of input detected");
                }
                if (cArray2[n4] == '\n' || cArray2[n4] == '\r') {
                    if (cArray2[++n4 - 1] == '\r' && cArray2[n4] == '\n') {
                        ++n4;
                    }
                } else {
                    int n6;
                    int n7 = Character.digit(cArray2[n4], 16);
                    if ((n7 | (n6 = Character.digit(cArray2[n4 + 1], 16))) < 0) {
                        throw new ParseException(new String(cArray2, n4 - 1, 3) + " is an invalid code");
                    }
                    n5 = (char)(n7 << 4 | n6);
                    n4 += 2;
                    cArray[n2++] = n5;
                }
                n = n2;
            } else if (c == '\n' || c == '\r') {
                if (c == '\r' && n4 < n3 && cArray2[n4] == '\n') {
                    ++n4;
                }
                for (n5 = 0; n5 < cArray3.length; ++n5) {
                    cArray[n++] = cArray3[n5];
                }
                n2 = n;
            } else {
                cArray[n2++] = c;
                if (c != ' ' && c != '\t') {
                    n = n2;
                }
            }
            if (n2 <= cArray.length - cArray3.length - 2) continue;
            cArray = Util.resizeArray(cArray, cArray.length + 500);
        }
        return new String(cArray, 0, n2);
    }

    public static final String URLEncode(String string) {
        if (string == null) {
            return null;
        }
        return URLEncoder.encode(string);
    }

    public static final String URLDecode(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        char[] cArray = new char[string.length()];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '+') {
                cArray[n++] = 32;
                continue;
            }
            if (c == '%') {
                try {
                    cArray[n++] = (char)Integer.parseInt(string.substring(i + 1, i + 3), 16);
                    i += 2;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException(string.substring(i, i + 3) + " is an invalid code");
                }
            }
            cArray[n++] = c;
        }
        return String.valueOf(cArray, 0, n);
    }

    public static final NVPair[] mpFormDataDecode(byte[] byArray, String string, String string2) throws IOException, ParseException {
        return Codecs.mpFormDataDecode(byArray, string, string2, null);
    }

    public static final NVPair[] mpFormDataDecode(byte[] byArray, String string, String string2, FilenameMangler filenameMangler) throws IOException, ParseException {
        String string3 = Util.getParameter("boundary", string);
        if (string3 == null) {
            throw new ParseException("'boundary' parameter not found in Content-type: " + string);
        }
        byte[] byArray2 = ("--" + string3 + "\r\n").getBytes();
        byte[] byArray3 = ("\r\n--" + string3 + "\r\n").getBytes();
        byte[] byArray4 = ("\r\n--" + string3 + "--").getBytes();
        int[] nArray = Util.compile_search(byArray2);
        int[] nArray2 = Util.compile_search(byArray3);
        int[] nArray3 = Util.compile_search(byArray4);
        int n = Util.findStr(byArray2, nArray, byArray, 0, byArray.length);
        if (n == -1) {
            throw new ParseException("Starting boundary not found: " + new String(byArray2));
        }
        n += byArray2.length;
        NVPair[] nVPairArray = new NVPair[10];
        boolean bl = false;
        int n2 = 0;
        while (!bl) {
            String string4;
            int n3;
            int n4 = Util.findStr(byArray3, nArray2, byArray, n, byArray.length);
            if (n4 == -1) {
                n4 = Util.findStr(byArray4, nArray3, byArray, n, byArray.length);
                if (n4 == -1) {
                    throw new ParseException("Ending boundary not found: " + new String(byArray4));
                }
                bl = true;
            }
            String string5 = null;
            String string6 = null;
            String string7 = null;
            while ((n3 = Codecs.findEOL(byArray, n) + 2) - 2 > n) {
                byte by;
                String string8 = new String(byArray, n, n3 - 2 - n);
                n = n3;
                while (n3 < byArray.length - 1 && ((by = byArray[n3]) == 32 || by == 9)) {
                    n3 = Codecs.findEOL(byArray, n) + 2;
                    string8 = string8 + new String(byArray, n, n3 - 2 - n);
                    n = n3;
                }
                if (!string8.regionMatches(true, 0, "Content-Disposition", 0, 19)) continue;
                Vector vector = Util.parseHeader(string8.substring(string8.indexOf(58) + 1));
                HttpHeaderElement httpHeaderElement = Util.getElement(vector, "form-data");
                if (httpHeaderElement == null) {
                    throw new ParseException("Expected 'Content-Disposition: form-data' in line: " + string8);
                }
                NVPair[] nVPairArray2 = httpHeaderElement.getParams();
                string6 = null;
                string5 = null;
                for (int i = 0; i < nVPairArray2.length; ++i) {
                    if (nVPairArray2[i].getName().equalsIgnoreCase("name")) {
                        string5 = nVPairArray2[i].getValue();
                    }
                    if (!nVPairArray2[i].getName().equalsIgnoreCase("filename")) continue;
                    string6 = nVPairArray2[i].getValue();
                }
                if (string5 == null) {
                    throw new ParseException("'name' parameter not found in header: " + string8);
                }
                string7 = string8;
            }
            if ((n += 2) > n4) {
                throw new ParseException("End of header not found at offset " + n4);
            }
            if (string7 == null) {
                throw new ParseException("Missing 'Content-Disposition' header at offset " + n);
            }
            if (string6 != null) {
                if (filenameMangler != null) {
                    string6 = filenameMangler.mangleFilename(string6, string5);
                }
                if (string6 != null) {
                    File file = new File(string2, string6);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(byArray, n, n4 - n);
                    fileOutputStream.close();
                }
                string4 = string6;
            } else {
                string4 = new String(byArray, n, n4 - n);
            }
            if (n2 >= nVPairArray.length) {
                nVPairArray = Util.resizeArray(nVPairArray, n2 + 10);
            }
            nVPairArray[n2] = new NVPair(string5, string4);
            n = n4 + byArray3.length;
            ++n2;
        }
        return Util.resizeArray(nVPairArray, n2);
    }

    private static final int findEOL(byte[] byArray, int n) {
        while (n < byArray.length - 1 && (byArray[n++] != 13 || byArray[n] != 10)) {
        }
        return n - 1;
    }

    public static final byte[] mpFormDataEncode(NVPair[] nVPairArray, NVPair[] nVPairArray2, NVPair[] nVPairArray3) throws IOException {
        return Codecs.mpFormDataEncode(nVPairArray, nVPairArray2, nVPairArray3, null);
    }

    public static final byte[] mpFormDataEncode(NVPair[] nVPairArray, NVPair[] nVPairArray2, NVPair[] nVPairArray3, FilenameMangler filenameMangler) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 119;
        byte[] byArray = new byte[74];
        byte[] byArray2 = new byte[40];
        byte[] byArray3 = new byte[13];
        Util.getBytes(ContDisp, byArray2, 0);
        Util.getBytes(FileName, byArray3, 0);
        Util.getBytes(Boundary, byArray, 0);
        if (nVPairArray == null) {
            nVPairArray = dummy;
        }
        if (nVPairArray2 == null) {
            nVPairArray2 = dummy;
        }
        for (n = 0; n < nVPairArray.length; ++n) {
            n2 += n3 + nVPairArray[n].getName().length() + nVPairArray[n].getValue().length();
        }
        for (n = 0; n < nVPairArray2.length; ++n) {
            File file = new File(nVPairArray2[n].getValue());
            String string = file.getName();
            if (filenameMangler != null) {
                string = filenameMangler.mangleFilename(string, nVPairArray2[n].getName());
            }
            if (string == null) continue;
            n2 += n3 + nVPairArray2[n].getName().length() + 13;
            n2 = (int)((long)n2 + ((long)string.length() + file.length()));
        }
        n2 -= 2;
        byte[] byArray4 = new byte[n2 += 78];
        int n4 = 0;
        block2: for (int i = 0x30303030; i != 0x7A7A7A7A; ++i) {
            int n5;
            n4 = 0;
            while (!BoundChar.get(i & 0xFF)) {
                ++i;
            }
            while (!BoundChar.get(i >> 8 & 0xFF)) {
                i += 256;
            }
            while (!BoundChar.get(i >> 16 & 0xFF)) {
                i += 65536;
            }
            while (!BoundChar.get(i >> 24 & 0xFF)) {
                i += 0x1000000;
            }
            byArray[40] = (byte)(i & 0xFF);
            byArray[42] = (byte)(i >> 8 & 0xFF);
            byArray[44] = (byte)(i >> 16 & 0xFF);
            byArray[46] = (byte)(i >> 24 & 0xFF);
            int n6 = 2;
            int[] nArray = Util.compile_search(byArray);
            for (n5 = 0; n5 < nVPairArray.length; ++n5) {
                System.arraycopy(byArray, n6, byArray4, n4, byArray.length - n6);
                n6 = 0;
                System.arraycopy(byArray2, 0, byArray4, n4 += byArray.length - n6, byArray2.length);
                int n7 = nVPairArray[n5].getName().length();
                Util.getBytes(nVPairArray[n5].getName(), n7, byArray4, n4 += byArray2.length);
                if (n7 >= byArray.length && Util.findStr(byArray, nArray, byArray4, n4, n4 + n7) != -1) continue block2;
                n4 += n7;
                byArray4[n4++] = 34;
                byArray4[n4++] = 13;
                byArray4[n4++] = 10;
                byArray4[n4++] = 13;
                byArray4[n4++] = 10;
                int n8 = nVPairArray[n5].getValue().length();
                Util.getBytes(nVPairArray[n5].getValue(), n8, byArray4, n4);
                if (n8 >= byArray.length && Util.findStr(byArray, nArray, byArray4, n4, n4 + n8) != -1) continue block2;
                n4 += n8;
            }
            for (n5 = 0; n5 < nVPairArray2.length; ++n5) {
                File file = new File(nVPairArray2[n5].getValue());
                String string = file.getName();
                if (filenameMangler != null) {
                    string = filenameMangler.mangleFilename(string, nVPairArray2[n5].getName());
                }
                if (string == null) continue;
                System.arraycopy(byArray, n6, byArray4, n4, byArray.length - n6);
                n6 = 0;
                System.arraycopy(byArray2, 0, byArray4, n4 += byArray.length - n6, byArray2.length);
                int n9 = nVPairArray2[n5].getName().length();
                Util.getBytes(nVPairArray2[n5].getName(), byArray4, n4 += byArray2.length);
                if (n9 >= byArray.length && Util.findStr(byArray, nArray, byArray4, n4, n4 + n9) != -1) continue block2;
                System.arraycopy(byArray3, 0, byArray4, n4 += n9, byArray3.length);
                n9 = string.length();
                Util.getBytes(string, byArray4, n4 += byArray3.length);
                if (n9 >= byArray.length && Util.findStr(byArray, nArray, byArray4, n4, n4 + n9) != -1) continue block2;
                n4 += n9;
                byArray4[n4++] = 34;
                byArray4[n4++] = 13;
                byArray4[n4++] = 10;
                byArray4[n4++] = 13;
                byArray4[n4++] = 10;
                n9 = (int)file.length();
                int n10 = n4;
                FileInputStream fileInputStream = new FileInputStream(file);
                while (n9 > 0) {
                    int n11 = fileInputStream.read(byArray4, n4, n9);
                    n9 -= n11;
                    n4 += n11;
                }
                if (Util.findStr(byArray, nArray, byArray4, n10, n4) != -1) continue block2;
            }
        }
        System.arraycopy(byArray, 0, byArray4, n4, byArray.length);
        n4 += byArray.length;
        byArray4[n4++] = 45;
        byArray4[n4++] = 45;
        byArray4[n4++] = 13;
        byArray4[n4++] = 10;
        if (n4 != n2) {
            throw new Error("Calculated " + n2 + " bytes but wrote " + n4 + " bytes!");
        }
        nVPairArray3[0] = new NVPair("Content-Type", "multipart/form-data; boundary=" + new String(byArray, 4, 70));
        return byArray4;
    }

    public static final String nv2query(NVPair[] nVPairArray) {
        int n;
        if (nVPairArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < nVPairArray.length; ++n) {
            stringBuffer.append(Codecs.URLEncode(nVPairArray[n].getName()) + "=" + Codecs.URLEncode(nVPairArray[n].getValue()) + "&");
        }
        if (n > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static final NVPair[] query2nv(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        int n = -1;
        int n2 = 1;
        while ((n = string.indexOf(38, n + 1)) != -1) {
            ++n2;
        }
        NVPair[] nVPairArray = new NVPair[n2];
        n = 0;
        for (n2 = 0; n2 < nVPairArray.length; ++n2) {
            int n3 = string.indexOf(61, n);
            int n4 = string.indexOf(38, n);
            if (n4 == -1) {
                n4 = string.length();
            }
            if (n3 == -1 || n3 >= n4) {
                throw new ParseException("'=' missing in " + string.substring(n, n4));
            }
            nVPairArray[n2] = new NVPair(Codecs.URLDecode(string.substring(n, n3)), Codecs.URLDecode(string.substring(n3 + 1, n4)));
            n = n4 + 1;
        }
        return nVPairArray;
    }

    public static final byte[] chunkedEncode(byte[] byArray, NVPair[] nVPairArray, boolean bl) {
        return Codecs.chunkedEncode(byArray, 0, byArray == null ? 0 : byArray.length, nVPairArray, bl);
    }

    public static final byte[] chunkedEncode(byte[] byArray, int n, int n2, NVPair[] nVPairArray, boolean bl) {
        if (byArray == null) {
            byArray = new byte[]{};
            n2 = 0;
        }
        if (bl && nVPairArray == null) {
            nVPairArray = new NVPair[]{};
        }
        String string = Integer.toString(n2, 16);
        int n3 = 0;
        if (n2 > 0) {
            n3 += string.length() + 2 + n2 + 2;
        }
        if (bl) {
            n3 += 3;
            for (int i = 0; i < nVPairArray.length; ++i) {
                n3 += nVPairArray[i].getName().length() + 2 + nVPairArray[i].getValue().length() + 2;
            }
            n3 += 2;
        }
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        if (n2 > 0) {
            Util.getBytes(string, byArray2, n4);
            n4 += string.length();
            byArray2[n4++] = 13;
            byArray2[n4++] = 10;
            System.arraycopy(byArray, n, byArray2, n4, n2);
            n4 += n2;
            byArray2[n4++] = 13;
            byArray2[n4++] = 10;
        }
        if (bl) {
            byArray2[n4++] = 48;
            byArray2[n4++] = 13;
            byArray2[n4++] = 10;
            for (int i = 0; i < nVPairArray.length; ++i) {
                Util.getBytes(nVPairArray[i].getName(), byArray2, n4);
                n4 += nVPairArray[i].getName().length();
                byArray2[n4++] = 58;
                byArray2[n4++] = 32;
                Util.getBytes(nVPairArray[i].getValue(), byArray2, n4);
                n4 += nVPairArray[i].getValue().length();
                byArray2[n4++] = 13;
                byArray2[n4++] = 10;
            }
            byArray2[n4++] = 13;
            byArray2[n4++] = 10;
        }
        if (n4 != byArray2.length) {
            throw new Error("Calculated " + byArray2.length + " bytes but wrote " + n4 + " bytes!");
        }
        return byArray2;
    }

    public static final Object chunkedDecode(InputStream inputStream) throws ParseException, IOException {
        String string;
        int n = Codecs.getChunkLength(inputStream);
        if (n > 0) {
            int n2;
            byte[] byArray = new byte[n];
            for (n2 = 0; n != -1 && n2 < byArray.length; n2 += n) {
                n = inputStream.read(byArray, n2, byArray.length - n2);
            }
            if (n == -1) {
                throw new ParseException("Premature EOF while reading chunk;Expected: " + byArray.length + " Bytes, " + "Received: " + (n2 + 1) + " Bytes");
            }
            inputStream.read();
            inputStream.read();
            return byArray;
        }
        NVPair[] nVPairArray = new NVPair[]{};
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        while ((string = dataInputStream.readLine()) != null && string.length() > 0) {
            int n3 = string.indexOf(58);
            if (n3 == -1) {
                throw new ParseException("Error in Footer format: no ':' found in '" + string + "'");
            }
            nVPairArray = Util.resizeArray(nVPairArray, nVPairArray.length + 1);
            nVPairArray[nVPairArray.length - 1] = new NVPair(string.substring(0, n3).trim(), string.substring(n3 + 1).trim());
        }
        return nVPairArray;
    }

    static final int getChunkLength(InputStream inputStream) throws ParseException, IOException {
        int n;
        int n2;
        byte[] byArray = new byte[8];
        int n3 = 0;
        while ((n2 = inputStream.read()) != 13 && n2 != 10 && n2 != 59 && n3 < byArray.length) {
            byArray[n3++] = (byte)n2;
        }
        if (n2 == 59) {
            while ((n2 = inputStream.read()) != 13 && n2 != 10) {
            }
        }
        if (n2 != 10 && (n2 != 13 || inputStream.read() != 10)) {
            throw new ParseException("Didn't find valid chunk length: " + new String(byArray, 0, n3));
        }
        try {
            n = Integer.parseInt(new String(byArray, 0, n3).trim(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Didn't find valid chunk length: " + new String(byArray, 0, n3));
        }
        return n;
    }

    static {
        int n;
        int n2;
        BoundChar = new BitSet(256);
        for (n2 = 48; n2 <= 57; ++n2) {
            BoundChar.set(n2);
        }
        for (n2 = 65; n2 <= 90; ++n2) {
            BoundChar.set(n2);
        }
        for (n2 = 97; n2 <= 122; ++n2) {
            BoundChar.set(n2);
        }
        BoundChar.set(39);
        BoundChar.set(43);
        BoundChar.set(95);
        BoundChar.set(45);
        BoundChar.set(46);
        EBCDICUnsafeChar = new BitSet(256);
        EBCDICUnsafeChar.set(33);
        EBCDICUnsafeChar.set(34);
        EBCDICUnsafeChar.set(35);
        EBCDICUnsafeChar.set(36);
        EBCDICUnsafeChar.set(64);
        EBCDICUnsafeChar.set(91);
        EBCDICUnsafeChar.set(92);
        EBCDICUnsafeChar.set(93);
        EBCDICUnsafeChar.set(94);
        EBCDICUnsafeChar.set(96);
        EBCDICUnsafeChar.set(123);
        EBCDICUnsafeChar.set(124);
        EBCDICUnsafeChar.set(125);
        EBCDICUnsafeChar.set(126);
        byte[] byArray = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        Base64EncMap = byArray;
        Base64DecMap = new byte[128];
        for (n = 0; n < Base64EncMap.length; ++n) {
            Codecs.Base64DecMap[Codecs.Base64EncMap[n]] = (byte)n;
        }
        UUEncMap = new char[64];
        for (n = 0; n < UUEncMap.length; ++n) {
            Codecs.UUEncMap[n] = (char)(n + 32);
        }
        UUDecMap = new byte[128];
        for (n = 0; n < UUEncMap.length; ++n) {
            Codecs.UUDecMap[Codecs.UUEncMap[n]] = (byte)n;
        }
        dummy = new NVPair[0];
    }
}

