/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j;

import com.github.zafarkhaja.semver.Version;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.PluginDescriptor;
import ro.fortsoft.pf4j.PluginDescriptorFinder;
import ro.fortsoft.pf4j.PluginException;
import ro.fortsoft.pf4j.util.StringUtils;

public class PropertiesPluginDescriptorFinder
implements PluginDescriptorFinder {
    private static final Logger log = LoggerFactory.getLogger(PropertiesPluginDescriptorFinder.class);
    private static final String DEFAULT_PROPERTIES_FILE_NAME = "plugin.properties";
    private String propertiesFileName;

    public PropertiesPluginDescriptorFinder() {
        this(DEFAULT_PROPERTIES_FILE_NAME);
    }

    public PropertiesPluginDescriptorFinder(String propertiesFileName) {
        this.propertiesFileName = propertiesFileName;
    }

    @Override
    public PluginDescriptor find(Path pluginPath) throws PluginException {
        Properties properties = this.readProperties(pluginPath);
        return this.createPluginDescriptor(properties);
    }

    protected Properties readProperties(Path pluginPath) throws PluginException {
        Path propertiesPath = pluginPath.resolve(Paths.get(this.propertiesFileName, new String[0]));
        log.debug("Lookup plugin descriptor in '{}'", (Object)propertiesPath);
        if (Files.notExists(propertiesPath, new LinkOption[0])) {
            throw new PluginException("Cannot find '{}' path", pluginPath);
        }
        Properties properties = new Properties();
        try (InputStream input = Files.newInputStream(propertiesPath, new OpenOption[0]);){
            properties.load(input);
        }
        catch (IOException e) {
            throw new PluginException(e.getMessage(), e);
        }
        return properties;
    }

    protected PluginDescriptor createPluginDescriptor(Properties properties) {
        PluginDescriptor pluginDescriptor = this.createPluginDescriptorInstance();
        String id = properties.getProperty("plugin.id");
        pluginDescriptor.setPluginId(id);
        String description = properties.getProperty("plugin.description");
        if (StringUtils.isEmpty(description)) {
            pluginDescriptor.setPluginDescription("");
        } else {
            pluginDescriptor.setPluginDescription(description);
        }
        String clazz = properties.getProperty("plugin.class");
        pluginDescriptor.setPluginClass(clazz);
        String version = properties.getProperty("plugin.version");
        if (StringUtils.isNotEmpty(version)) {
            pluginDescriptor.setPluginVersion(Version.valueOf(version));
        }
        String provider = properties.getProperty("plugin.provider");
        pluginDescriptor.setProvider(provider);
        String dependencies = properties.getProperty("plugin.dependencies");
        pluginDescriptor.setDependencies(dependencies);
        String requires = properties.getProperty("plugin.requires");
        if (StringUtils.isNotEmpty(requires)) {
            pluginDescriptor.setRequires(requires);
        }
        pluginDescriptor.setLicense(properties.getProperty("plugin.license"));
        return pluginDescriptor;
    }

    protected PluginDescriptor createPluginDescriptorInstance() {
        return new PluginDescriptor();
    }
}

