/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.pf4j.PluginRepository;

public class CompoundPluginRepository
implements PluginRepository {
    private List<PluginRepository> repositories = new ArrayList<PluginRepository>();

    public CompoundPluginRepository add(PluginRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException("null not allowed");
        }
        this.repositories.add(repository);
        return this;
    }

    @Override
    public List<Path> getPluginPaths() {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (PluginRepository repository : this.repositories) {
            paths.addAll(repository.getPluginPaths());
        }
        return paths;
    }

    @Override
    public boolean deletePluginPath(Path pluginPath) {
        for (PluginRepository repository : this.repositories) {
            if (!repository.deletePluginPath(pluginPath)) continue;
            return true;
        }
        return false;
    }
}

