/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.properties;

import ch.rakudave.jnetmap.controller.Controller;
import ch.rakudave.jnetmap.controller.command.Command;
import ch.rakudave.jnetmap.model.IF.NetworkIF;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.model.device.Host;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.SwingHelper;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.components.EscapableDialog;
import ch.rakudave.jnetmap.view.components.TabPanel;
import ch.rakudave.jnetmap.view.properties.InterfaceProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileNameExtensionFilter;

public class DeviceProperties
extends EscapableDialog {
    private Device d;

    public DeviceProperties(final Frame owner, Device device, boolean isNew) {
        super((Window)owner, Lang.getNoHTML("device.properties"));
        this.d = device;
        this.setLayout(new BorderLayout(5, 5));
        this.setPreferredSize(new Dimension(400, 540));
        this.setMinimumSize(new Dimension(400, 500));
        final String oldType = this.d.getType() != null ? this.d.getType() : "Workstation";
        JPanel iconPanel = new JPanel(new FlowLayout(1));
        JLabel deviceIcon = new JLabel("Other".equals(oldType) ? Icons.fromBase64(this.d.getOtherID()) : Icons.getCisco(oldType.toString().toLowerCase()));
        iconPanel.add(Box.createVerticalStrut(64));
        iconPanel.add(deviceIcon);
        iconPanel.add(Box.createVerticalStrut(64));
        JPanel centerWrapper = new JPanel(new BorderLayout());
        centerWrapper.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        JPanel propPanel = new JPanel(new GridLayout(0, 2, 5, 5));
        JTextField otherID = new JTextField(this.d.getOtherID());
        JComboBox<String> typeCombo = new JComboBox<String>(Host.defaultTypes);
        typeCombo.setSelectedItem(oldType);
        typeCombo.addActionListener(e -> {
            if ("other".equalsIgnoreCase(typeCombo.getSelectedItem().toString())) {
                File f = SwingHelper.openDialog(owner, new FileNameExtensionFilter("PNG Image", "png"));
                if (f != null) {
                    String base64 = Icons.getBase64(f);
                    otherID.setText(base64);
                    deviceIcon.setIcon(Icons.fromBase64(base64));
                } else {
                    deviceIcon.setIcon(Icons.getCisco(oldType.toString().toLowerCase()));
                    typeCombo.setSelectedItem(oldType);
                }
            } else {
                deviceIcon.setIcon(Icons.getCisco(typeCombo.getSelectedItem().toString().toLowerCase()));
                otherID.setText("");
            }
        });
        JTextField deviceName = new JTextField(this.d.getName());
        JTextField deviceDesc = new JTextField(this.d.getDesctription());
        JTextField deviceLocation = new JTextField(this.d.getLocation());
        JTextField deviceVendor = new JTextField(this.d.getVendor());
        JTextField deviceModel = new JTextField(this.d.getModel());
        JCheckBox deviceIgnore = new JCheckBox(Lang.get("event.ignore.text"));
        deviceIgnore.setSelected(this.d.isIgnore());
        propPanel.add(new JLabel(Lang.get("device.type")));
        propPanel.add(typeCombo);
        propPanel.add(new JLabel(Lang.get("device.name")));
        propPanel.add(deviceName);
        propPanel.add(new JLabel(Lang.get("device.description")));
        propPanel.add(deviceDesc);
        propPanel.add(new JLabel(Lang.get("device.location")));
        propPanel.add(deviceLocation);
        propPanel.add(new JLabel(Lang.get("device.vendor")));
        propPanel.add(deviceVendor);
        propPanel.add(new JLabel(Lang.get("device.model")));
        propPanel.add(deviceModel);
        propPanel.add(new JLabel(Lang.get("event.ignore.title")));
        propPanel.add(deviceIgnore);
        propPanel.add(new JLabel(Lang.get("device.interfaces")));
        propPanel.add(new JLabel());
        SpinnerNumberModel nrOfPorts = new SpinnerNumberModel(this.d.getNrOfPorts(), this.d.getInterfaces().size(), 512, 1);
        final IFListModel interfaceListModel = new IFListModel(this.d, nrOfPorts);
        final JList<Object> interfaceList = new JList<Object>(interfaceListModel);
        interfaceList.setCellRenderer(new IFListRenderer());
        interfaceList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    new InterfaceProperties(owner, (NetworkIF)interfaceList.getSelectedValue(), saved -> {
                        if (saved.booleanValue()) {
                            interfaceListModel.update();
                        }
                    });
                }
            }
        });
        JPanel interfaceManipulators = new JPanel();
        interfaceManipulators.setLayout(new BoxLayout(interfaceManipulators, 3));
        interfaceManipulators.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JButton removeInterface = new JButton(Lang.get("action.remove"), Icons.get("remove"));
        removeInterface.setPreferredSize(new Dimension(120, 30));
        removeInterface.addActionListener(e -> {
            if (!(interfaceList.getSelectedValue() instanceof NetworkIF)) {
                return;
            }
            if (JOptionPane.showConfirmDialog(owner, Lang.get("message.confirm.delete").replaceAll("%name%", ((NetworkIF)interfaceList.getSelectedValue()).getName()), Lang.getNoHTML("action.delete"), 0) == 1) {
                return;
            }
            Controller.getCurrentMap().removeEdge(((NetworkIF)interfaceList.getSelectedValue()).getConnection());
            interfaceListModel.update();
        });
        JButton editInterface = new JButton(Lang.get("action.edit"), Icons.get("edit"));
        editInterface.setPreferredSize(new Dimension(120, 30));
        editInterface.addActionListener(e -> {
            if (!(interfaceList.getSelectedValue() instanceof NetworkIF)) {
                return;
            }
            new InterfaceProperties(owner, (NetworkIF)interfaceList.getSelectedValue(), saved -> {
                if (saved.booleanValue()) {
                    interfaceListModel.update();
                }
            });
        });
        JSpinner nrOfPortsSpinner = new JSpinner(nrOfPorts);
        nrOfPortsSpinner.setMaximumSize(new Dimension(100, 30));
        nrOfPortsSpinner.addChangeListener(e -> interfaceListModel.update());
        JPanel intManWrapper = new JPanel(new GridLayout(4, 1));
        intManWrapper.add(editInterface);
        intManWrapper.add(removeInterface);
        intManWrapper.add(new JLabel(Lang.get("device.ports")));
        intManWrapper.add(nrOfPortsSpinner);
        interfaceManipulators.add(intManWrapper);
        interfaceManipulators.add(Box.createVerticalGlue());
        centerWrapper.add((Component)propPanel, "North");
        centerWrapper.add((Component)new JScrollPane(interfaceList, 20, 31), "Center");
        centerWrapper.add((Component)interfaceManipulators, "East");
        JPanel bottomRow = new JPanel(new FlowLayout(2, 5, 5));
        DeviceProperties _this = this;
        JButton cancel = new JButton(Lang.get("action.cancel"), Icons.get("cancel"));
        cancel.addActionListener(e -> _this.dispose());
        JButton ok = new JButton(Lang.get("action.ok"), Icons.get("ok"));
        ok.setPreferredSize(cancel.getPreferredSize());
        ok.addActionListener(e -> {
            final String newType = (String)typeCombo.getSelectedItem();
            final String oldName = this.d.getName();
            final String newName = deviceName.getText();
            final String oldID = this.d.getOtherID();
            final String newID = otherID.getText();
            final String oldDesc = this.d.getDesctription();
            final String newDesc = deviceDesc.getText();
            final String oldLocation = this.d.getLocation();
            final String newLocation = deviceLocation.getText();
            final String oldVendor = this.d.getVendor();
            final String newVentor = deviceVendor.getText();
            final String oldModel = this.d.getModel();
            final String newModel = deviceModel.getText();
            final boolean oldIgnore = this.d.isIgnore();
            final boolean newIgnore = deviceIgnore.isSelected();
            final int oldNrOfPorts = this.d.getNrOfPorts();
            final int newNrOfPorts = (Integer)nrOfPorts.getValue();
            Controller.getCurrentMap().getHistory().execute(new Command(){

                @Override
                public Object undo() {
                    DeviceProperties.this.d.setType(oldType);
                    DeviceProperties.this.d.setOtherID(oldID);
                    DeviceProperties.this.d.setName(oldName);
                    DeviceProperties.this.d.setDescription(oldDesc);
                    DeviceProperties.this.d.setLocation(oldLocation);
                    DeviceProperties.this.d.setVendor(oldVendor);
                    DeviceProperties.this.d.setModel(oldModel);
                    DeviceProperties.this.d.setIgnore(oldIgnore);
                    DeviceProperties.this.d.setNrOfPorts(oldNrOfPorts);
                    return null;
                }

                @Override
                public Object redo() {
                    DeviceProperties.this.d.setType(newType);
                    DeviceProperties.this.d.setOtherID(newID);
                    DeviceProperties.this.d.setName(newName);
                    DeviceProperties.this.d.setDescription(newDesc);
                    DeviceProperties.this.d.setLocation(newLocation);
                    DeviceProperties.this.d.setVendor(newVentor);
                    DeviceProperties.this.d.setModel(newModel);
                    DeviceProperties.this.d.setIgnore(newIgnore);
                    DeviceProperties.this.d.setNrOfPorts(newNrOfPorts);
                    return null;
                }

                @Override
                public String toString() {
                    return Lang.getNoHTML("command.update.device") + ": " + DeviceProperties.this.d.getName();
                }
            });
            _this.dispose();
            if (TabPanel.getCurrentTab() != null) {
                TabPanel.getCurrentTab().repaint();
            }
        });
        if (!isNew) {
            bottomRow.add(cancel);
        }
        bottomRow.add(ok);
        this.add((Component)iconPanel, "North");
        this.add((Component)centerWrapper, "Center");
        this.add((Component)bottomRow, "South");
        this.pack();
        SwingHelper.centerTo(owner, this);
        deviceName.requestFocus();
        this.setVisible(true);
    }

    private class IFListModel
    extends DefaultListModel<Object> {
        private Device device;
        private SpinnerNumberModel spinnerModel;

        public IFListModel(Device device, SpinnerNumberModel nrOfPorts) {
            this.device = device;
            this.spinnerModel = nrOfPorts;
        }

        @Override
        public int getSize() {
            return Math.max(this.device.getInterfaces().size(), (Integer)this.spinnerModel.getValue());
        }

        @Override
        public Object getElementAt(int index) {
            if (index < this.device.getInterfaces().size()) {
                return this.device.getInterfaces().get(index);
            }
            return Lang.getNoHTML("device.port") + " " + (index + 1);
        }

        public void update() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    private class IFListRenderer
    extends DefaultListCellRenderer {
        private IFListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof NetworkIF)) {
                label.setText("<html><span style=\"color: #999999;\">" + label.getText() + "</span></html>");
                return label;
            }
            NetworkIF nif = (NetworkIF)value;
            try {
                String color = nif.getStatus().getHtmlValue();
                label.setText("<html>" + nif + " <span style=\"color: " + color + ";\"> &rarr; </span>" + Controller.getCurrentMap().getOpposite(DeviceProperties.this.d, nif.getConnection()) + "</html>");
            }
            catch (Exception e) {
                Logger.debug("Failed to get opposite of " + nif.toString(), e);
            }
            return label;
        }
    }
}

