/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.preferences;

import ch.rakudave.jnetmap.controller.Actions;
import ch.rakudave.jnetmap.controller.Controller;
import ch.rakudave.jnetmap.plugins.JNetMapPlugin;
import ch.rakudave.jnetmap.util.IO;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.SwingHelper;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.preferences.PreferencePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.pf4j.PluginState;
import org.pf4j.PluginWrapper;

public class PluginPanel
extends PreferencePanel {
    private JPanel pluginList;

    public PluginPanel() {
        this.setLayout(new BorderLayout());
        this.title = Lang.getNoHTML("preferences.plugins");
        this.pluginList = new JPanel();
        this.pluginList.setLayout(new BoxLayout(this.pluginList, 3));
        List<PluginWrapper> plugins = Controller.getPluginManager().getPlugins();
        for (PluginWrapper wrapper : plugins) {
            if (!(wrapper.getPlugin() instanceof JNetMapPlugin)) continue;
            this.pluginList.add(new PluginInfo(wrapper));
            this.pluginList.add(new JSeparator());
        }
        this.pluginList.add(Box.createVerticalGlue());
        final PluginPanel _this = this;
        JPanel bottom = new JPanel(new BorderLayout());
        JButton add = SwingHelper.createAlignedButton(new AbstractAction(Lang.get("preferences.plugins.get"), Icons.get("down")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.openWebsite("https://rakudave.ch/jnetmap/#download");
            }
        });
        JButton install = SwingHelper.createAlignedButton(new AbstractAction(Lang.get("action.install"), Icons.get("install")){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = SwingHelper.openDialog(_this, new FileNameExtensionFilter("Java Archive File", "jar"));
                if (f == null) {
                    return;
                }
                try {
                    IO.copy(f, new File(new File(IO.userDir, "/plugins"), f.getName()), null);
                    JOptionPane.showMessageDialog(_this, Lang.get("message.import.restart"), f.getName(), 1);
                    Controller.getPluginManager().loadPlugins();
                    Controller.getPluginManager().getPlugins().stream().filter(w -> f.getName().contains(w.getPluginId())).forEach(w -> {
                        Controller.getPluginManager().enablePlugin(w.getPluginId());
                        PluginPanel.this.pluginList.add(new PluginInfo((PluginWrapper)w));
                        PluginPanel.this.pluginList.add(new JSeparator());
                    });
                }
                catch (Exception e1) {
                    Logger.error("Failed to install plugin " + f, e1);
                    JOptionPane.showMessageDialog(_this, Lang.get("message.import.error"), f.getName(), 0);
                }
            }
        });
        bottom.add((Component)add, "West");
        bottom.add((Component)install, "East");
        JScrollPane scroller = new JScrollPane(this.pluginList, 20, 31);
        scroller.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)scroller, "Center");
        this.add((Component)bottom, "South");
    }

    @Override
    public void save() {
    }

    private class PluginInfo
    extends JPanel
    implements ActionListener {
        private PluginWrapper wrapper;
        JButton enableButton;

        public PluginInfo(PluginWrapper wrapper) {
            super(new BorderLayout(5, 5));
            this.wrapper = wrapper;
            PluginInfo _this = this;
            JNetMapPlugin p = (JNetMapPlugin)wrapper.getPlugin();
            this.setPreferredSize(new Dimension(380, 105));
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel bottom = new JPanel();
            bottom.setLayout(new BoxLayout(bottom, 2));
            this.enableButton = new JButton(Lang.get("action.disable"), Icons.get("cancel"));
            if (PluginState.DISABLED.equals(wrapper.getPluginState())) {
                this.enableButton.setText(Lang.get("action.enable"));
                this.enableButton.setIcon(Icons.get("ok"));
            }
            this.enableButton.addActionListener(this);
            this.enableButton.setMaximumSize(new Dimension(50, 30));
            JButton deleteButton = new JButton(Lang.get("action.delete"), Icons.get("close"));
            deleteButton.addActionListener(actionEvent -> {
                int action = JOptionPane.showConfirmDialog(_this, Lang.get("message.confirm.delete").replaceAll("%name%", p.getPluginName()), Lang.get("action.delete"), 2);
                if (action != 0) {
                    return;
                }
                Controller.getPluginManager().deletePlugin(wrapper.getPluginId());
                _this.setEnabled(false);
                Arrays.stream(_this.getComponents()).forEach(c -> c.setEnabled(false));
                this.enableButton.setEnabled(false);
                deleteButton.setEnabled(false);
            });
            deleteButton.setMaximumSize(new Dimension(50, 30));
            bottom.add(new JLabel("by " + p.getAuthor()));
            bottom.add(Box.createHorizontalGlue());
            bottom.add(this.enableButton);
            bottom.add(deleteButton);
            JLabel title = new JLabel("<html>" + p.getPluginName() + " <span style=\"color: gray; text-align: right;\">(" + wrapper.getPluginId() + " " + wrapper.getDescriptor().getVersion() + ")</span></html>", p.getIcon(), 2);
            JTextArea description = new JTextArea(p.getDescription());
            description.setLineWrap(true);
            description.setWrapStyleWord(true);
            description.setFocusable(false);
            description.setBackground(new Color(this.getBackground().getRGB()));
            description.setFont(title.getFont().deriveFont(0, (int)((double)title.getFont().getSize() * 0.9)));
            this.add((Component)title, "North");
            this.add((Component)description, "Center");
            this.add((Component)bottom, "South");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PluginState.DISABLED.equals(this.wrapper.getPluginState())) {
                if (Controller.getPluginManager().enablePlugin(this.wrapper.getPluginId())) {
                    this.enableButton.setText(Lang.get("action.disable"));
                    this.enableButton.setIcon(Icons.get("cancel"));
                }
            } else if (Controller.getPluginManager().disablePlugin(this.wrapper.getPluginId())) {
                this.enableButton.setText(Lang.get("action.enable"));
                this.enableButton.setIcon(Icons.get("ok"));
            }
        }
    }
}

