/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.components;

import ch.rakudave.jnetmap.controller.Controller;
import ch.rakudave.jnetmap.controller.command.Command;
import ch.rakudave.jnetmap.model.Connection;
import ch.rakudave.jnetmap.model.Map;
import ch.rakudave.jnetmap.model.MapEvent;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.model.factories.ConnectionFactory;
import ch.rakudave.jnetmap.model.factories.DeviceFactory;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.components.ToolBar;
import ch.rakudave.jnetmap.view.components.WelcomeScreen;
import ch.rakudave.jnetmap.view.jung.EdgeLabeler;
import ch.rakudave.jnetmap.view.jung.EdgeTransformers;
import ch.rakudave.jnetmap.view.jung.EditModeListener;
import ch.rakudave.jnetmap.view.jung.GridGraphLayout;
import ch.rakudave.jnetmap.view.jung.MapGraphMouse;
import ch.rakudave.jnetmap.view.jung.ResettableScaler;
import ch.rakudave.jnetmap.view.jung.VertexLabeler;
import ch.rakudave.jnetmap.view.jung.VertexTransformers;
import edu.uci.ics.jung.algorithms.layout.BalloonLayout;
import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.ISOMLayout;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout2;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.algorithms.shortestpath.MinimumSpanningForest2;
import edu.uci.ics.jung.graph.DelegateForest;
import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.GraphMouseListener;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.layout.LayoutTransition;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.util.Animator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.collections15.Transformer;

public class TabPanel
extends JTabbedPane
implements ChangeListener,
GraphMouseListener<Device> {
    private TabPanel _this = this;
    private Frame owner;
    private List<GraphMouseListener<Device>> graphListeners;
    private static TabComponent currentTab;
    private JButton plusButton;
    private static ResettableScaler scaler;
    private static List<EditModeListener> editModeListeners;

    public TabPanel(int tabPlacement, int tabLayoutPolicy, Frame owner) {
        super(tabPlacement, tabLayoutPolicy);
        this.owner = owner;
        this.graphListeners = new ArrayList<GraphMouseListener<Device>>();
        scaler = new ResettableScaler();
        this.addTab("+", null, new WelcomeScreen());
        this.createPlusButton();
        ToolBar.getInstance().add("map.pick", TabPanel.getPickingModeSetter());
        ToolBar.getInstance().add("map.edit", TabPanel.getEditingModeSetter());
        ToolBar.getInstance().add("map.transform", TabPanel.getTransformingModeSetter());
        ToolBar.getInstance().add("map.zoomin", TabPanel.getZoomPlus());
        ToolBar.getInstance().add("map.zoomout", TabPanel.getZoomMinus());
        ToolBar.getInstance().add("map.zoomreset", TabPanel.getZoomReset());
        this.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Component o = this.getSelectedComponent();
        if (o instanceof TabComponent) {
            currentTab = (TabComponent)o;
            Controller.setCurrentMap(TabPanel.currentTab.map);
            editModeListeners.forEach(eml -> eml.editModeChanged(TabPanel.currentTab.editMode));
        }
    }

    private void closeTab(String tabTitle) {
        int tabIndex = this.getTabIndex(tabTitle);
        TabComponent tc = (TabComponent)this.getComponentAt(tabIndex);
        if (!Controller.close(tc.map)) {
            return;
        }
        this.removeTabAt(tabIndex);
    }

    private void createPlusButton() {
        this.plusButton = new JButton(Icons.get("add"));
        this.plusButton.setContentAreaFilled(false);
        this.plusButton.setBorder(BorderFactory.createEmptyBorder());
        this.plusButton.addActionListener(e -> this.openTab(new Map()));
        this.setTabComponentAt(0, this.plusButton);
    }

    private int getTabIndex(String tabTitle) {
        for (int i = 0; i < this.getTabCount() - 1; ++i) {
            if (!tabTitle.equals(this.getTabComponentAt(i).getName())) continue;
            return i;
        }
        return -1;
    }

    public void openTab(final Map map) {
        int tabCount = this.getTabCount() - 1;
        if (map.getGraphLayout() == null || map.getGraphLayout().getSize() == null) {
            Logger.error("Invalid graph layout, using fallback");
            map.setLayout(new CircleLayout<Device, Connection>(map));
            map.getGraphLayout().setSize(new Dimension(1000, 1000));
        }
        VisualizationViewer<Device, Connection> vv = new VisualizationViewer<Device, Connection>(map.getGraphLayout());
        map.addMapListener(e -> {
            if (e.getType() == MapEvent.Type.SETTINGS_CHANGED) {
                vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.S);
                RenderContext<Device, Connection> rc = vv.getRenderContext();
                rc.setVertexIconTransformer(VertexTransformers.iconTransformer(vv.getPickedVertexState()));
                rc.setVertexShapeTransformer(VertexTransformers.shapeTransformer());
                rc.setVertexLabelTransformer(new VertexLabeler());
                rc.setVertexIncludePredicate(map.getDevicePredicate());
                vv.setVertexToolTipTransformer(VertexTransformers.tooltipTransformer());
                vv.setBackground(new Color(Settings.getInt("background.color", Color.white.getRGB())));
                rc.setEdgeStrokeTransformer(EdgeTransformers.strokeTransformer());
                rc.setEdgeDrawPaintTransformer(EdgeTransformers.paintTransformer(vv.getPickedEdgeState()));
                rc.setEdgeLabelTransformer(new EdgeLabeler());
                EdgeTransformers.setEdgeShape(rc);
            }
            vv.repaint();
        });
        MapGraphMouse egm = new MapGraphMouse(this.owner, vv.getRenderContext(), scaler, new DeviceFactory(), new ConnectionFactory(), 1.0f / Settings.getFloat("mapview.zoom.scroll", 1.1f), Settings.getFloat("mapview.zoom.scroll", 1.1f));
        egm.setMode(ModalGraphMouse.Mode.PICKING);
        vv.setGraphMouse(egm);
        vv.addGraphMouseListener(this._this);
        final MutableTransformer modelTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT);
        vv.addPreRenderPaintable(new VisualizationServer.Paintable(){

            @Override
            public boolean useTransform() {
                return true;
            }

            @Override
            public void paint(Graphics g) {
                if (map.getBackground() != null) {
                    g.drawImage(map.getBackgroundImage(), (int)modelTransformer.getTranslateX(), (int)modelTransformer.getTranslateY(), null);
                }
            }
        });
        map.refreshView(MapEvent.Type.SETTINGS_CHANGED);
        this.insertTab(map.getFileName(), null, new TabComponent(map, egm, vv), map.getFilePath(), tabCount);
        this.setTabComponentAt(tabCount, new ClosableTabHeader(map));
        this.setSelectedIndex(tabCount);
    }

    public void addGraphListener(GraphMouseListener<Device> l) {
        this.graphListeners.add(l);
    }

    public void removeGraphListener(GraphMouseListener<Device> l) {
        this.graphListeners.remove(l);
    }

    @Override
    public void graphClicked(Device v, MouseEvent me) {
        for (GraphMouseListener<Device> l : this.graphListeners) {
            try {
                l.graphClicked(v, me);
            }
            catch (Exception e) {
                Logger.error("Unable to notify graphListener", e);
            }
        }
    }

    @Override
    public void graphPressed(Device v, MouseEvent me) {
        for (GraphMouseListener<Device> l : this.graphListeners) {
            try {
                l.graphPressed(v, me);
            }
            catch (Exception e) {
                Logger.error("Unable to notify graphListener", e);
            }
        }
    }

    @Override
    public void graphReleased(Device v, MouseEvent me) {
        for (GraphMouseListener<Device> l : this.graphListeners) {
            try {
                l.graphReleased(v, me);
            }
            catch (Exception e) {
                Logger.error("Unable to notify graphListener", e);
            }
        }
    }

    public static Action getPickingModeSetter() {
        return new AbstractAction(Lang.getNoHTML("map.pick"), Icons.get("cursor_pick")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (currentTab != null) {
                    currentTab.setEditMode(ModalGraphMouse.Mode.PICKING);
                }
            }
        };
    }

    public static Action getEditingModeSetter() {
        return new AbstractAction(Lang.getNoHTML("map.edit"), Icons.get("cursor_edit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (currentTab != null) {
                    currentTab.setEditMode(ModalGraphMouse.Mode.EDITING);
                }
            }
        };
    }

    public static Action getTransformingModeSetter() {
        return new AbstractAction(Lang.getNoHTML("map.transform"), Icons.get("cursor_move")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (currentTab != null) {
                    currentTab.setEditMode(ModalGraphMouse.Mode.TRANSFORMING);
                }
            }
        };
    }

    public static Action getZoomPlus() {
        return new AbstractAction(Lang.getNoHTML("map.zoomin"), Icons.get("zoom_in")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (currentTab != null) {
                    scaler.scale(currentTab.vv, Settings.getFloat("mapview.zoom.click", 1.5f), currentTab.vv.getCenter());
                }
            }
        };
    }

    public static Action getZoomMinus() {
        return new AbstractAction(Lang.getNoHTML("map.zoomout"), Icons.get("zoom_out")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (currentTab != null) {
                    scaler.scale(currentTab.vv, 1.0f / Settings.getFloat("mapview.zoom.click", 1.5f), currentTab.vv.getCenter());
                }
            }
        };
    }

    public static Action getZoomReset() {
        return new AbstractAction(Lang.getNoHTML("map.zoomreset"), Icons.get("zoom_reset")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (currentTab != null) {
                    scaler.reset(currentTab.vv);
                }
            }
        };
    }

    public static Action getZoomTo(Device device) {
        return new AbstractAction(Lang.getNoHTML("map.zoomto"), Icons.get("zoom_reset")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (currentTab != null) {
                    Point2D point2D = currentTab.vv.getCenter();
                }
            }
        };
    }

    public static Action getTest() {
        final Transformer<Connection, Double> transformer = arg0 -> arg0.getBandwidth();
        return new AbstractAction(Lang.get("test"), Icons.get("add")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MinimumSpanningForest2<Device, Connection> prim = new MinimumSpanningForest2<Device, Connection>(currentTab.map, new DelegateForest(), DelegateTree.getFactory(), transformer);
                currentTab.vv.setGraphLayout(new BalloonLayout<Device, Connection>(prim.getForest()));
            }
        };
    }

    public static List<Action> getLayoutTransformerActions() {
        List<Class> layouts = Arrays.asList(CircleLayout.class, FRLayout.class, ISOMLayout.class, KKLayout.class, SpringLayout2.class, GridGraphLayout.class, StaticLayout.class);
        ArrayList<Action> actions = new ArrayList<Action>(layouts.size());
        layouts.forEach(c -> actions.add(new AbstractAction(c.getSimpleName(), (Class)c){
            final /* synthetic */ Class val$c;
            {
                this.val$c = clazz;
                super(name);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                TabPanel.setLayout(this.val$c);
            }
        }));
        return actions;
    }

    public static void setLayout(final Class<Layout<Device, Connection>> layout) {
        if (currentTab == null) {
            return;
        }
        final Map map = TabPanel.currentTab.map;
        final VisualizationViewer<Device, Connection> vv = TabPanel.currentTab.vv;
        final Layout<Device, Connection> oldLayout = map.getGraphLayout();
        try {
            Layout<Device, Connection> o;
            Class<Layout<Device, Connection>> layoutC = layout;
            Constructor<Layout<Device, Connection>> constructor = layoutC.getConstructor(Graph.class);
            final Layout<Device, Connection> newLayout = o = constructor.newInstance(map);
            newLayout.setInitializer(vv.getGraphLayout());
            newLayout.setSize(vv.getSize());
            map.getHistory().execute(new Command(){

                @Override
                public Object undo() {
                    map.setLayout(oldLayout);
                    new Animator(new LayoutTransition(vv, newLayout, oldLayout)).start();
                    vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
                    vv.repaint();
                    return null;
                }

                @Override
                public Object redo() {
                    map.setLayout(newLayout);
                    new Animator(new LayoutTransition(vv, oldLayout, newLayout)).start();
                    vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
                    vv.repaint();
                    return null;
                }

                @Override
                public String toString() {
                    return Lang.getNoHTML("command.set.layout") + ": " + layout.getSimpleName();
                }
            });
        }
        catch (Exception e) {
            Logger.error("Unable to set new layout " + layout.getSimpleName(), e);
        }
    }

    public static TabComponent getCurrentTab() {
        return currentTab;
    }

    public static void addEditModeListener(EditModeListener listener) {
        editModeListeners.add(listener);
    }

    public static void removeEditModeListener(EditModeListener listener) {
        editModeListeners.remove(listener);
    }

    static {
        editModeListeners = new ArrayList<EditModeListener>();
    }

    private class ClosableTabHeader
    extends JPanel {
        private static final long serialVersionUID = -8130758834224431426L;
        private JButton label;
        private JButton close;

        public ClosableTabHeader(Map map) {
            super(new BorderLayout());
            this.setName(map.getFilePath() + "///" + Math.random());
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.setBackground(new Color(0, 0, 0, 0));
            this.label = new JButton(map.getFileName(), Icons.get("jnetmap_small")){
                {
                    super(text, icon);
                    this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
                    this.setContentAreaFilled(false);
                    this.setFocusable(false);
                }
            };
            this.label.addActionListener(e -> {
                TabPanel.this.setSelectedIndex(TabPanel.this.getTabIndex(this.getName()));
                this.setLabel(map.getFileName() + (map.isSaved() ? "" : "*"));
            });
            this.close = new JButton(Icons.get("close")){
                {
                    super(icon);
                    this.setPreferredSize(new Dimension(16, 16));
                    this.setContentAreaFilled(false);
                    this.setFocusable(false);
                }
            };
            this.close.addActionListener(e -> TabPanel.this._this.closeTab(this.getName()));
            this.add((Component)this.label, "Center");
            this.add((Component)this.close, "East");
            this.setToolTipText(map.getFilePath());
            map.addMapListener(e -> this.setLabel(map.getFileName() + (map.isSaved() ? "" : "*")));
        }

        public void setLabel(String text) {
            this.label.setText(text);
        }

        @Override
        public void setToolTipText(String text) {
            super.setToolTipText(text);
            this.label.setToolTipText(text);
        }
    }

    public class TabComponent
    extends GraphZoomScrollPane {
        Map map;
        MapGraphMouse mouse;
        VisualizationViewer<Device, Connection> vv;
        ModalGraphMouse.Mode editMode;

        public TabComponent(Map map, MapGraphMouse mouse, VisualizationViewer<Device, Connection> vv) {
            super(vv);
            this.editMode = ModalGraphMouse.Mode.PICKING;
            this.map = map;
            this.mouse = mouse;
            this.vv = vv;
        }

        public void setEditMode(ModalGraphMouse.Mode mode) {
            this.editMode = mode;
            this.mouse.setMode(mode);
            editModeListeners.forEach(eml -> eml.editModeChanged(currentTab.editMode));
        }
    }
}

