/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.components;

import ch.rakudave.jnetmap.controller.Controller;
import ch.rakudave.jnetmap.controller.command.Command;
import ch.rakudave.jnetmap.controller.command.CommandHistory;
import ch.rakudave.jnetmap.controller.command.CommandListener;
import ch.rakudave.jnetmap.model.Connection;
import ch.rakudave.jnetmap.model.CurrentMapListener;
import ch.rakudave.jnetmap.model.Map;
import ch.rakudave.jnetmap.model.device.Host;
import ch.rakudave.jnetmap.model.factories.ConnectionFactory;
import ch.rakudave.jnetmap.model.factories.DeviceFactory;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.Tuple;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.components.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class EditPanel
extends JPanel
implements CurrentMapListener,
CommandListener {
    private JList icons;
    private JComboBox connectionType;
    private JTextField bandwidth;
    private Vector<Tuple<String, ImageIcon>> types;
    private JList<Command> history;
    private int historyIndex;
    private CommandHistory commandHistory;

    public EditPanel(Frame owner) {
        this.setLayout(new GridLayout(2, 1, 5, 5));
        JPanel iconPanel = new JPanel(new BorderLayout(5, 5));
        iconPanel.setBorder(BorderFactory.createTitledBorder(Lang.getNoHTML("command.add.device")));
        this.types = new Vector();
        for (String t : Host.defaultTypes) {
            if ("Other".endsWith(t)) continue;
            this.types.add(new Tuple<String, ImageIcon>(t, Icons.getCisco(t.toLowerCase())));
        }
        for (int i = 0; i < Settings.getInt("type.custom.count", 0); ++i) {
            this.types.add(new Tuple<String, ImageIcon>("Other", Icons.fromBase64(Settings.get("type.custom." + i, ""))));
        }
        this.icons = new JList<Tuple<String, ImageIcon>>(this.types);
        this.icons.setCellRenderer(new IconCellRenderer());
        this.icons.setSelectedValue("Workstation", true);
        this.icons.setSelectionMode(1);
        this.icons.setLayoutOrientation(2);
        this.icons.setVisibleRowCount(-1);
        this.icons.addListSelectionListener(listSelectionEvent -> {
            Tuple tuple = (Tuple)this.icons.getSelectedValue();
            DeviceFactory.setType((String)tuple.getFirst());
            if ("Other".equals(tuple.getFirst())) {
                DeviceFactory.setIcon(((ImageIcon)tuple.getSecond()).getDescription());
            }
            TabPanel.getEditingModeSetter().actionPerformed(null);
        });
        this.icons.setBackground(new Color(this.getBackground().getRGB()));
        JPanel bottom = new JPanel(new GridLayout(0, 2, 5, 5));
        this.connectionType = new JComboBox<Connection.Type>(Connection.Type.values());
        this.connectionType.setSelectedItem((Object)Connection.Type.Ethernet);
        this.connectionType.addActionListener(actionEvent -> ConnectionFactory.setType((Connection.Type)((Object)((Object)this.connectionType.getSelectedItem()))));
        JPanel inner = new JPanel(new GridLayout(0, 2, 5, 5));
        this.bandwidth = new JTextField("100");
        this.bandwidth.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    double d = Double.valueOf(EditPanel.this.bandwidth.getText());
                    ConnectionFactory.setSpeed(d);
                    Logger.trace("Default bandwidth set to " + d);
                }
                catch (Exception e2) {
                    Logger.trace("Unable to convert to double: " + EditPanel.this.bandwidth.getText(), e2);
                    EditPanel.this.bandwidth.setText("100");
                }
            }
        });
        inner.add(this.bandwidth);
        inner.add(new JLabel("Mb/s"));
        bottom.add(this.connectionType);
        bottom.add(inner);
        iconPanel.add((Component)new JScrollPane(this.icons), "Center");
        iconPanel.add((Component)bottom, "South");
        this.history = new JList();
        this.history.setBorder(BorderFactory.createTitledBorder(Lang.getNoHTML("historypanel.title")));
        this.history.setSelectionMode(0);
        this.history.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditPanel.this.history.setEnabled(false);
                int selectedIndex = EditPanel.this.history.getSelectedIndex();
                Logger.error("history: " + EditPanel.this.historyIndex);
                Logger.error("selected: " + selectedIndex);
                if (EditPanel.this.historyIndex < selectedIndex) {
                    for (int i = EditPanel.this.historyIndex; i < selectedIndex; ++i) {
                        Logger.error("undo: " + i);
                        if (!EditPanel.this.commandHistory.canUndo()) continue;
                        EditPanel.this.commandHistory.undo();
                    }
                } else if (EditPanel.this.historyIndex > selectedIndex) {
                    for (int i = EditPanel.this.historyIndex; i > selectedIndex; --i) {
                        Logger.error("redo: " + i);
                        if (!EditPanel.this.commandHistory.canRedo()) continue;
                        EditPanel.this.commandHistory.redo();
                    }
                }
                EditPanel.this.historyIndex = selectedIndex;
                EditPanel.this.history.setEnabled(true);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        Controller.addCurrentMapListener(this);
        this.add(iconPanel);
        this.add(new JScrollPane(this.history, 20, 31));
    }

    @Override
    public void mapChanged(Map map) {
        if (this.commandHistory != null) {
            this.commandHistory.removeCommandListener(this);
        }
        this.commandHistory = map.getHistory();
        this.commandHistory.addCommandListener(this);
        this.history.setListData(this.commandHistory.getCommands());
        this.history.setSelectedIndex(this.commandHistory.getRedoSize());
        this.historyIndex = this.commandHistory.getRedoSize();
    }

    @Override
    public void executed(Command command) {
        this.history.setListData(this.commandHistory.getCommands());
        this.history.setSelectedIndex(0);
        this.historyIndex = 0;
    }

    @Override
    public void undone(Command command) {
        if (this.commandHistory.canUndo()) {
            this.history.setSelectedIndex(this.commandHistory.getRedoSize());
            this.historyIndex = this.commandHistory.getRedoSize();
        } else {
            this.history.setSelectedIndices(new int[0]);
            this.historyIndex = 0;
        }
    }

    @Override
    public void redone(Command command) {
        this.history.setSelectedIndex(this.commandHistory.getRedoSize());
    }

    private class IconCellRenderer
    extends DefaultListCellRenderer {
        private IconCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return label;
            }
            label.setText(null);
            label.setToolTipText((String)((Tuple)value).getFirst());
            label.setIcon((Icon)((Tuple)value).getSecond());
            label.setHorizontalAlignment(0);
            label.setVerticalAlignment(0);
            return label;
        }
    }
}

