/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view;

import ch.rakudave.jnetmap.controller.Controller;
import ch.rakudave.jnetmap.controller.Listeners;
import ch.rakudave.jnetmap.model.Map;
import ch.rakudave.jnetmap.plugins.extensions.SidebarPlugin;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.ISidebar;
import ch.rakudave.jnetmap.view.IStatusbar;
import ch.rakudave.jnetmap.view.IView;
import ch.rakudave.jnetmap.view.components.EditPanel;
import ch.rakudave.jnetmap.view.components.InfoPanel;
import ch.rakudave.jnetmap.view.components.LayerPanel;
import ch.rakudave.jnetmap.view.components.MenuBar;
import ch.rakudave.jnetmap.view.components.StatusBar;
import ch.rakudave.jnetmap.view.components.TabPanel;
import ch.rakudave.jnetmap.view.components.ToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;

public class MapView
extends JFrame
implements IView,
ISidebar {
    private JTabbedPane sideBar;
    private TabPanel mapPanel;
    private JSplitPane splitPane;
    private IStatusbar statusBar;

    public MapView() {
        super("jNetMap");
        Logger.info("Loading GUI");
        this.setLayout(new BorderLayout());
        if (Settings.getBoolean("mapview.remember.wh", true)) {
            this.setPreferredSize(new Dimension(Settings.getInt("mapview.geom.w", 750), Settings.getInt("mapview.geom.h", 550)));
        } else {
            this.setPreferredSize(new Dimension(750, 550));
        }
        if (Settings.getBoolean("mapview.remember.xy", true)) {
            this.setLocation(Settings.getInt("mapview.geom.x", 10), Settings.getInt("mapview.geom.y", 10));
        } else {
            this.setLocation(10, 10);
        }
        this.setDefaultCloseOperation(0);
        this.setIconImage(Icons.get("jnetmap").getImage());
        this.addWindowListener(Listeners.windowQuitListener());
        this.mapPanel = new TabPanel(1, 1, this);
        this.sideBar = new JTabbedPane(1, 0);
        this.splitPane = new JSplitPane(1, true, this.mapPanel, this.sideBar);
        this.splitPane.setDividerSize(3);
        this.setSidebarVisible(Settings.getBoolean("mapview.sidebar.visible", true));
        this.add((Component)this.splitPane, "Center");
        InfoPanel info = new InfoPanel(this);
        this.mapPanel.addGraphListener(info);
        this.addSideTab(Lang.get("infopanel.title"), Icons.get("info"), info, Lang.get("infopanel.tooltip"));
        this.addSideTab(Lang.get("menu.edit"), Icons.get("cursor_edit"), new EditPanel(this), "");
        if (Settings.getBoolean("features.experimental", false)) {
            this.addSideTab(Lang.get("layer.tab"), Icons.get("folder"), new LayerPanel(this), "");
        }
        for (SidebarPlugin p : Controller.getPluginManager().getExtensions(SidebarPlugin.class)) {
            try {
                this.addSideTab(p.getTabTitle(), p.getIcon(), p.getPanel(), p.getToolTip());
                this.mapPanel.addGraphListener(p);
            }
            catch (Exception e) {
                Logger.error("Unable to load plugin " + p, e);
            }
        }
        this.add((Component)ToolBar.getInstance(), Settings.get("toolbar.location", "North"));
        this.statusBar = StatusBar.getInstance();
        this.add((Component)((Object)this.statusBar), "South");
        this.setJMenuBar(new MenuBar(this));
        this.pack();
        double sidebarRatio = Settings.getDouble("mapview.sidebar.ratio", 0.8);
        if (sidebarRatio < 0.0 || sidebarRatio > 1.0) {
            sidebarRatio = 0.8;
        }
        this.splitPane.setDividerLocation(sidebarRatio);
        this.splitPane.setResizeWeight(sidebarRatio);
        this.setExtendedState(Settings.getInt("view.extendedstate", 0));
        this.setVisible(true);
    }

    @Override
    public void addSideTab(String title, Icon icon, Component tab, String tip) {
        this.sideBar.addTab(title, icon, tab, tip);
    }

    @Override
    public boolean isSidebarVisible() {
        return this.splitPane.getRightComponent() != null;
    }

    @Override
    public void openMap(Map map) {
        this.mapPanel.openTab(map);
    }

    @Override
    public void removeSideTab(JPanel tab) {
        this.sideBar.remove(tab);
    }

    @Override
    public void saveViewProperties() {
        try {
            Component[] comps;
            Settings.put("mapview.geom.x", this.getLocationOnScreen().x);
            Settings.put("mapview.geom.y", this.getLocationOnScreen().y);
            Settings.put("mapview.geom.w", this.getWidth());
            Settings.put("mapview.geom.h", this.getHeight());
            Container content = this.getContentPane();
            BorderLayout layout = (BorderLayout)content.getLayout();
            for (Component c : comps = content.getComponents()) {
                if (!(c instanceof JToolBar)) continue;
                Settings.put("toolbar.location", layout.getConstraints(c).toString());
            }
            Settings.put("mapview.sidebar.visible", this.isSidebarVisible());
            if (this.isSidebarVisible()) {
                double ratio = (4.0 + (double)this.splitPane.getDividerLocation()) / (double)this.getWidth();
                Settings.put("mapview.sidebar.ratio", ratio);
            }
        }
        catch (Exception e) {
            Logger.warn("Failed to save view properties", e);
        }
    }

    @Override
    public void setSidebarVisible(boolean visible) {
        this.splitPane.setRightComponent(visible ? this.sideBar : null);
    }

    @Override
    public void setWindowTitle(String title) {
        super.setTitle("jNetMap - " + title);
    }
}

