/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.util;

import ch.rakudave.jnetmap.controller.Controller;
import ch.rakudave.jnetmap.model.IF.NetworkIF;
import ch.rakudave.jnetmap.model.IF.PhysicalIF;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.components.InterfaceSelector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.FontUIResource;

public class SwingHelper {
    public static void centerTo(Window parent, Window child) {
        if (parent == null || child == null) {
            return;
        }
        Point parentLocation = parent.getLocationOnScreen();
        child.setLocation(parentLocation.x + parent.getWidth() / 2 - child.getWidth() / 2, parentLocation.y + parent.getHeight() / 2 - child.getHeight() / 2);
    }

    public static JButton createAlignedButton(Action a) {
        JButton b = new JButton(a);
        b.setHorizontalAlignment(10);
        return b;
    }

    public static File openDialog(Component owner, FileNameExtensionFilter filter) {
        Object[] o = SwingHelper.openDialog(owner, filter, false);
        return o == null ? null : (File)o[0];
    }

    public static Object[] openDialog(Component owner, FileNameExtensionFilter filter, boolean withPass) {
        JFileChooser chooser = new JFileChooser();
        if (filter != null) {
            chooser.setFileFilter(filter);
        }
        Object[] o = SwingHelper.getAccessory("");
        if (withPass) {
            chooser.setAccessory((JComponent)o[0]);
        }
        if (chooser.showOpenDialog(owner) != 0) {
            return null;
        }
        File f = chooser.getSelectedFile();
        if (!f.canRead()) {
            return null;
        }
        return new Object[]{f, String.valueOf(((JPasswordField)o[1]).getPassword())};
    }

    public static File saveDialog(Component owner, FileNameExtensionFilter filter) {
        Object[] o = SwingHelper.saveDialog(owner, filter, false);
        return o == null ? null : (File)o[0];
    }

    public static Object[] saveDialog(Component owner, FileNameExtensionFilter filter, boolean withPass) {
        File f;
        JFileChooser chooser = new JFileChooser();
        if (filter != null) {
            chooser.setFileFilter(filter);
        }
        Object[] o = SwingHelper.getAccessory("");
        if (withPass) {
            chooser.setAccessory((JComponent)o[0]);
        }
        if (chooser.showSaveDialog(owner) != 0) {
            return null;
        }
        String path = chooser.getSelectedFile().getPath();
        if (filter != null && filter.getExtensions().length > 0 && !path.matches("(.*)." + filter.getExtensions()[0])) {
            path = path + "." + filter.getExtensions()[0];
        }
        if (!(f = new File(path)).exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                Logger.error("Failed to create file at " + f.getAbsolutePath(), e);
                return null;
            }
        }
        return new Object[]{f, String.valueOf(((JPasswordField)o[1]).getPassword())};
    }

    public static String interfaceSelector(Device d) {
        return SwingHelper.interfaceSelector(d, false);
    }

    public static String interfaceSelector(Device d, boolean byName) {
        List<NetworkIF> ifs = d.getInterfaces();
        if (ifs.size() < 1) {
            return null;
        }
        Vector<String> addresses = new Vector<String>();
        for (NetworkIF nif : ifs) {
            if (!(nif instanceof PhysicalIF)) continue;
            addresses.add(byName ? nif.getAddress().getHostName() : nif.getAddress().getHostAddress());
        }
        if (addresses.isEmpty()) {
            return null;
        }
        if (addresses.size() == 1) {
            return (String)addresses.get(0);
        }
        InterfaceSelector is = new InterfaceSelector((Frame)((Object)Controller.getView()), d, addresses);
        return is.getSelected();
    }

    private static Object[] getAccessory(String password) {
        JPanel p = new JPanel(new BorderLayout());
        p.setLayout(new BoxLayout(p, 3));
        JPasswordField pass = new JPasswordField(password);
        pass.setEnabled(false);
        pass.setMaximumSize(new Dimension(200, 30));
        JCheckBox useCrypto = new JCheckBox(Lang.get("action.password"));
        useCrypto.addActionListener(e -> {
            pass.setEnabled(useCrypto.isSelected());
            if (!useCrypto.isSelected()) {
                pass.setText("");
            }
        });
        p.add(Box.createVerticalGlue());
        p.add(useCrypto);
        p.add(pass);
        p.add(Box.createVerticalGlue());
        return new Object[]{p, pass};
    }

    public static String passwordPrompt() {
        JPasswordField pwd = new JPasswordField(25);
        int action = JOptionPane.showConfirmDialog(null, pwd, Lang.getNoHTML("action.password") + ":", 2);
        if (action < 0) {
            return null;
        }
        return new String(pwd.getPassword());
    }

    public static JEditorPane createHtmlLabel(String text) {
        JEditorPane ep = new JEditorPane();
        ep.setContentType("text/html");
        ep.setText(text);
        ep.setBackground(new Color(0, 0, 0, 0));
        ep.setEditable(false);
        ep.setFocusable(false);
        return ep;
    }

    public static FontUIResource getViewFont() {
        return new FontUIResource(Settings.get("view.font.name", "SansSerif"), 0, Settings.getInt("view.font.size", 12));
    }

    public static void setUIFont(FontUIResource font) {
        if (font == null) {
            font = SwingHelper.getViewFont();
        }
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, font);
        }
    }

    private SwingHelper() {
    }
}

