/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.common;

import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDalvikInstruction;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDalvikInstructionParameter;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexClass;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexCodeItem;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethodData;
import com.pnfsoftware.jeb.util.format.Formatter;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SignatureHandler {
    public static String generateTightHashcode(IDexCodeItem ci) {
        byte[] h;
        StringBuilder sig = new StringBuilder();
        for (IDalvikInstruction insn : ci.getInstructions()) {
            sig.append(insn.getMnemonic()).append(":");
            for (IDalvikInstructionParameter param : insn.getParameters()) {
                int pt = param.getType();
                sig.append(pt).append(',');
                if (pt == 2 || pt == 0) {
                    sig.append("x,");
                    continue;
                }
                sig.append(param.getValue()).append(',');
            }
            sig.append(" ");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            h = md.digest(sig.toString().getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return Formatter.byteArrayToHexString((byte[])h).toLowerCase();
    }

    public static String generateLooseHashcode(IDexCodeItem ci) {
        byte[] h;
        StringBuilder sig = new StringBuilder();
        for (IDalvikInstruction insn : ci.getInstructions()) {
            if (insn.getMnemonic().contains("move") || insn.getMnemonic().contains("const")) continue;
            boolean flag = false;
            if (insn.getMnemonic().contains("goto")) {
                sig.append("goto:");
            } else if (insn.getMnemonic().contains("/")) {
                sig.append(insn.getMnemonic().split("/")[0]).append(":");
                flag = true;
            } else {
                sig.append(insn.getMnemonic()).append(":");
            }
            for (IDalvikInstructionParameter param : insn.getParameters()) {
                int pt = param.getType();
                sig.append(pt).append(',');
            }
            if (flag) {
                sig.append(insn.getParameters()[0].getType()).append(',');
            }
            sig.append(" ");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            h = md.digest(sig.toString().getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return Formatter.byteArrayToHexString((byte[])h).toLowerCase();
    }

    public static void loadAllCallerLists(IDexUnit unit, Map<Integer, Map<Integer, Integer>> allCallerLists, Map<Integer, String> matchedClasses, Map<Integer, String> matchedMethods) {
        allCallerLists.clear();
        List classes = unit.getClasses();
        if (classes == null || classes.size() == 0) {
            return;
        }
        for (IDexClass eClass : classes) {
            List methods = eClass.getMethods();
            if (methods == null || methods.size() == 0 || matchedClasses != null && !matchedClasses.containsKey(eClass.getIndex())) continue;
            for (IDexMethod m : methods) {
                if (!m.isInternal() || matchedMethods != null && !matchedMethods.containsKey(m.getIndex())) continue;
                SignatureHandler.loadCallerList(unit, allCallerLists, m);
            }
        }
    }

    public static void loadAllCallerLists(IDexUnit unit, Map<Integer, Map<Integer, Integer>> allCallerLists) {
        allCallerLists.clear();
        List classes = unit.getClasses();
        if (classes == null || classes.size() == 0) {
            return;
        }
        for (IDexClass eClass : classes) {
            List methods = eClass.getMethods();
            if (methods == null || methods.size() == 0) continue;
            for (IDexMethod m : methods) {
                if (!m.isInternal()) continue;
                SignatureHandler.loadCallerList(unit, allCallerLists, m);
            }
        }
    }

    public static void loadCallerList(IDexUnit unit, Map<Integer, Map<Integer, Integer>> allCallerLists, IDexMethod m) {
        IDexMethodData md = m.getData();
        if (md == null) {
            return;
        }
        IDexCodeItem ci = md.getCodeItem();
        if (ci == null) {
            return;
        }
        SignatureHandler.loadCallerList(unit, allCallerLists, ci, m);
    }

    public static void loadCallerList(IDexUnit unit, Map<Integer, Map<Integer, Integer>> allCallerLists, IDexCodeItem ci, IDexMethod m) {
        for (IDalvikInstruction insn : ci.getInstructions()) {
            if (!insn.getMnemonic().contains("invoke")) continue;
            for (IDalvikInstructionParameter param : insn.getParameters()) {
                int paraValue;
                int poolIndex;
                if (param.getType() != 2 || (poolIndex = insn.getParameterFirstIndexType()) != 19 || (paraValue = (int)param.getValue()) > unit.getMethods().size()) continue;
                Map<Integer, Integer> temp = allCallerLists.get(paraValue);
                int methodIndex = m.getIndex();
                if (temp != null) {
                    Integer times = temp.get(methodIndex);
                    if (times != null) {
                        temp.put(methodIndex, times + 1);
                        continue;
                    }
                    temp.put(methodIndex, 1);
                    continue;
                }
                HashMap<Integer, Integer> temp1 = new HashMap<Integer, Integer>();
                temp1.put(methodIndex, 1);
                allCallerLists.put(paraValue, temp1);
            }
        }
    }

    public static File getSignaturesFolder(IEnginesContext engctx) throws IOException {
        String pluginFolderPath = engctx.getDataProvider().getPluginStore().getStoreLocation();
        if (pluginFolderPath == null) {
            throw new IOException("Cannot retrieve the plugins folder!");
        }
        File dir = new File(pluginFolderPath, "android_sigs");
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IOException("Cannot create the Android Signatures folder: " + dir.getPath());
            }
        } else if (!dir.isDirectory()) {
            throw new IOException("The Android Signatures folder location is occupied: " + dir.getPath());
        }
        return dir;
    }
}

