/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.libravm;

import com.pnf.libravm.FunctionDef;
import com.pnf.libravm.Libra;
import com.pnf.libravm.LibraInstruction;
import com.pnf.libravm.LibraInstructionOperand;
import com.pnf.libravm.LibraUnit;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.processor.AbstractProcessor;
import com.pnfsoftware.jeb.core.units.code.asm.processor.ProcessorException;
import com.pnfsoftware.jeb.util.io.ByteArray;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@Ser
public class LibraBytecodeParser
extends AbstractProcessor<LibraInstruction> {
    private static final ILogger logger = GlobalLog.getLogger(LibraBytecodeParser.class);
    @SerId(value=1)
    LibraUnit unit;

    public LibraBytecodeParser() {
        this(null);
    }

    public LibraBytecodeParser(LibraUnit unit) {
        super(1, 64, Endianness.LITTLE_ENDIAN, 1);
        this.unit = unit;
    }

    public List<LibraInstruction> parseFunction(int fh_index, int insncnt, int offset, int endOffset) throws ProcessorException {
        if (this.unit == null) {
            throw new IllegalStateException("Reserved usage");
        }
        int insize = this.unit.getFunctionSignature(fh_index).getParamTokens().size();
        int outsize = this.unit.getFunctionSignature(fh_index).getReturnTokens().size();
        logger.i("=> Function: %s (fh=%d): in=%d, out=%d", new Object[]{this.unit.getFunctionName(fh_index), fh_index, insize, outsize});
        int start = offset;
        ArrayList<LibraInstruction> insnlist = new ArrayList<LibraInstruction>(insncnt);
        ArrayList<Integer> branchInstructionsIndices = new ArrayList<Integer>();
        int stkdelta = 0;
        for (int i = 0; i < insncnt; ++i) {
            LibraInstruction insn = (LibraInstruction)this.parseAt(this.unit.rawbytes, offset, endOffset);
            insn.preExecStackDelta = stkdelta;
            insn.indexInFunction = i;
            insn.offsetInFunction = offset - start;
            insnlist.add(insn);
            Libra.OpcodeDef opcode = insn.getOpcode();
            int popcnt = opcode.getPopCount();
            int pushcnt = opcode.getPushCount();
            switch (opcode) {
                case RET: {
                    popcnt = outsize;
                    break;
                }
                case PACK: {
                    int sd_index = insn.getOperandAsIndex();
                    popcnt = this.unit.getStructFieldCount(sd_index);
                    break;
                }
                case UNPACK: {
                    int sd_index = insn.getOperandAsIndex();
                    pushcnt = this.unit.getStructFieldCount(sd_index);
                    break;
                }
                case CALL: {
                    int target_fh_index = insn.getOperandAsIndex();
                    popcnt = this.unit.getFunctionSignature(target_fh_index).getParamTokens().size();
                    pushcnt = this.unit.getFunctionSignature(target_fh_index).getReturnTokens().size();
                    break;
                }
            }
            if (popcnt < 0 || pushcnt < 0) {
                throw new RuntimeException("TBI: stkdelta for " + (Object)((Object)opcode));
            }
            if ((stkdelta -= popcnt) < 0) {
                throw new RuntimeException("Illegal stack delta: " + stkdelta);
            }
            insn.postExecStackDelta = stkdelta += pushcnt;
            switch (insn.getOpcode()) {
                case BRANCH: 
                case BR_FALSE: 
                case BR_TRUE: {
                    branchInstructionsIndices.add(i);
                    break;
                }
            }
            logger.i("#%d/%04X/%04X: %s", new Object[]{i, offset, offset - start, insn.format(offset)});
            if ((offset += insn.getSize()) <= endOffset) continue;
            throw new ArrayIndexOutOfBoundsException("Bytecode parsing is passing the buffer boundary");
        }
        if (stkdelta != 0) {
            throw new RuntimeException("Unepxected non-zero stack delta at routine end: " + stkdelta);
        }
        Iterator iterator = branchInstructionsIndices.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            LibraInstruction insn = (LibraInstruction)insnlist.get(i);
            int targetInstructionIndex = (Integer)insn.getOperands()[0].getObject();
            insn.targetDelta = ((LibraInstruction)insnlist.get((int)targetInstructionIndex)).offsetInFunction - insn.offsetInFunction;
        }
        return insnlist;
    }

    public LibraInstruction parseAt(IVirtualMemory vm, long address) throws ProcessorException {
        if (this.unit == null) {
            throw new IllegalStateException("Reserved usage");
        }
        for (FunctionDef e : this.unit.getInternalFunctions()) {
            if (address < e.mappedAddress || address >= e.mappedAddress + (long)e.mappedSize) continue;
            int wantedOffset = (int)(address - e.mappedAddress);
            int currentOffset = 0;
            for (LibraInstruction insn : e.getCode().getInstructions()) {
                if (currentOffset == wantedOffset) {
                    return insn;
                }
                currentOffset += insn.getSize();
            }
        }
        throw new ProcessorException(String.format("Cannot find preparsed instruction at address 0x%X", address));
    }

    protected LibraInstruction parseAtInternal(byte[] bytes, int index, int end) throws ProcessorException {
        ByteArray ba = new ByteArray(bytes, index);
        int b = ba.u8();
        Libra.OpcodeDef opdef = Libra.OpcodeDef.fromValue(b);
        LibraInstruction insn = new LibraInstruction(opdef);
        LibraInstructionOperand opnd = null;
        Libra.OpndType opndtype = opdef.getOperandType();
        switch (opndtype) {
            case None: {
                break;
            }
            case Branch: {
                int target = ba.u16();
                opnd = new LibraInstructionOperand(opndtype, target);
                break;
            }
            case ImmUint64: {
                long cst = ba.i64();
                opnd = new LibraInstructionOperand(opndtype, cst);
                break;
            }
            case IdxLocal: {
                int local_index = ba.u8();
                opnd = new LibraInstructionOperand(opndtype, local_index);
                break;
            }
            case IdxAddress: 
            case IdxByteArray: 
            case IdxString: 
            case IdxFuncHandle: 
            case IdxFieldDef: 
            case IdxStructDef: {
                int idx = ba.varu16();
                opnd = new LibraInstructionOperand(opndtype, idx);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported operand type " + (Object)((Object)opndtype) + " (used by opcode " + (Object)((Object)opdef) + " )");
            }
        }
        insn.code = Arrays.copyOfRange(bytes, index, ba.position());
        insn.opnds = opnd == null ? new LibraInstructionOperand[0] : new LibraInstructionOperand[]{opnd};
        return insn;
    }
}

