/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.projection;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;

public class ProjectionAnnotation
extends Annotation
implements IAnnotationPresentation {
    public static final String TYPE = "org.eclipse.projection";
    private static final int COLOR = 15;
    private static Image fgCollapsedImage;
    private static Image fgExpandedImage;
    private boolean fIsCollapsed = false;
    private boolean fIsRangeIndication = false;

    public ProjectionAnnotation() {
        this(false);
    }

    public ProjectionAnnotation(boolean isCollapsed) {
        super(TYPE, false, null);
        this.fIsCollapsed = isCollapsed;
    }

    public void setRangeIndication(boolean rangeIndication) {
        this.fIsRangeIndication = rangeIndication;
    }

    private void drawRangeIndication(GC gc, Canvas canvas, Rectangle r) {
        int height = Math.min(r.y + r.height - 3, canvas.getSize().y);
        gc.setForeground(canvas.getDisplay().getSystemColor(15));
        gc.setLineWidth(0);
        gc.drawLine(r.x + 4, r.y + 12, r.x + 4, height);
        gc.drawLine(r.x + 4, height, r.x + r.width - 3, height);
    }

    @Override
    public void paint(GC gc, Canvas canvas, Rectangle rectangle) {
        Image image = this.getImage(canvas.getDisplay());
        if (image != null) {
            ImageUtilities.drawImage(image, gc, canvas, rectangle, 0x1000000, 128);
            if (this.fIsRangeIndication) {
                FontMetrics fontMetrics = gc.getFontMetrics();
                int delta = (fontMetrics.getHeight() - image.getBounds().height) / 2;
                rectangle.y += delta;
                rectangle.height -= delta;
                this.drawRangeIndication(gc, canvas, rectangle);
            }
        }
    }

    @Override
    public int getLayer() {
        return 0;
    }

    private Image getImage(Display display) {
        this.initializeImages(display);
        return this.isCollapsed() ? fgCollapsedImage : fgExpandedImage;
    }

    private void initializeImages(Display display) {
        if (fgCollapsedImage == null) {
            ImageDescriptor descriptor = ImageDescriptor.createFromFile(ProjectionAnnotation.class, "images/collapsed.png");
            fgCollapsedImage = descriptor.createImage((Device)display);
            descriptor = ImageDescriptor.createFromFile(ProjectionAnnotation.class, "images/expanded.png");
            fgExpandedImage = descriptor.createImage((Device)display);
            display.disposeExec((Runnable)new DisplayDisposeRunnable());
        }
    }

    public boolean isCollapsed() {
        return this.fIsCollapsed;
    }

    public void markCollapsed() {
        this.fIsCollapsed = true;
    }

    public void markExpanded() {
        this.fIsCollapsed = false;
    }

    private static class DisplayDisposeRunnable
    implements Runnable {
        private DisplayDisposeRunnable() {
        }

        @Override
        public void run() {
            if (fgCollapsedImage != null) {
                fgCollapsedImage.dispose();
                fgCollapsedImage = null;
            }
            if (fgExpandedImage != null) {
                fgExpandedImage.dispose();
                fgExpandedImage = null;
            }
        }
    }
}

