/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.reconciler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.reconciler.AbstractReconciler;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilerExtension;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

public class Reconciler
extends AbstractReconciler
implements IReconcilerExtension {
    private Map<String, IReconcilingStrategy> fStrategies;
    private String fPartitioning = "__dftl_partitioning";

    public void setDocumentPartitioning(String partitioning) {
        Assert.isNotNull(partitioning);
        this.fPartitioning = partitioning;
    }

    @Override
    public String getDocumentPartitioning() {
        return this.fPartitioning;
    }

    public void setReconcilingStrategy(IReconcilingStrategy strategy, String contentType) {
        Assert.isNotNull(contentType);
        if (this.fStrategies == null) {
            this.fStrategies = new HashMap<String, IReconcilingStrategy>();
        }
        if (strategy == null) {
            this.fStrategies.remove(contentType);
        } else {
            this.fStrategies.put(contentType, strategy);
            if (strategy instanceof IReconcilingStrategyExtension && this.getProgressMonitor() != null) {
                IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)((Object)strategy);
                extension.setProgressMonitor(this.getProgressMonitor());
            }
        }
    }

    @Override
    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        Assert.isNotNull(contentType);
        if (this.fStrategies == null) {
            return null;
        }
        return this.fStrategies.get(contentType);
    }

    @Override
    protected void process(DirtyRegion dirtyRegion) {
        ITypedRegion[] regions;
        IRegion region = dirtyRegion;
        if (region == null) {
            region = new Region(0, this.getDocument().getLength());
        }
        ITypedRegion[] iTypedRegionArray = regions = this.computePartitioning(region.getOffset(), region.getLength());
        int n = regions.length;
        int n2 = 0;
        while (n2 < n) {
            ITypedRegion r = iTypedRegionArray[n2];
            IReconcilingStrategy s = this.getReconcilingStrategy(r.getType());
            if (s != null) {
                if (dirtyRegion != null) {
                    s.reconcile(dirtyRegion, r);
                } else {
                    s.reconcile(r);
                }
            }
            ++n2;
        }
    }

    @Override
    protected void reconcilerDocumentChanged(IDocument document) {
        if (this.fStrategies != null) {
            for (IReconcilingStrategy strategy : this.fStrategies.values()) {
                strategy.setDocument(document);
            }
        }
    }

    @Override
    public void setProgressMonitor(IProgressMonitor monitor) {
        super.setProgressMonitor(monitor);
        if (this.fStrategies != null) {
            for (IReconcilingStrategy strategy : this.fStrategies.values()) {
                if (!(strategy instanceof IReconcilingStrategyExtension)) continue;
                IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)((Object)strategy);
                extension.setProgressMonitor(monitor);
            }
        }
    }

    @Override
    protected void initialProcess() {
        ITypedRegion[] regions = this.computePartitioning(0, this.getDocument().getLength());
        ArrayList<String> contentTypes = new ArrayList<String>(regions.length);
        ITypedRegion[] iTypedRegionArray = regions;
        int n = regions.length;
        int n2 = 0;
        while (n2 < n) {
            ITypedRegion region = iTypedRegionArray[n2];
            String contentType = region.getType();
            if (!contentTypes.contains(contentType)) {
                contentTypes.add(contentType);
                IReconcilingStrategy s = this.getReconcilingStrategy(contentType);
                if (s instanceof IReconcilingStrategyExtension) {
                    IReconcilingStrategyExtension e = (IReconcilingStrategyExtension)((Object)s);
                    e.initialReconcile();
                }
            }
            ++n2;
        }
    }

    private ITypedRegion[] computePartitioning(int offset, int length) {
        ITypedRegion[] regions = null;
        try {
            regions = TextUtilities.computePartitioning(this.getDocument(), this.getDocumentPartitioning(), offset, length, false);
        }
        catch (BadLocationException badLocationException) {
            regions = new TypedRegion[]{};
        }
        return regions;
    }
}

