/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.jface.databinding.viewers.ViewerListProperty;
import org.eclipse.jface.internal.databinding.viewers.SelectionChangedListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionProviderMultipleSelectionProperty
extends ViewerListProperty {
    private final boolean isPostSelection;

    public SelectionProviderMultipleSelectionProperty(boolean isPostSelection) {
        this.isPostSelection = isPostSelection;
    }

    @Override
    public Object getElementType() {
        return Object.class;
    }

    @Override
    protected List doGetList(Object source) {
        ISelection selection = ((ISelectionProvider)source).getSelection();
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        return Collections.EMPTY_LIST;
    }

    protected void doSetList(Object source, List list, ListDiff diff) {
        this.doSetList(source, list);
    }

    @Override
    protected void doSetList(Object source, List list) {
        ((ISelectionProvider)source).setSelection(new StructuredSelection(list));
    }

    public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
        return new SelectionChangedListener(this, listener, this.isPostSelection);
    }

    public String toString() {
        return this.isPostSelection ? "IPostSelectionProvider.postSelection[]" : "ISelectionProvider.selection[]";
    }
}

