/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.viewers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;

public class ViewerLabelProvider
implements IViewerLabelProvider,
ILabelProvider {
    private List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();

    @Override
    public void updateLabel(ViewerLabel label, Object element) {
        label.setText(element.toString());
    }

    protected final void fireChangeEvent(Collection<?> changes) {
        ILabelProviderListener[] listenerArray;
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, changes.toArray());
        ILabelProviderListener[] iLabelProviderListenerArray = listenerArray = this.listeners.toArray(new ILabelProviderListener[this.listeners.size()]);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelProviderListener listener = iLabelProviderListenerArray[n2];
            try {
                listener.labelProviderChanged(event);
            }
            catch (Exception e) {
                Policy.getLog().log(new Status(4, "org.eclipse.core.databinding", e.getLocalizedMessage(), e));
            }
            ++n2;
        }
    }

    @Override
    public final Image getImage(Object element) {
        ViewerLabel label = new ViewerLabel("", null);
        this.updateLabel(label, element);
        return label.getImage();
    }

    @Override
    public final String getText(Object element) {
        ViewerLabel label = new ViewerLabel("", null);
        this.updateLabel(label, element);
        return label.getText();
    }

    @Override
    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void dispose() {
        this.listeners.clear();
    }

    @Override
    public final boolean isLabelProperty(Object element, String property) {
        return true;
    }

    @Override
    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }
}

