/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property;

import java.util.Map;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.databinding.property.map.MapProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.property.PropertyObservableUtil;

public class ValuePropertyDetailMap<S, M, K, V>
extends MapProperty<S, K, V> {
    private final IValueProperty<S, M> masterProperty;
    private final IMapProperty<? super M, K, V> detailProperty;

    public ValuePropertyDetailMap(IValueProperty<S, M> masterProperty, IMapProperty<? super M, K, V> detailProperty) {
        this.masterProperty = masterProperty;
        this.detailProperty = detailProperty;
    }

    @Override
    public Object getKeyType() {
        return this.detailProperty.getKeyType();
    }

    @Override
    public Object getValueType() {
        return this.detailProperty.getValueType();
    }

    @Override
    protected Map<K, V> doGetMap(S source) {
        M masterValue = this.masterProperty.getValue(source);
        return this.detailProperty.getMap(masterValue);
    }

    @Override
    protected void doSetMap(S source, Map<K, V> map) {
        M masterValue = this.masterProperty.getValue(source);
        this.detailProperty.setMap(masterValue, map);
    }

    @Override
    protected void doUpdateMap(S source, MapDiff<K, V> diff) {
        M masterValue = this.masterProperty.getValue(source);
        this.detailProperty.updateMap(masterValue, diff);
    }

    @Override
    public IObservableMap<K, V> observe(Realm realm, S source) {
        IObservableValue<M> masterValue;
        ObservableTracker.setIgnore(true);
        try {
            masterValue = this.masterProperty.observe(realm, source);
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
        IObservableMap<K, V> detailMap = this.detailProperty.observeDetail(masterValue);
        PropertyObservableUtil.cascadeDispose(detailMap, masterValue);
        return detailMap;
    }

    @Override
    public <U extends S> IObservableMap<K, V> observeDetail(IObservableValue<U> master) {
        IObservableValue<M> masterValue;
        ObservableTracker.setIgnore(true);
        try {
            masterValue = this.masterProperty.observeDetail(master);
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
        IObservableMap<K, V> detailMap = this.detailProperty.observeDetail(masterValue);
        PropertyObservableUtil.cascadeDispose(detailMap, masterValue);
        return detailMap;
    }

    public String toString() {
        return this.masterProperty + " => " + this.detailProperty;
    }
}

