/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property.value;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.property.ValuePropertyDetailList;
import org.eclipse.core.internal.databinding.property.ValuePropertyDetailMap;
import org.eclipse.core.internal.databinding.property.ValuePropertyDetailSet;
import org.eclipse.core.internal.databinding.property.ValuePropertyDetailValue;

public abstract class ValueProperty<S, T>
implements IValueProperty<S, T> {
    @Override
    public T getValue(S source) {
        if (source == null) {
            return null;
        }
        return this.doGetValue(source);
    }

    protected T doGetValue(S source) {
        IObservableValue<T> observable = this.observe(source);
        try {
            T t = observable.getValue();
            return t;
        }
        finally {
            observable.dispose();
        }
    }

    @Override
    public final void setValue(S source, T value) {
        if (source != null) {
            this.doSetValue(source, value);
        }
    }

    protected void doSetValue(S source, T value) {
        IObservableValue<T> observable = this.observe(source);
        try {
            observable.setValue(value);
        }
        finally {
            observable.dispose();
        }
    }

    @Override
    public IObservableValue<T> observe(S source) {
        return this.observe(Realm.getDefault(), source);
    }

    @Override
    public IObservableFactory<S, IObservableValue<T>> valueFactory() {
        return target -> this.observe(target);
    }

    @Override
    public IObservableFactory<S, IObservableValue<T>> valueFactory(Realm realm) {
        return target -> this.observe(realm, target);
    }

    @Override
    public <U extends S> IObservableValue<T> observeDetail(IObservableValue<U> master) {
        return MasterDetailObservables.detailValue(master, this.valueFactory(master.getRealm()), this.getValueType());
    }

    @Override
    public <V extends S> IObservableList<T> observeDetail(IObservableList<V> master) {
        return MasterDetailObservables.detailValues(master, this.valueFactory(master.getRealm()), this.getValueType());
    }

    @Override
    public <V extends S> IObservableMap<V, T> observeDetail(IObservableSet<V> master) {
        return MasterDetailObservables.detailValues(master, this.valueFactory(master.getRealm()), this.getValueType());
    }

    @Override
    public <K, V extends S> IObservableMap<K, T> observeDetail(IObservableMap<K, V> master) {
        return MasterDetailObservables.detailValues(master, this.valueFactory(master.getRealm()), this.getValueType());
    }

    @Override
    public final <U> IValueProperty<S, U> value(IValueProperty<? super T, U> detailValue) {
        return new ValuePropertyDetailValue(this, detailValue);
    }

    @Override
    public final <E> IListProperty<S, E> list(IListProperty<? super T, E> detailList) {
        return new ValuePropertyDetailList(this, detailList);
    }

    @Override
    public final <E> ISetProperty<S, E> set(ISetProperty<? super T, E> detailSet) {
        return new ValuePropertyDetailSet(this, detailSet);
    }

    @Override
    public final <K, V> IMapProperty<S, K, V> map(IMapProperty<? super T, K, V> detailMap) {
        return new ValuePropertyDetailMap(this, detailMap);
    }
}

