/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.installer;

import com.pnfsoftware.jeb.installer.IO;
import java.io.File;
import java.io.IOException;

public class Version
implements Comparable<Version> {
    public static final int RELEASE = 0;
    public static final int BETA = 1;
    public static final int ALPHA = 2;
    private int major;
    private int minor;
    private int buildid;
    private long timestamp;
    private int channel;

    public Version(Version v) {
        this(v.major, v.minor, v.buildid, v.timestamp, v.channel);
    }

    public Version(int major, int minor) {
        this(major, minor, 0, 0L);
    }

    public Version(int major, int minor, int buildid) {
        this(major, minor, buildid, 0L);
    }

    public Version(int major, int minor, int buildid, long timestamp) {
        this(major, minor, buildid, timestamp, 0);
    }

    public Version(int major, int minor, int buildid, long timestamp, int channel) {
        if (major < 0 || minor < 0 || buildid < 0 || timestamp < 0L || channel < 0 || channel > 2) {
            throw new RuntimeException("Invalid version");
        }
        this.major = major;
        this.minor = minor;
        this.buildid = buildid;
        this.timestamp = timestamp;
        this.channel = channel;
    }

    public static Version create(int major, int minor) {
        return new Version(major, minor, 0, 0L, 0);
    }

    public static Version create(int major, int minor, int buildid) {
        return new Version(major, minor, buildid, 0L, 0);
    }

    public static Version create(int major, int minor, int buildid, long timestamp) {
        return new Version(major, minor, buildid, timestamp);
    }

    public static Version create(int major, int minor, int buildid, long timestamp, int channel) {
        return new Version(major, minor, buildid, timestamp, channel);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getBuildid() {
        return this.buildid;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getChannel() {
        return this.channel;
    }

    public String getChannelString() {
        switch (this.channel) {
            case 0: {
                return null;
            }
            case 1: {
                return "beta";
            }
            case 2: {
                return "alpha";
            }
        }
        throw new RuntimeException("Invalid channel id");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.buildid;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + Long.valueOf(this.timestamp).hashCode();
        result = 31 * result + this.channel;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Version o = (Version)obj;
        return this.major == o.major && this.minor == o.minor && this.buildid == o.buildid && this.timestamp == o.timestamp && this.channel == o.channel;
    }

    @Override
    public int compareTo(Version o) {
        if (this.major > o.major) {
            return 1;
        }
        if (this.major == o.major && this.minor > o.minor) {
            return 1;
        }
        if (this.major == o.major && this.minor == o.minor && this.buildid > o.buildid) {
            return 1;
        }
        if (this.major == o.major && this.minor == o.minor && this.buildid == o.buildid && this.timestamp > o.timestamp) {
            return 1;
        }
        if (this.major == o.major && this.minor == o.minor && this.buildid == o.buildid && this.timestamp == o.timestamp) {
            return -Integer.compare(this.channel, o.channel);
        }
        return -1;
    }

    public int compareToIgnoreTimestamp(Version o) {
        if (this.major > o.major) {
            return 1;
        }
        if (this.major == o.major && this.minor > o.minor) {
            return 1;
        }
        if (this.major == o.major && this.minor == o.minor && this.buildid > o.buildid) {
            return 1;
        }
        if (this.major == o.major && this.minor == o.minor && this.buildid == o.buildid) {
            return -Integer.compare(this.channel, o.channel);
        }
        return -1;
    }

    public boolean like(int major) {
        return this.major == major;
    }

    public boolean like(int major, int minor) {
        return this.major == major && this.minor == minor;
    }

    public boolean like(int major, int minor, int buildid) {
        return this.major == major && this.minor == minor && this.buildid == buildid;
    }

    public String toString() {
        if (this.channel != 0) {
            String channelStr = this.getChannelString();
            if (this.timestamp == 0L) {
                return String.format("%d.%d-%s.%d", this.major, this.minor, channelStr, this.buildid);
            }
            return String.format("%d.%d-%s.%d.%d", this.major, this.minor, channelStr, this.buildid, this.timestamp);
        }
        if (this.timestamp == 0L) {
            return String.format("%d.%d.%d", this.major, this.minor, this.buildid);
        }
        return String.format("%d.%d.%d.%d", this.major, this.minor, this.buildid, this.timestamp);
    }

    public static Version parseFromString(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        String[] verinfo = s.trim().split("\\.", -1);
        if (verinfo.length != 3 && verinfo.length != 4) {
            return null;
        }
        try {
            int channel;
            int minor;
            int major = Integer.parseInt(verinfo[0]);
            String elt = verinfo[1];
            int pos = elt.indexOf(45);
            if (pos < 0) {
                minor = Integer.parseInt(elt);
                channel = 0;
            } else {
                String channelString;
                minor = Integer.parseInt(elt.substring(0, pos));
                switch (channelString = elt.substring(pos + 1)) {
                    case "beta": {
                        channel = 1;
                        break;
                    }
                    case "alpha": {
                        channel = 2;
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            int buildid = Integer.parseInt(verinfo[2]);
            long timestamp = 0L;
            try {
                if (verinfo.length == 4) {
                    timestamp = Long.parseLong(verinfo[3]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new Version(major, minor, buildid, timestamp, channel);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Version parseFromFile(File f) {
        try {
            String s = new String(IO.readFile(f), "UTF-8");
            return Version.parseFromString(s.trim());
        }
        catch (IOException e) {
            return null;
        }
    }
}

