/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.androidjnihelper;

import com.pnf.plugin.androidjnihelper.IDynamicJNIDetectionHeuritic;
import com.pnf.plugin.androidjnihelper.JNINativeMethod;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IReference;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeStringItem;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.codeobject.ISymbolInformation;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class DynamicJNIDetectionHeurFromMethodName
implements IDynamicJNIDetectionHeuritic {
    private static final ILogger logger = GlobalLog.getLogger(DynamicJNIDetectionHeurFromMethodName.class);

    @Override
    public List<JNINativeMethod> determine(INativeCodeUnit<?> codeUnit, List<IDexMethod> nativeMethods, ISymbolInformation onload) {
        ArrayList<JNINativeMethod> registered = new ArrayList<JNINativeMethod>();
        block0: for (INativeStringItem str : codeUnit.getStrings()) {
            for (IDexMethod m : nativeMethods) {
                if (!m.getName(true).equals(str.getValue())) continue;
                logger.info("JNI matching method name %s found @%Xh", new Object[]{str.getValue(), str.getBegin()});
                Set xrefs = codeUnit.getCodeModel().getReferenceManager().getReferencesToTarget(((Long)str.getBegin()).longValue());
                if (xrefs == null || xrefs.isEmpty()) continue;
                for (IReference xref : xrefs) {
                    AtomicLong ptrMethods = new AtomicLong(xref.getAddress());
                    IVirtualMemory vm = codeUnit.getMemory();
                    JNINativeMethod jni = JNINativeMethod.buildJNIFromMemPointer(codeUnit, vm, ptrMethods);
                    if (jni == null) continue;
                    registered.add(jni);
                }
                continue block0;
            }
        }
        return registered;
    }
}

