/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.AbstractEnginesPlugin;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.ILiveArtifact;
import com.pnfsoftware.jeb.core.IOptionDefinition;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.OptionDefinition;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.util.encoding.Hash;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.bg;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class fV
extends AbstractEnginesPlugin {
    private static final ILogger eO = GlobalLog.getLogger(fV.class);
    private IEnginesContext Le;
    private IEventListener Qx;
    private String lS;
    private static final String ae = ".VirusTotalApiKey";

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("VT Report Plugin", "Display and record VirusTotal reports for top-level binary units processed in JEB", "PNF Software", Version.create(1, 0, 0));
    }

    @Override
    public void load(IEnginesContext iEnginesContext) {
        this.Le = iEnginesContext;
        this.lS = this.eO(iEnginesContext);
        this.Qx = new bg(this);
        iEnginesContext.addListener(this.Qx);
    }

    @Override
    public void dispose() {
        if (this.Qx != null) {
            this.Le.removeListener(this.Qx);
            this.Qx = null;
        }
    }

    @Override
    public List<? extends IOptionDefinition> getExecutionOptionDefinitions() {
        return Arrays.asList(new OptionDefinition(null, "Specify or update your VirusTotal API key:"), new OptionDefinition("apikey", this.lS, "VirusTotal API Key"));
    }

    @Override
    public void execute(IEnginesContext iEnginesContext, Map<String, String> map) {
        if (map != null) {
            this.lS = map.get("apikey");
            if (this.lS != null) {
                this.eO(iEnginesContext, this.lS);
            }
        }
        if (this.lS == null) {
            eO.error("In order to use the VirusTotal Scan Report plugin, set up your VT API key first!", new Object[0]);
            return;
        }
        this.Le(iEnginesContext);
    }

    private String eO(IEnginesContext iEnginesContext) {
        try {
            return iEnginesContext.getPropertyManager().getString(ae);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean eO(IEnginesContext iEnginesContext, String string) {
        try {
            iEnginesContext.getPropertyManager().setString(ae, string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void Le(IEnginesContext iEnginesContext) {
        for (IRuntimeProject iRuntimeProject : iEnginesContext.getProjects()) {
            for (ILiveArtifact iLiveArtifact : iRuntimeProject.getLiveArtifacts()) {
                for (IUnit iUnit : iLiveArtifact.getUnits()) {
                    if (!(iUnit instanceof IBinaryUnit)) continue;
                    try {
                        this.eO((IBinaryUnit)iUnit);
                    }
                    catch (Exception exception) {
                        eO.catching(exception);
                    }
                }
            }
        }
    }

    private boolean eO(IBinaryUnit iBinaryUnit) throws IOException, ParseException {
        String string;
        Object object;
        if (Strings.isBlank(this.lS)) {
            return false;
        }
        Object object2 = iBinaryUnit.getInput().getStream();
        Object object3 = null;
        try {
            object = IO.readInputStream((InputStream)object2);
            string = Formatter.byteArrayToHexString(Hash.calculateSHA256((byte[])object)).toLowerCase();
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            if (object2 != null) {
                if (object3 != null) {
                    try {
                        ((InputStream)object2).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object3).addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)object2).close();
                }
            }
        }
        eO.debug("Verifying SHA-256 hash on VirustTotal: %s", string);
        object2 = String.format("https://www.virustotal.com/vtapi/v2/file/report?apikey=%s&resource=%s", this.lS, string);
        object3 = this.Le.getNetworkUtility().query((String)object2);
        eO.debug((String)object3, new Object[0]);
        object = (Map)new JSONParser().parse((String)object3);
        Long l2 = (Long)object.get("response_code");
        if (l2 == null) {
            eO.debug("Invalid VT answer: %s", object2);
            return false;
        }
        if (l2 == 0L) {
            UnitUtil.logInfo(iBinaryUnit, null, true, eO, "VT: unknown file", new Object[0]);
        } else if (l2 == 1L) {
            long l3 = (Long)object.get("positives");
            long l4 = (Long)object.get("total");
            String string2 = (String)object.get("scan_date");
            UnitUtil.logInfo(iBinaryUnit, null, true, eO, "VT Report: %d/%d (%s)", l3, l4, string2);
        } else if (l2 == 2L) {
            UnitUtil.logInfo(iBinaryUnit, null, false, eO, "VT: analysis in progress", new Object[0]);
        } else {
            UnitUtil.logInfo(iBinaryUnit, null, false, eO, "VT: error - unknown response_code", new Object[0]);
        }
        return true;
    }

    static /* synthetic */ ILogger eO() {
        return eO;
    }

    static /* synthetic */ boolean eO(fV fV2, IBinaryUnit iBinaryUnit) throws IOException, ParseException {
        return fV2.eO(iBinaryUnit);
    }
}

