/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.net;

import com.pnfsoftware.jeb.util.base.IProgressCallback;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

class ProgressResponseBody
extends ResponseBody {
    private final ResponseBody responseBody;
    private final IProgressCallback progressListener;
    private BufferedSource bufferedSource;

    ProgressResponseBody(ResponseBody responseBody, IProgressCallback iProgressCallback) {
        this.responseBody = responseBody;
        this.progressListener = iProgressCallback;
    }

    public MediaType contentType() {
        return this.responseBody.contentType();
    }

    public long contentLength() {
        return this.responseBody.contentLength();
    }

    public BufferedSource source() {
        if (this.bufferedSource == null) {
            this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
        }
        return this.bufferedSource;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            long totalBytesRead;
            {
                this.totalBytesRead = 0L;
            }

            public long read(Buffer buffer, long l2) throws IOException {
                long l3 = super.read(buffer, l2);
                this.totalBytesRead += l3 != -1L ? l3 : 0L;
                ProgressResponseBody.this.progressListener.progress(this.totalBytesRead, ProgressResponseBody.this.responseBody.contentLength());
                return l3;
            }
        };
    }
}

