/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.logging;

import com.pnfsoftware.jeb.util.format.CharSequences;
import com.pnfsoftware.jeb.util.logging.BufferSink;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.logging.LogStatusSink;
import com.pnfsoftware.jeb.util.logging.Sink;
import com.pnfsoftware.jeb.util.logging.StreamSink;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;

class SimpleLogger
implements ILogger {
    private String name;
    private int cutoffLevel;

    public SimpleLogger(String string, int n) {
        this.name = string;
        this.cutoffLevel = n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setEnabledLevel(int n) {
        this.cutoffLevel = n;
    }

    @Override
    public int getEnabledLevel() {
        return this.cutoffLevel;
    }

    @Override
    public void log(int n, boolean bl2, String string, Object ... objectArray) {
        StringBuilder stringBuilder;
        Object object;
        if (n < 60 && (n < this.cutoffLevel || GlobalLog.isGloballyDisabled(this))) {
            return;
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        if (objectArray.length == 0) {
            stringBuilder2.append(string);
        } else {
            try {
                CharSequences.f(stringBuilder2, string, objectArray);
            }
            catch (NullPointerException | IllegalFormatException runtimeException) {
                stringBuilder2 = new StringBuilder(runtimeException.getMessage());
            }
        }
        if (!bl2) {
            stringBuilder2.append("\n");
        }
        if (n == 100) {
            for (LogStatusSink logStatusSink : GlobalLog.outStatusSinks) {
                logStatusSink.update(stringBuilder2);
            }
            return;
        }
        StringBuilder stringBuilder3 = null;
        if (this.needTimestamp()) {
            Iterator<BufferSink> iterator = Calendar.getInstance();
            String object2 = String.format("%04d-%02d-%02d %02d:%02d:%02d.%03d %s", ((Calendar)((Object)iterator)).get(1), 1 + ((Calendar)((Object)iterator)).get(2), ((Calendar)((Object)iterator)).get(5), ((Calendar)((Object)iterator)).get(11), 1 + ((Calendar)((Object)iterator)).get(12), ((Calendar)((Object)iterator)).get(13), ((Calendar)((Object)iterator)).get(14), ((Calendar)((Object)iterator)).getTimeZone().getDisplayName(false, 0));
            stringBuilder3 = new StringBuilder("[").append(object2).append("] ").append((CharSequence)stringBuilder2);
        }
        for (StreamSink streamSink : GlobalLog.outStreams) {
            if (n < 60 && n < streamSink.getLogLevel()) continue;
            object = (OutputStream)streamSink.getOutput();
            stringBuilder = streamSink.isPrefixWithTimestamp() ? stringBuilder3 : stringBuilder2;
            try {
                char[] cArray = new char[stringBuilder.length()];
                stringBuilder.getChars(0, stringBuilder.length(), cArray, 0);
                ((OutputStream)object).write(CharSequences.toByteArray(cArray));
            }
            catch (IOException iOException) {}
        }
        for (BufferSink bufferSink : GlobalLog.outBuffers) {
            if (n < 60 && n < bufferSink.getLogLevel()) continue;
            object = (List)bufferSink.getOutput();
            stringBuilder = bufferSink.isPrefixWithTimestamp() ? stringBuilder3 : stringBuilder2;
            object.add(stringBuilder);
        }
    }

    private boolean needTimestamp() {
        for (Sink<?> sink : GlobalLog.getRegularSinks()) {
            if (!sink.isPrefixWithTimestamp()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void i(String string, Object ... objectArray) {
    }

    @Override
    public void trace(String string, Object ... objectArray) {
        this.log(10, false, string, objectArray);
    }

    @Override
    public void fine(String string, Object ... objectArray) {
        this.trace(string, objectArray);
    }

    @Override
    public void debug(String string, Object ... objectArray) {
        this.log(20, false, string, objectArray);
    }

    @Override
    public void info(String string, Object ... objectArray) {
        this.log(30, false, string, objectArray);
    }

    @Override
    public void warn(String string, Object ... objectArray) {
        this.log(40, false, string, objectArray);
    }

    @Override
    public void warning(String string, Object ... objectArray) {
        this.warn(string, objectArray);
    }

    @Override
    public void error(String string, Object ... objectArray) {
        this.log(50, false, string, objectArray);
    }

    @Override
    public void severe(String string, Object ... objectArray) {
        this.error(string, objectArray);
    }

    @Override
    public void catching(Throwable throwable) {
        GlobalLog.catching(this, throwable);
    }

    @Override
    public void catching(Throwable throwable, String string) {
        GlobalLog.catching(this, throwable, string);
    }

    @Override
    public void catching(Throwable throwable, String string, Object ... objectArray) {
        GlobalLog.catching(this, throwable, String.format(string, objectArray));
    }

    @Override
    public void catchingSilent(Throwable throwable) {
        GlobalLog.catchingDebug(this, throwable);
    }

    @Override
    public void status(String string, Object ... objectArray) {
        this.log(100, true, string, objectArray);
    }
}

