/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.logging;

import com.pnfsoftware.jeb.util.base.Throwables;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.BufferSink;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.logging.InternalLogger;
import com.pnfsoftware.jeb.util.logging.LogStatusSink;
import com.pnfsoftware.jeb.util.logging.SimpleLogger;
import com.pnfsoftware.jeb.util.logging.Sink;
import com.pnfsoftware.jeb.util.logging.StreamSink;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class GlobalLog {
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_DISABLED = Integer.MAX_VALUE;
    public static final int LEVEL_TRACE = 10;
    public static final int LEVEL_DEBUG = 20;
    public static final int LEVEL_INFO = 30;
    public static final int LEVEL_WARN = 40;
    public static final int LEVEL_ERROR = 50;
    public static final int LEVEL_CATCHING = 60;
    public static final int LEVEL_STATUS = 100;
    static List<StreamSink> outStreams = new CopyOnWriteArrayList<StreamSink>();
    static List<BufferSink> outBuffers = new CopyOnWriteArrayList<BufferSink>();
    static List<LogStatusSink> outStatusSinks = new CopyOnWriteArrayList<LogStatusSink>();
    private static Map<String, ILogger> map = new HashMap<String, ILogger>();
    private static int enabledLevel = 30;
    private static Map<String, Integer> filtermap = new HashMap<String, Integer>();

    public static synchronized StreamSink addDestinationStream(OutputStream outputStream) {
        StreamSink streamSink = new StreamSink(outputStream);
        int n = outStreams.indexOf(streamSink);
        if (n >= 0) {
            return outStreams.get(n);
        }
        outStreams.add(streamSink);
        return streamSink;
    }

    public static synchronized StreamSink removeDestinationStream(OutputStream outputStream) {
        StreamSink streamSink = new StreamSink(outputStream);
        int n = outStreams.indexOf(streamSink);
        return n < 0 ? null : outStreams.remove(n);
    }

    public static synchronized List<StreamSink> getDestinationStreams() {
        return outStreams;
    }

    public static synchronized BufferSink addDestinationBuffer(List<CharSequence> list) {
        BufferSink bufferSink = new BufferSink(list);
        int n = outBuffers.indexOf(bufferSink);
        if (n >= 0) {
            return outBuffers.get(n);
        }
        outBuffers.add(bufferSink);
        return bufferSink;
    }

    public static synchronized BufferSink removeDestinationBuffer(List<CharSequence> list) {
        BufferSink bufferSink = new BufferSink(list);
        int n = outBuffers.indexOf(bufferSink);
        return n < 0 ? null : outBuffers.remove(n);
    }

    public static synchronized List<BufferSink> getDestinationBuffers() {
        return outBuffers;
    }

    public static synchronized List<Sink<?>> getRegularSinks() {
        ArrayList arrayList = new ArrayList(outBuffers);
        arrayList.addAll(outStreams);
        return arrayList;
    }

    public static synchronized void addStatusSink(LogStatusSink logStatusSink) {
        if (!outStatusSinks.contains(logStatusSink)) {
            outStatusSinks.add(logStatusSink);
        }
    }

    public static synchronized void removeStatusSink(LogStatusSink logStatusSink) {
        outStatusSinks.remove(logStatusSink);
    }

    public static synchronized List<LogStatusSink> getStatusSinks() {
        return outStatusSinks;
    }

    public static synchronized void setEnabledLevel(int n) {
        enabledLevel = n;
    }

    public static synchronized void setEnabledLevel(int n, boolean bl2) {
        enabledLevel = n;
        if (bl2) {
            for (String string : map.keySet()) {
                ILogger iLogger = map.get(string);
                iLogger.setEnabledLevel(n);
            }
        }
    }

    public static synchronized void addGlobalFilter(boolean bl2) {
        if (bl2) {
            GlobalLog.addGlobalFilter("", Integer.MAX_VALUE);
        } else {
            GlobalLog.removeGlobalFilter("");
        }
    }

    public static synchronized void addGlobalFilter(String string, int n) {
        filtermap.put(string, n);
    }

    public static synchronized void removeGlobalFilter(String string) {
        filtermap.remove(string);
    }

    public static synchronized void clearGlobalFilters() {
        filtermap.clear();
    }

    public static synchronized boolean isGloballyDisabled(ILogger iLogger) {
        String string = Strings.safe(iLogger.getName());
        if (string != null) {
            for (String string2 : filtermap.keySet()) {
                String string3 = string2 + ".";
                if (!string2.isEmpty() && !string.equals(string2) && !string.startsWith(string3)) continue;
                int n = filtermap.get(string2);
                if (iLogger.getEnabledLevel() >= n) continue;
                return true;
            }
        }
        return false;
    }

    public static synchronized int getEnabledLevel() {
        return enabledLevel;
    }

    public static synchronized ILogger getLogger() {
        return GlobalLog.getLogger((String)null, enabledLevel);
    }

    public static synchronized void status(String string, Object ... objectArray) {
        GlobalLog.getLogger().status(string, objectArray);
    }

    public static synchronized ILogger getLogger(Class<?> clazz) {
        return GlobalLog.getLogger(clazz, enabledLevel);
    }

    public static synchronized ILogger getLogger(Class<?> clazz, int n) {
        return GlobalLog.getLogger(clazz.getName(), n);
    }

    public static synchronized ILogger getLogger(String string, int n) {
        ILogger iLogger = map.get(string);
        if (iLogger == null) {
            iLogger = new SimpleLogger(string, n);
            map.put(string, iLogger);
        }
        return iLogger;
    }

    public static synchronized ILogger getInternalLogger(Class<?> clazz) {
        String string = clazz.getName();
        ILogger iLogger = map.get(string);
        if (iLogger == null) {
            iLogger = new InternalLogger(string);
            map.put(string, iLogger);
        }
        return iLogger;
    }

    public static void catching(ILogger iLogger, Throwable throwable) {
        GlobalLog.catching(iLogger, throwable, null);
    }

    public static void catching(ILogger iLogger, Throwable throwable, String string) {
        iLogger.log(60, false, (string == null ? "" : string + "\n") + Throwables.formatStacktrace(throwable), new Object[0]);
    }

    public static void catchingDebug(ILogger iLogger, Throwable throwable) {
        GlobalLog.catchingDebug(iLogger, throwable, null);
    }

    public static void catchingDebug(ILogger iLogger, Throwable throwable, String string) {
        iLogger.log(20, false, (string == null ? "" : string + "\n") + Throwables.formatStacktrace(throwable), new Object[0]);
    }

    public static int parseLevel(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            switch (string.trim().toUpperCase()) {
                case "ALL": {
                    return 0;
                }
                case "DISABLED": {
                    return Integer.MAX_VALUE;
                }
                case "TRACE": {
                    return 10;
                }
                case "DEBUG": {
                    return 20;
                }
                case "INFO": {
                    return 30;
                }
                case "WARN": {
                    return 40;
                }
                case "ERROR": {
                    return 50;
                }
                case "CATCHING": {
                    return 60;
                }
                case "STATUS": {
                    return 100;
                }
            }
            return -1;
        }
    }

    public static String levelToString(int n) {
        switch (n) {
            case 0: {
                return "ALL";
            }
            case 10: {
                return "TRACE";
            }
            case 20: {
                return "DEBUG";
            }
            case 30: {
                return "INFO";
            }
            case 40: {
                return "WARN";
            }
            case 50: {
                return "ERROR";
            }
            case 60: {
                return "CATCHING";
            }
            case 0x7FFFFFFF: {
                return "DISABLED";
            }
        }
        return "LEVEL_" + n;
    }
}

