/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import com.pnfsoftware.jeb.util.encoding.BadEncodingException;
import com.pnfsoftware.jeb.util.encoding.LEB128;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import java.util.Arrays;

public class ByteArray {
    byte[] bytes;
    int index;
    int maxindex;

    public ByteArray(byte[] byArray) {
        this(byArray, 0);
    }

    public ByteArray(byte[] byArray, int n) {
        this(byArray, n, byArray.length);
    }

    public ByteArray(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("Null byte array");
        }
        this.bytes = byArray;
        this.position(n);
        this.maxPosition(n2);
    }

    public ByteArray copy() {
        return this.copy(this.index);
    }

    public ByteArray copy(int n) {
        return this.copy(n, this.maxindex);
    }

    public ByteArray copy(int n, int n2) {
        return new ByteArray(this.bytes, n, n2);
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public int position(int n) {
        if (n < 0 || n > this.bytes.length) {
            throw new IllegalArgumentException("Illegal position: " + n);
        }
        int n2 = this.index;
        this.index = n;
        return n2;
    }

    public int position() {
        return this.index;
    }

    public int maxPosition(int n) {
        if (n < 0 || n > this.bytes.length) {
            throw new IllegalArgumentException("Illegal max position: " + n);
        }
        int n2 = this.maxindex;
        this.maxindex = n;
        return n2;
    }

    public int maxPosition() {
        return this.maxindex;
    }

    public int available() {
        return this.maxindex - this.index;
    }

    private void updateIndex(int n) {
        this.index += n;
        if (this.index > this.maxindex) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public void skip(int n) {
        this.updateIndex(n);
    }

    public byte[] get(int n) {
        byte[] byArray = Arrays.copyOfRange(this.bytes, this.index, this.index + n);
        this.updateIndex(n);
        return byArray;
    }

    public int u8() {
        int n = this.bytes[this.index] & 0xFF;
        this.updateIndex(1);
        return n;
    }

    public int u16() {
        short s2 = EndianUtil.littleEndianBytesToShort(this.bytes, this.index);
        this.updateIndex(2);
        return s2 & 0xFFFF;
    }

    public int u31() {
        int n = EndianUtil.littleEndianBytesToInt(this.bytes, this.index);
        if (n < 0) {
            throw new BadEncodingException(String.format("Expected a positive 4-byte signed integer, got 0x%X", n), this.index);
        }
        this.updateIndex(4);
        return n;
    }

    public int i32() {
        int n = EndianUtil.littleEndianBytesToInt(this.bytes, this.index);
        this.updateIndex(4);
        return n;
    }

    public long u32() {
        int n = EndianUtil.littleEndianBytesToInt(this.bytes, this.index);
        this.updateIndex(4);
        return (long)n & 0xFFFFFFFFL;
    }

    public long u63() {
        long l2 = EndianUtil.littleEndianBytesToLong(this.bytes, this.index);
        if (l2 < 0L) {
            throw new BadEncodingException(String.format("Expected a positive 8-byte signed integer, got 0x%X", l2), this.index);
        }
        this.updateIndex(8);
        return l2;
    }

    public long i64() {
        long l2 = EndianUtil.littleEndianBytesToLong(this.bytes, this.index);
        this.updateIndex(8);
        return l2;
    }

    public int varu16() {
        LEB128.Value value = LEB128.read_uint16(this.bytes, this.index);
        this.updateIndex(value.getEncodingLength());
        return (int)value.get();
    }

    public int vari32() {
        LEB128.Value value = LEB128.read_int32(this.bytes, this.index);
        this.updateIndex(value.getEncodingLength());
        return (int)value.get();
    }

    public long varu32() {
        LEB128.Value value = LEB128.read_uint32(this.bytes, this.index);
        this.updateIndex(value.getEncodingLength());
        return value.get();
    }

    public long vari64() {
        LEB128.Value value = LEB128.read_int64(this.bytes, this.index);
        this.updateIndex(value.getEncodingLength());
        return value.get();
    }
}

