/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.interpreter;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.interpreter.CommandParameter;
import com.pnfsoftware.jeb.util.interpreter.ICommandHandler;
import com.pnfsoftware.jeb.util.interpreter.ICommandManager;
import com.pnfsoftware.jeb.util.interpreter.ICommandNode;
import com.pnfsoftware.jeb.util.interpreter.InputToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractCommandHandler
implements ICommandHandler {
    protected ICommandManager parent;
    protected String name;
    protected List<CommandParameter> params = new ArrayList<CommandParameter>();
    protected String help = "";
    protected String helpDetails = "";
    private int options = 0;

    public AbstractCommandHandler(ICommandManager iCommandManager, String string) {
        this(iCommandManager, string, "");
    }

    public AbstractCommandHandler(ICommandManager iCommandManager, String string, String string2) {
        this.parent = iCommandManager;
        this.name = string;
        this.help = string2;
        this.helpDetails = "";
    }

    public AbstractCommandHandler(ICommandManager iCommandManager, String string, String[] stringArray, String string2, String string3) {
        this(iCommandManager, string, string2);
        this.helpDetails = string3;
        for (String string4 : stringArray) {
            this.addParameter(new CommandParameter(string4, "", false));
        }
    }

    public AbstractCommandHandler(ICommandManager iCommandManager, String string, CommandParameter[] commandParameterArray, String string2, String string3) {
        this(iCommandManager, string, string2);
        this.helpDetails = string3;
        for (CommandParameter commandParameter : commandParameterArray) {
            this.params.add(commandParameter);
        }
    }

    public InputToken[] parseInputToken(List<InputToken> list) {
        return this.parseInputToken(list, true);
    }

    public InputToken[] parseInputToken(List<InputToken> list, boolean bl2) {
        Object object;
        int n;
        InputToken[] inputTokenArray = new InputToken[this.params.size()];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl3 = true;
        boolean bl4 = this.params.get(this.params.size() - 1).allowMultipleTokens();
        int n2 = -1;
        block0: for (n = 0; n < list.size(); ++n) {
            object = list.get(n);
            boolean bl5 = !((InputToken)object).needsUnespaping() && ((InputToken)object).getValue().startsWith("-");
            String string = ((InputToken)object).getValue();
            if (bl5) {
                if (!bl3) {
                    throw new IllegalArgumentException(String.format("Unexpected prefixed parameter %s", ((InputToken)object).getValue()));
                }
                string = string.substring(1);
            } else {
                bl3 = false;
            }
            for (int j = 0; j < this.params.size(); ++j) {
                CommandParameter commandParameter = this.params.get(j);
                if (bl5) {
                    if (commandParameter.hasPrefix()) {
                        if (!string.contains(commandParameter.getPrefix())) continue;
                        if (inputTokenArray[j] != null) {
                            throw new IllegalArgumentException(String.format("Duplicated parameter -%s", commandParameter.getPrefix()));
                        }
                        if (Strings.isBlank(commandParameter.getName())) {
                            inputTokenArray[j] = object;
                            string = string.replace(commandParameter.getPrefix(), "");
                        } else {
                            if (!string.endsWith(commandParameter.getPrefix())) {
                                throw new IllegalArgumentException(String.format("Expected token after %s ", commandParameter.getPrefix()));
                            }
                            string = string.substring(0, string.length() - commandParameter.getPrefix().length());
                            if (++n < list.size()) {
                                inputTokenArray[j] = list.get(n);
                            } else {
                                throw new IllegalArgumentException(String.format("Expected token after -%s", commandParameter.getPrefix()));
                            }
                        }
                        if (!string.isEmpty()) continue;
                        continue block0;
                    }
                    throw new IllegalArgumentException(String.format("Unexpected parameter %s", string));
                }
                if (n2 == -1 && commandParameter.hasPrefix()) continue;
                if (n2 == -1) {
                    n2 = j;
                }
                if (n2 < this.params.size()) {
                    inputTokenArray[n2] = object;
                    ++n2;
                    continue block0;
                }
                if (bl4) {
                    arrayList.add(object);
                    continue block0;
                }
                throw new IllegalArgumentException(String.format("Extra parameter %s", string));
            }
        }
        if (bl2) {
            for (n = 0; n < this.params.size(); ++n) {
                object = this.params.get(n);
                if (((CommandParameter)object).isOptional() || inputTokenArray[n] != null) continue;
                throw new IllegalArgumentException(String.format("Missing parameter %s", ((CommandParameter)object).getName()));
            }
        }
        if (bl4 && !arrayList.isEmpty()) {
            for (n = 0; n < this.params.size(); ++n) {
                arrayList.add(n, inputTokenArray[n]);
            }
            inputTokenArray = arrayList.toArray(new InputToken[arrayList.size()]);
        }
        return inputTokenArray;
    }

    @Override
    public ICommandManager getParent() {
        return this.parent;
    }

    @Override
    public List<ICommandNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    @Override
    public String getHelp() {
        return this.help;
    }

    protected void setHelp(String string) {
        this.help = string;
    }

    @Override
    public String getHelpDetails() {
        return this.helpDetails;
    }

    @Override
    public List<CommandParameter> getParameters() {
        return this.params;
    }

    public int getParameterIndex(String string, String string2) {
        for (int j = 0; j < this.params.size(); ++j) {
            CommandParameter commandParameter = this.params.get(j);
            if (!Strings.equals(string2, commandParameter.getPrefix()) || !Strings.equals(string, commandParameter.getName())) continue;
            return j;
        }
        return -1;
    }

    public AbstractCommandHandler addParameter(String string) {
        return this.addParameter(new CommandParameter(string, false));
    }

    public AbstractCommandHandler addParameter(CommandParameter commandParameter) {
        if (commandParameter.getName() == null || commandParameter.getName().isEmpty()) {
            throw new IllegalArgumentException("Parameter name is empty or null");
        }
        for (CommandParameter commandParameter2 : this.params) {
            if (commandParameter.getName().equalsIgnoreCase(commandParameter2.getName())) {
                throw new IllegalArgumentException("Duplicate parameter");
            }
            if (!commandParameter.isOptional() && !commandParameter.hasPrefix() && commandParameter2.isOptional()) {
                throw new IllegalArgumentException("Mandatory parameters must come first");
            }
            if (!commandParameter.hasPrefix() || commandParameter2.hasPrefix()) continue;
            throw new IllegalArgumentException("Prefixed parameters must comme first");
        }
        this.params.add(commandParameter);
        return this;
    }

    public String toString() {
        return String.format("%s", this.getName());
    }

    public static InputToken getToken(List<InputToken> list, int n) {
        if (list == null || n < 0 || n >= list.size()) {
            return null;
        }
        return list.get(n);
    }

    public static String getParameter(List<InputToken> list, int n) {
        InputToken inputToken = AbstractCommandHandler.getToken(list, n);
        if (inputToken == null) {
            return null;
        }
        return inputToken.getValue();
    }

    public static String getParameterSafe(List<InputToken> list, int n) {
        return Strings.safe(AbstractCommandHandler.getParameter(list, n));
    }

    @Override
    public int getOptions() {
        return this.options;
    }

    public AbstractCommandHandler setOptions(int n) {
        this.options = n;
        return this;
    }
}

