/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.format;

import com.pnfsoftware.jeb.util.format.Strings;

public class TextBuilder {
    private StringBuilder sb;
    private int indentationLevel;
    private int indentationSize;

    public TextBuilder() {
        this(4);
    }

    public TextBuilder(int n) {
        this(n, 16);
    }

    public TextBuilder(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.indentationSize = n;
        this.sb = new StringBuilder(n2);
    }

    public int length() {
        return this.sb.length();
    }

    public void clear() {
        this.sb.setLength(0);
    }

    public void updateIndentation(boolean bl2) {
        if (bl2) {
            this.indent();
        } else {
            this.unindent();
        }
    }

    public TextBuilder indent(boolean bl2) {
        ++this.indentationLevel;
        if (bl2) {
            this.eol();
        }
        return this;
    }

    public TextBuilder indent() {
        return this.indent(false);
    }

    public TextBuilder unindent() {
        if (this.indentationLevel == 0) {
            throw new IllegalStateException("Negative indentation level");
        }
        --this.indentationLevel;
        return this;
    }

    public TextBuilder append(byte by2) {
        return this.appendInternal(false, false, Byte.toString(by2), new Object[0]);
    }

    public TextBuilder append(char c) {
        return this.appendInternal(false, false, Character.toString(c), new Object[0]);
    }

    public TextBuilder append(short s2) {
        return this.appendInternal(false, false, Short.toString(s2), new Object[0]);
    }

    public TextBuilder append(int n) {
        return this.appendInternal(false, false, Integer.toString(n), new Object[0]);
    }

    public TextBuilder append(long l2) {
        return this.appendInternal(false, false, Long.toString(l2), new Object[0]);
    }

    public TextBuilder append(float f) {
        return this.appendInternal(false, false, Float.toString(f), new Object[0]);
    }

    public TextBuilder append(double d2) {
        return this.appendInternal(false, false, Double.toString(d2), new Object[0]);
    }

    public TextBuilder append(Object object) {
        return this.appendInternal(false, false, object == null ? "null" : object.toString(), new Object[0]);
    }

    public TextBuilder append(String string, Object ... objectArray) {
        return this.appendInternal(false, false, string, objectArray);
    }

    public TextBuilder appendLine(String string, Object ... objectArray) {
        return this.appendInternal(false, true, string, objectArray);
    }

    public TextBuilder appendLine(boolean bl2) {
        return this.appendInternal(bl2, true, "", new Object[0]);
    }

    public TextBuilder appendLine() {
        return this.appendLine(false);
    }

    public TextBuilder eol() {
        return this.appendLine();
    }

    public TextBuilder space() {
        return this.append(' ');
    }

    private TextBuilder appendInternal(boolean bl2, boolean bl3, String string, Object ... objectArray) {
        String string2 = "";
        if (!(bl2 || this.sb.length() != 0 && this.sb.charAt(this.sb.length() - 1) != '\n')) {
            string2 = string2 + Strings.generate(' ', this.indentationSize * this.indentationLevel);
        }
        string2 = objectArray.length == 0 ? string2 + string : string2 + String.format(string, objectArray);
        if (bl3) {
            string2 = string2 + Strings.LINESEP;
        }
        this.sb.append(string2);
        return this;
    }

    public void removeChar(int n) {
        this.sb.deleteCharAt(n);
    }

    public void removeChars(int n, int n2) {
        this.sb.delete(n, n2);
    }

    public void removeLastChar() {
        this.sb.deleteCharAt(this.sb.length() - 1);
    }

    public void removeLastLine() {
        int n = this.sb.lastIndexOf(Strings.LINESEP);
        if (n == -1) {
            n = 0;
        }
        this.sb.setLength(n);
    }

    String formatLastLine() {
        int n = this.sb.lastIndexOf(Strings.LINESEP);
        return n == -1 ? this.sb.toString() : this.sb.substring(n + Strings.LINESEP.length());
    }

    public String toString() {
        return this.sb.toString();
    }
}

