/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.encoding.zip;

import com.pnfsoftware.jeb.util.encoding.zip.GenericZipEntry;
import com.pnfsoftware.jeb.util.encoding.zip.IGenericJarBrowser;
import com.pnfsoftware.jeb.util.io.IO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarBrowserOracle
implements IGenericJarBrowser {
    private JarFile jar;
    private LinkedHashMap<String, GenericZipEntry<JarEntry>> entries = new LinkedHashMap();

    public JarBrowserOracle(File file, boolean bl2) throws IOException {
        this.jar = new JarFile(file, bl2);
        this.parseEntries();
    }

    private void parseEntries() {
        Enumeration<JarEntry> enumeration = this.jar.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            this.entries.put(jarEntry.getName(), new GenericZipEntry<JarEntry>(jarEntry));
        }
    }

    @Override
    public void close() throws IOException {
        this.jar.close();
    }

    @Override
    public Map<String, GenericZipEntry<?>> getEntries() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (String string : this.entries.keySet()) {
            linkedHashMap.put(string, this.entries.get(string));
        }
        return linkedHashMap;
    }

    @Override
    public GenericZipEntry<?> getEntry(String string) {
        return this.entries.get(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] readEntry(String string) throws IOException {
        GenericZipEntry<JarEntry> genericZipEntry = this.entries.get(string);
        if (genericZipEntry == null || genericZipEntry.isDirectory()) {
            throw new IOException(String.format("Entry %s is not a valid file entry", string));
        }
        try (InputStream inputStream = this.jar.getInputStream(genericZipEntry.getInternalEntry());){
            byte[] byArray2 = IO.readInputStream(inputStream);
            if ((long)byArray2.length != genericZipEntry.getSize()) {
                throw new IOException();
            }
            byte[] byArray = byArray2;
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public InputStream getEntryStream(String string) throws IOException {
        GenericZipEntry<JarEntry> genericZipEntry = this.entries.get(string);
        if (genericZipEntry == null || genericZipEntry.isDirectory()) {
            return null;
        }
        return this.jar.getInputStream(genericZipEntry.getInternalEntry());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Certificate[] getCertificates(String string) {
        GenericZipEntry<JarEntry> genericZipEntry = this.entries.get(string);
        if (genericZipEntry == null) return null;
        if (genericZipEntry.isDirectory()) {
            return null;
        }
        try (InputStream inputStream = this.jar.getInputStream(genericZipEntry.getInternalEntry());){
            byte[] byArray = IO.readInputStream(inputStream);
            if ((long)byArray.length != genericZipEntry.getSize()) {
                throw new IOException("Unexpected decompressed size");
            }
            Certificate[] certificateArray = genericZipEntry.getInternalEntry().getCertificates();
            return certificateArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

