/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.concurrent;

import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ProcessWrapper {
    private static final ILogger logger = GlobalLog.getLogger(ProcessWrapper.class);
    private static boolean killSpawnedProcessesOnShutdown = true;
    private static List<ProcessWrapper> processWrappers = Collections.synchronizedList(new ArrayList());
    private long timeout;
    private String[] cmdarray;
    private Process process;
    private OutputStream in;
    private InputStream out;
    private InputStream err;
    private Integer retcode;

    public static boolean isKillSpawnedProcessesOnShutdown() {
        return killSpawnedProcessesOnShutdown;
    }

    public static void setKillSpawnedProcessesOnShutdown(boolean bl2) {
        killSpawnedProcessesOnShutdown = bl2;
    }

    public ProcessWrapper(String ... stringArray) {
        this(-1L, stringArray);
    }

    public ProcessWrapper(long l2, String ... stringArray) {
        this.timeout = l2;
        this.cmdarray = stringArray;
    }

    public synchronized ProcessWrapper start() throws IOException {
        logger.i("Executing: \"%s\"", Strings.join(" ", Arrays.asList(this.cmdarray)));
        ProcessBuilder processBuilder = new ProcessBuilder(this.cmdarray);
        processBuilder.redirectErrorStream(true);
        this.process = processBuilder.start();
        this.in = this.process.getOutputStream();
        this.out = this.process.getInputStream();
        this.err = this.process.getErrorStream();
        processWrappers.add(this);
        if (this.timeout > 0L) {
            ThreadUtil.start(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(ProcessWrapper.this.timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ProcessWrapper.this.kill();
                }
            });
        }
        return this;
    }

    public synchronized void kill() {
        processWrappers.remove(this);
        if (this.isAlive()) {
            this.process.destroy();
            try {
                ProcessWrapper.waitFor(this.process, 500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.isAlive()) {
            return;
        }
        this.retcode = this.process.exitValue();
    }

    public void waitForCompletion() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.kill();
    }

    public synchronized boolean isAlive() {
        return this.process != null && ProcessWrapper.isAlive(this.process);
    }

    public synchronized OutputStream getProcessInput() {
        return this.in;
    }

    public synchronized InputStream getProcessOutput() {
        return this.out;
    }

    public synchronized InputStream getProcessError() {
        return this.err;
    }

    public synchronized Integer getReturnCode() {
        return this.retcode;
    }

    public String toString() {
        return String.format("Executing=%b,Command={%s}", this.process != null, Arrays.toString(this.cmdarray));
    }

    static boolean waitFor(Process process, long l2, TimeUnit timeUnit) throws InterruptedException {
        long l3 = System.nanoTime();
        long l4 = timeUnit.toNanos(l2);
        while (true) {
            try {
                process.exitValue();
                return true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                if (l4 <= 0L) continue;
                Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(l4) + 1L, 100L));
                if ((l4 = timeUnit.toNanos(l2) - (System.nanoTime() - l3)) > 0L) continue;
                return false;
            }
            break;
        }
    }

    static boolean isAlive(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!killSpawnedProcessesOnShutdown) {
                    return;
                }
                List list = processWrappers;
                synchronized (list) {
                    for (ProcessWrapper processWrapper : new ArrayList(processWrappers)) {
                        try {
                            if (!processWrapper.isAlive()) continue;
                            processWrapper.kill();
                        }
                        catch (Exception exception) {
                            logger.catchingSilent(exception);
                        }
                    }
                }
            }
        });
    }
}

