/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.serialization.DeserializerHelper;
import com.pnfsoftware.jeb.util.serialization.SerializerHelper;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInit;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomRead;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomWrite;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.pnfsoftware.jeb.util.serialization.annotations.SerVersion;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;

@Ser
@SerVersion(value=1)
public class WeakIdentityHashMap<K, V> {
    @SerTransient
    private HashMap<IdentityWeakKeyRef<K>, V> map;
    @SerTransient
    private ReferenceQueue<K> queue;
    @SerId(value=1)
    private int initialCapacity;
    @SerId(value=2)
    private float loadFactor;
    @SerTransient
    private List<Couple<K, V>> rlist;

    @SerCustomWrite
    private void save(SerializerHelper serializerHelper) throws IOException {
        this.expunge();
        serializerHelper.saveStandard();
        serializerHelper.write(this.toList());
    }

    @SerCustomRead
    private void load(DeserializerHelper deserializerHelper) throws IOException {
        if (deserializerHelper.getSerializedVersion() == 0) {
            ArrayList arrayList = (ArrayList)deserializerHelper.read();
            ArrayList arrayList2 = (ArrayList)deserializerHelper.read();
            this.rlist = new ArrayList<Couple<K, V>>(arrayList.size());
            for (int j = 0; j < arrayList.size(); ++j) {
                this.rlist.add(new Couple(arrayList.get(j), arrayList2.get(j)));
            }
            this.initialCapacity = 16;
            this.loadFactor = 0.75f;
        } else {
            deserializerHelper.loadStandard();
            this.rlist = (List)deserializerHelper.read();
        }
    }

    @SerCustomInit
    private void init() {
        this.queue = new ReferenceQueue();
        this.map = new HashMap(this.initialCapacity, this.loadFactor);
    }

    @SerCustomInitPostGraph
    private void postInit() {
        for (Couple<K, V> couple : this.rlist) {
            this.put(couple.getFirst(), couple.getSecond());
        }
        this.rlist = null;
    }

    List<Couple<K, V>> toList() {
        this.expunge();
        ArrayList<Couple<K, V>> arrayList = new ArrayList<Couple<K, V>>();
        for (Map.Entry<IdentityWeakKeyRef<K>, V> entry : this.map.entrySet()) {
            if (entry.getKey() == null) continue;
            arrayList.add(new Couple(entry.getKey().get(), entry.getValue()));
        }
        return arrayList;
    }

    public WeakIdentityHashMap(int n, float f) {
        this.initialCapacity = n;
        this.loadFactor = f;
        this.init();
    }

    public WeakIdentityHashMap(int n) {
        this(n, 0.75f);
    }

    public WeakIdentityHashMap() {
        this(16);
    }

    public V get(K k2) {
        this.expunge();
        return this.map.get(this.makeReference(k2));
    }

    public Set<K> keySet() {
        this.expunge();
        HashSet hashSet = new HashSet();
        for (IdentityWeakKeyRef<K> identityWeakKeyRef : this.map.keySet()) {
            Object t = identityWeakKeyRef.get();
            if (t == null) continue;
            hashSet.add(t);
        }
        return hashSet;
    }

    public int size() {
        this.expunge();
        int n = 0;
        for (IdentityWeakKeyRef<K> identityWeakKeyRef : this.map.keySet()) {
            Object t = identityWeakKeyRef.get();
            if (t == null) continue;
            ++n;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Collection<V> values() {
        this.expunge();
        return this.map.values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        this.expunge();
        HashSet<Map.Entry<K, V>> hashSet = new HashSet<Map.Entry<K, V>>();
        for (IdentityWeakKeyRef<K> identityWeakKeyRef : this.map.keySet()) {
            Object t = identityWeakKeyRef.get();
            if (t == null) continue;
            hashSet.add((Map.Entry<K, V>)new DefaultMapEntry(t, this.map.get(identityWeakKeyRef)));
        }
        return hashSet;
    }

    public V put(K k2, V v2) {
        this.expunge();
        if (k2 == null) {
            throw new IllegalArgumentException("Null key");
        }
        return this.putUnsafe(k2, v2);
    }

    public V putUnsafe(K k2, V v2) {
        return this.map.put(this.makeReference(k2, this.queue), v2);
    }

    public V remove(K k2) {
        this.expunge();
        return this.map.remove(this.makeReference(k2));
    }

    public String toString() {
        return this.map.toString();
    }

    private void expunge() {
        Reference<K> reference;
        while ((reference = this.queue.poll()) != null) {
            this.map.remove(reference);
        }
    }

    private IdentityWeakKeyRef<K> makeReference(K k2) {
        return new IdentityWeakKeyRef<K>(k2);
    }

    private IdentityWeakKeyRef<K> makeReference(K k2, ReferenceQueue<K> referenceQueue) {
        return new IdentityWeakKeyRef<K>(k2, referenceQueue);
    }

    @SerDisabled
    private static class IdentityWeakKeyRef<K>
    extends WeakReference<K> {
        private final int hashCode;

        IdentityWeakKeyRef(K k2) {
            this(k2, (ReferenceQueue<K>)null);
        }

        IdentityWeakKeyRef(K k2, ReferenceQueue<K> referenceQueue) {
            super(k2, referenceQueue);
            this.hashCode = k2 == null ? 0 : System.identityHashCode(k2);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof IdentityWeakKeyRef)) {
                return false;
            }
            IdentityWeakKeyRef identityWeakKeyRef = (IdentityWeakKeyRef)object;
            Object t = this.get();
            return t != null && t == identityWeakKeyRef.get();
        }

        public String toString() {
            Object t = this.get();
            return t == null ? null : t.toString();
        }
    }
}

