/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInit;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

@Ser
public class SynchronizedLinkedSet<E> {
    @SerId(value=1)
    private LinkedHashSet<E> set0 = new LinkedHashSet();
    @SerTransient
    private Set<E> set;

    @SerCustomInit
    private void init() {
        this.set = Collections.synchronizedSet(this.set0);
    }

    public SynchronizedLinkedSet() {
        this.init();
    }

    public int size() {
        return this.set.size();
    }

    public void clear() {
        this.set.clear();
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public boolean contains(E e2) {
        return this.set.contains(e2);
    }

    public boolean add(E e2) {
        if (e2 == null) {
            throw new NullPointerException("Illegal null key");
        }
        return this.set.add(e2);
    }

    public boolean remove(E e2) {
        return this.set.remove(e2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<E> copyOfEntries() {
        Set<E> set = this.set;
        synchronized (set) {
            return new LinkedHashSet<E>(this.set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E firstEntry() {
        Set<E> set = this.set;
        synchronized (set) {
            return this.set.iterator().next();
        }
    }

    public String toString() {
        return this.set.toString();
    }
}

