/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Ser
public class ReferenceCounter<K> {
    @SerId(value=1)
    private Map<K, Integer> map = new HashMap<K, Integer>();

    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    public synchronized int size() {
        return this.map.size();
    }

    public synchronized int getCount() {
        int n = 0;
        for (int n2 : this.map.values()) {
            n += n2;
        }
        return n;
    }

    public synchronized int inc(K k2) {
        Integer n = this.map.get(k2);
        if (n == null) {
            n = 1;
        } else {
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
            if (n < 0) {
                throw new IllegalStateException("Counter overflow");
            }
        }
        this.map.put(k2, n);
        return n;
    }

    public synchronized int dec(K k2) {
        Integer n = this.map.get(k2);
        if (n == null) {
            throw new IllegalArgumentException("Key is not present");
        }
        if (n <= 0) {
            throw new RuntimeException("Count is <= 0");
        }
        Integer n2 = n;
        Integer n3 = n = Integer.valueOf(n - 1);
        if (n == 0) {
            this.map.remove(k2);
        } else {
            this.map.put(k2, n);
        }
        return n;
    }

    public synchronized boolean has(K k2) {
        return this.map.containsKey(k2);
    }

    public synchronized int get(K k2) {
        Integer n = this.map.get(k2);
        return n == null ? 0 : n;
    }

    public synchronized Map<K, Integer> getAsMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public synchronized boolean remove(K k2) {
        return this.map.remove(k2) != null;
    }

    public synchronized void load(Collection<? extends K> collection) {
        for (K k2 : collection) {
            this.inc(k2);
        }
    }

    public synchronized Set<K> keys() {
        return new HashSet<K>(this.map.keySet());
    }

    public synchronized String toString() {
        return this.map.toString();
    }

    public synchronized String formatAllReferences() {
        return this.formatTopReferences(-1);
    }

    public synchronized String formatTopReferences(int n) {
        ArrayList<Map.Entry<K, Integer>> arrayList = new ArrayList<Map.Entry<K, Integer>>(this.map.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<K, Integer>>(){

            @Override
            public int compare(Map.Entry<K, Integer> entry, Map.Entry<K, Integer> entry2) {
                return -Integer.compare(entry.getValue(), entry2.getValue());
            }
        });
        int n2 = n < 0 ? arrayList.size() : Math.min(n, arrayList.size());
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : arrayList.subList(0, n2)) {
            stringBuilder.append(String.format("- %d: %s\n", object.getValue(), object.getKey()));
            n3 += ((Integer)object.getValue()).intValue();
        }
        int n4 = n3;
        for (Map.Entry entry : arrayList.subList(n2, arrayList.size())) {
            n4 += ((Integer)entry.getValue()).intValue();
        }
        double d2 = (double)n3 / (double)n4 * 100.0;
        if (n >= 0) {
            stringBuilder.insert(0, String.format("%d/%d top entries (%.2f%% of %d)\n", n2, arrayList.size(), d2, n4));
        }
        return stringBuilder.toString();
    }
}

