/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CacheMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private final int maxSize;
    private final int evictSize;
    private final List<Object> accessList = new ArrayList<Object>();

    public CacheMap(int n, int n2) {
        this.maxSize = n;
        this.evictSize = n2;
    }

    public CacheMap(int n) {
        this(n, 1);
    }

    private void evict() {
        Iterator<Object> iterator = this.accessList.iterator();
        for (int j = 0; j < this.evictSize; ++j) {
            if (!iterator.hasNext()) {
                return;
            }
            Object object = iterator.next();
            this.remove(object);
            iterator.remove();
        }
    }

    private int searchAccessList(Object object) {
        return this.accessList.indexOf(object);
    }

    private void accessEntry(Object object) {
        int n = this.searchAccessList(object);
        if (n >= 0) {
            this.accessList.remove(n);
        }
        this.accessList.add(object);
    }

    @Override
    public V put(K k2, V v2) {
        if (this.size() >= this.maxSize) {
            this.evict();
        }
        this.accessEntry(k2);
        return super.put(k2, v2);
    }

    @Override
    public V get(Object object) {
        this.accessEntry(object);
        return super.get(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException("putAll() operations are not supported on a cache map");
    }
}

